/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network;

import com.google.common.collect.Maps;
import doggytalents.common.lib.Constants;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.util.Util;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DTNNetworkHandler {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/network");
    public static final CustomPacketPayload.Type<DTNNetworkPayload<?>> CHANNEL_ID = new CustomPacketPayload.Type(Util.getResource("payload_channel"));
    private static Map<Integer, PacketCodec<?>> PACKET_MAP = Maps.newHashMap();
    private static Map<Class<?>, Integer> DATACLASS_ID_MAP = Maps.newHashMap();
    private static final DTNNetworkPayload<Object> ERROR_DATA = new DTNNetworkPayload<Object>(null, null);

    public static void init() {
    }

    public static synchronized <D> void registerMessage(int id, Class<D> dataClass, BiConsumer<D, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, D> decoder, BiConsumer<D, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_MAP.put(id, new PacketCodec<D>(dataClass, encoder, decoder, messageConsumer));
        DATACLASS_ID_MAP.put(dataClass, id);
    }

    public static <D> void send(PacketDistributor.PacketTarget<?> target, D data) {
        Integer dataId = DATACLASS_ID_MAP.get(data.getClass());
        if (dataId == null) {
            return;
        }
        PacketCodec<?> codec = null;
        try {
            codec = PACKET_MAP.get(dataId);
        }
        catch (ClassCastException e) {
            codec = null;
            LOGGER.error("What ? [" + String.valueOf(e) + "]");
        }
        if (codec == null) {
            return;
        }
        DTNNetworkPayload<D> payload = new DTNNetworkPayload<D>(data, codec);
        target.sendPacket(payload);
    }

    public static void onRegisterPayloadEvent(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registerer = event.registrar(Constants.PROTOCOL_VERSION);
        StreamCodec rw_stream_codec = StreamCodec.of(DTNNetworkHandler::toBuf, DTNNetworkHandler::fromBuf);
        IPayloadHandler payload_handler = DTNNetworkHandler::handlePayload;
        registerer.commonBidirectional(CHANNEL_ID, rw_stream_codec, payload_handler);
    }

    private static DTNNetworkPayload<?> fromBuf(FriendlyByteBuf buf) {
        int id = buf.readInt();
        if (id < 0) {
            return ERROR_DATA;
        }
        PacketCodec<?> packet = PACKET_MAP.get(id);
        if (packet == null) {
            return ERROR_DATA;
        }
        DTNNetworkPayload<Object> ret = null;
        try {
            ret = DTNNetworkHandler.decodeWithDecoder(packet, buf);
        }
        catch (Exception e) {
            LOGGER.error("Decoding packet failed with decoder_id [" + id + "]  data [" + packet.dataClass.getName() + "] error_message [" + e.getMessage() + "]");
            ret = ERROR_DATA;
        }
        return ret;
    }

    private static <T> DTNNetworkPayload<T> decodeWithDecoder(PacketCodec<T> codec, FriendlyByteBuf buf) {
        T data = codec.decode(buf);
        return new DTNNetworkPayload<T>(data, codec);
    }

    private static void toBuf(FriendlyByteBuf buf, DTNNetworkPayload<?> payload) {
        if (payload == ERROR_DATA) {
            buf.writeInt(-1);
            return;
        }
        Integer dataId = DATACLASS_ID_MAP.get(payload.data.getClass());
        if (dataId == null) {
            buf.writeInt(-1);
            return;
        }
        buf.writeInt(dataId.intValue());
        DTNNetworkHandler.encodePayloadDataToBuf(payload, buf);
    }

    private static <T> void encodePayloadDataToBuf(DTNNetworkPayload<T> payload, FriendlyByteBuf buf) {
        payload.codec.encode(buf, payload.data);
    }

    private static void handlePayload(DTNNetworkPayload<?> payload, IPayloadContext context) {
        if (payload == ERROR_DATA || payload.data == null || payload.codec == null) {
            LOGGER.error("Recieved error data!");
            return;
        }
        NetworkEvent.Context ctx = new NetworkEvent.Context(context);
        DTNNetworkHandler.handleForCodec(payload, ctx);
    }

    private static <T> void handleForCodec(DTNNetworkPayload<T> payload, NetworkEvent.Context ctx) {
        payload.codec.consume(payload.data, ctx);
    }

    private static class PacketCodec<T> {
        public final Class<T> dataClass;
        public final BiConsumer<T, FriendlyByteBuf> encoder;
        public final Function<FriendlyByteBuf, T> decoder;
        public final BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer;

        PacketCodec(Class<T> dataClass, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
            this.dataClass = dataClass;
            this.encoder = encoder;
            this.decoder = decoder;
            this.messageConsumer = messageConsumer;
        }

        public void consume(T data, NetworkEvent.Context ctx) {
            this.messageConsumer.accept(data, () -> ctx);
        }

        public T decode(FriendlyByteBuf buf) {
            return this.decoder.apply(buf);
        }

        public void encode(FriendlyByteBuf buf, T data) {
            this.encoder.accept(data, buf);
        }
    }

    private static class DTNNetworkPayload<T>
    implements CustomPacketPayload {
        private final T data;
        private final PacketCodec<T> codec;

        public DTNNetworkPayload(T data, PacketCodec<T> codec) {
            this.data = data;
            this.codec = codec;
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return CHANNEL_ID;
        }
    }

    public static class NetworkEvent {

        public static class Context {
            private final IPayloadContext wrapped_ctx;

            public Context(IPayloadContext ctx) {
                this.wrapped_ctx = ctx;
            }

            public void enqueueWork(Runnable runnable) {
                this.wrapped_ctx.enqueueWork(runnable);
            }

            @Nullable
            public ServerPlayer getSender() {
                if (this.isServerRecipent()) {
                    return (ServerPlayer)this.wrapped_ctx.player();
                }
                return null;
            }

            public boolean isClientRecipent() {
                return !this.isServerRecipent();
            }

            public boolean isServerRecipent() {
                return this.wrapped_ctx.flow() == PacketFlow.SERVERBOUND;
            }

            public void setPacketHandled(boolean x) {
            }
        }
    }
}

