/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.sound;

import doggytalents.common.entity.Dog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class DogInterruptibleSoundInstance
extends AbstractTickableSoundInstance {
    private static final int FADE_OUT_TIME = 5;
    private final Dog dog;
    private int stoppingTick = 0;
    private boolean isStopping = false;
    private float fadeSpeed = 0.0f;

    public DogInterruptibleSoundInstance(Dog dog, SoundEvent event, float vol, float pitch) {
        super(event, SoundSource.NEUTRAL, SoundInstance.m_235150_());
        this.dog = dog;
        this.f_119573_ = vol;
        this.f_119574_ = pitch;
        this.f_119575_ = (float)dog.m_20185_();
        this.f_119576_ = (float)dog.m_20186_();
        this.f_119577_ = (float)dog.m_20189_();
    }

    public void dogInterupt() {
        this.isStopping = true;
        this.f_119573_ /= 4.0f;
        this.fadeSpeed = this.f_119573_ / 5.0f;
    }

    public void m_7788_() {
        if (this.isStopping) {
            this.tickStop();
            return;
        }
        this.updatePositionVolumeOrInvalidate();
    }

    private void updatePositionVolumeOrInvalidate() {
        if (!this.dog.m_6084_()) {
            this.dogInterupt();
            return;
        }
        this.f_119575_ = (float)this.dog.m_20185_();
        this.f_119576_ = (float)this.dog.m_20186_();
        this.f_119577_ = (float)this.dog.m_20189_();
    }

    private void tickStop() {
        ++this.stoppingTick;
        this.f_119573_ = Math.max(0.0f, this.f_119573_ - this.fadeSpeed);
    }

    public boolean m_7801_() {
        return super.m_7801_() || this.isStopping && this.stoppingTick > 5;
    }

    public boolean m_7775_() {
        return false;
    }

    public boolean m_7767_() {
        return !this.dog.m_20067_();
    }

    public static DogInterruptibleSoundInstance createAndPlayClient(Dog dog, SoundEvent event, float vol, float pitch) {
        DogInterruptibleSoundInstance inst = new DogInterruptibleSoundInstance(dog, event, vol, pitch);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)inst);
        return inst;
    }
}

