/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView;

import doggytalents.DoggyEntityTypes;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView.DogSkinElement;
import doggytalents.client.screen.DogNewInfoScreen.element.view.StyleView.view.SkinView.SkinButtonElement;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.SkinListSlice;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.client.screen.framework.widget.ScrollBar;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class SkinView
extends AbstractElement {
    Dog dog;
    List<DogSkin> textureList;
    Dog dummyDog;
    EditBox filterBox;
    ScrollBar scrollBar;
    FlatButton searchModeButton;
    boolean searchByTag;
    int activeSkinId;
    boolean skipReOffset;

    public SkinView(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        this.dummyDog = this.createDummyDog();
        this.filterBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 100, 16, (Component)Component.m_237119_());
        this.filterBox.m_94151_(str -> {
            this.m_6702_().clear();
            this.activeSkinId = 0;
            this.init();
        });
        this.scrollBar = new ScrollBar(0, 0, 0, 0, ScrollBar.Direction.HORIZONTAL, 0, this.getScreen()){

            @Override
            public void onValueUpdated() {
                SkinView.this.calulateAndSetActiveId(this.getProgressValue());
            }
        };
        this.activeSkinId = DogTextureManager.INSTANCE.getAll().indexOf(dog.getClientSkin());
        this.searchByTag = false;
        this.searchModeButton = new FlatButton(0, 0, 100, 20, (Component)Component.m_237115_((String)"doggui.style.skins.search_by_name"), b -> {
            this.searchByTag = !this.searchByTag;
            b.m_93666_((Component)(this.searchByTag ? Component.m_237115_((String)"doggui.style.skins.search_by_tags") : Component.m_237115_((String)"doggui.style.skins.search_by_name")));
        });
    }

    @Override
    public AbstractElement init() {
        this.textureList = this.getStateAndSubscribesTo(SkinListSlice.class, SkinListSlice.SkinListData.class, SkinListSlice.SkinListData.EMPTY).skins;
        this.textureList = this.filterValidDogSkin(this.textureList);
        String searchMsg = this.filterBox.m_94155_();
        if (!searchMsg.isEmpty()) {
            this.textureList = this.filterDogSkin(this.textureList, searchMsg);
        }
        if (this.activeSkinId < 0) {
            this.activeSkinId = 0;
        } else if (this.activeSkinId >= this.textureList.size()) {
            this.activeSkinId = 0;
        }
        this.getPosition().setChildDirection(ElementPosition.ChildDirection.COL);
        DogSkinElement dogSkinPreview = new DogSkinElement(this, this.getScreen(), this.dog, this.dummyDog, this.textureList, this.activeSkinId);
        dogSkinPreview.setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 0.8f).setBackgroundColor(-2026490314).init();
        this.addChildren((GuiEventListener)dogSkinPreview);
        SkinButtonElement skinSelect = new SkinButtonElement(this, this.getScreen(), this.dog, this.textureList, this.activeSkinId, b -> this.decreaseActiveId((GuiEventListener)b), b -> this.increaseActiveId((GuiEventListener)b));
        skinSelect.setPosition(ElementPosition.PosType.RELATIVE, 0, 0).setSize(1.0f, 0.2f).setBackgroundColor(1079597144).init();
        this.addChildren((GuiEventListener)skinSelect);
        this.filterBox.m_252865_(this.getRealX() + 8);
        this.filterBox.m_253211_(this.getRealY() + 8);
        this.addChildren((GuiEventListener)this.filterBox);
        this.scrollBar.m_252865_(this.getRealX());
        this.scrollBar.m_253211_(this.getRealY() + this.getSizeY() - 8);
        this.scrollBar.m_93674_(this.getSizeX());
        this.scrollBar.setHeight(8);
        int barsize = 0;
        if (!this.textureList.isEmpty()) {
            barsize = Mth.m_14143_((float)(this.scrollBar.m_5711_() / this.textureList.size()));
            barsize = Math.max(barsize, 20);
        }
        this.scrollBar.setBarSize(barsize);
        if (this.skipReOffset) {
            this.skipReOffset = false;
        } else {
            this.moveBarToDog();
        }
        this.addChildren((GuiEventListener)this.scrollBar);
        this.searchModeButton.m_252865_(this.getRealX() + this.getSizeX() - 107);
        this.searchModeButton.m_253211_(this.getRealY() + 7);
        this.addChildren((GuiEventListener)this.searchModeButton);
        return this;
    }

    private void moveBarToDog() {
        if (this.textureList.isEmpty()) {
            return;
        }
        double progress = (double)this.activeSkinId / (double)(this.textureList.size() - 1);
        double barOffset = progress * (double)this.scrollBar.getMaxOffsetValue();
        this.scrollBar.setBarOffset(barOffset);
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    private List<DogSkin> filterDogSkin(List<DogSkin> locList, String s) {
        if (this.searchByTag) {
            return this.filterDogSkinByTag(locList, s);
        }
        ArrayList<DogSkin> ret = new ArrayList<DogSkin>();
        for (DogSkin x : locList) {
            if (!StringUtils.containsIgnoreCase((CharSequence)x.getName(), (CharSequence)s)) continue;
            ret.add(x);
        }
        return ret;
    }

    private List<DogSkin> filterDogSkinByTag(List<DogSkin> locList, String s) {
        String[] tag_strs = s.split(Pattern.quote(" "));
        ArrayList<DogSkin> ret = new ArrayList<DogSkin>();
        for (DogSkin x : locList) {
            if (!this.isTagMatch(x, tag_strs)) continue;
            ret.add(x);
        }
        return ret;
    }

    private boolean isTagMatch(DogSkin skin, String[] tag_strs) {
        for (String str : tag_strs) {
            if (StringUtils.containsIgnoreCase((CharSequence)skin.getTags(), (CharSequence)str)) continue;
            return false;
        }
        return true;
    }

    private List<DogSkin> filterValidDogSkin(List<DogSkin> locList) {
        if (ConfigHandler.DogCustomSkinConfig.getStrategy() == ConfigHandler.DogCustomSkinConfig.DataStrategy.NONE) {
            return locList;
        }
        ArrayList<DogSkin> filtered = new ArrayList<DogSkin>(locList.size());
        for (DogSkin filter : locList) {
            String hash = DogTextureManager.INSTANCE.getHash(filter);
            if (!DogUtil.vertifySkinData(hash)) continue;
            filtered.add(filter);
        }
        return filtered;
    }

    private void decreaseActiveId(GuiEventListener b) {
        this.activeSkinId = Math.max(0, this.activeSkinId - 1);
        this.m_6702_().clear();
        this.init();
    }

    private void increaseActiveId(GuiEventListener b) {
        this.activeSkinId = Math.min(this.textureList.size() - 1, this.activeSkinId + 1);
        this.m_6702_().clear();
        this.init();
    }

    private void calulateAndSetActiveId(double progress) {
        int id = Mth.m_14107_((double)(progress * (double)(this.textureList.size() - 1)));
        if (this.activeSkinId == id) {
            return;
        }
        this.activeSkinId = id;
        this.skipReOffset = true;
        this.m_6702_().clear();
        this.init();
    }

    private Dog createDummyDog() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Dog dog = (Dog)((EntityType)DoggyEntityTypes.DOG.get()).m_20615_((Level)level);
        return dog;
    }
}

