/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.widget.DoggySpin;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.DogVariants;
import doggytalents.client.entity.model.animation.DogAnimationSequences;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.entity.model.dog.AmaterasuModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.oina.HopeModel;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.lib.Resources;
import doggytalents.common.variant.DogVariant;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class DoggySpinModel {
    private static DoggySpinModel INSTANCE = null;
    private Style style = Style.CHOPIN;
    private DogVariant variant = DogVariant.PALE;
    private int collarColor = -5231066;
    private static final List<Supplier<DogVariant>> possibleVariants = List.of(DogVariants.PALE, DogVariants.CHESTNUT, DogVariants.RUSTY, DogVariants.WOOD, DogVariants.STRIPED, DogVariants.SPOTTED, DogVariants.ASHEN, DogVariants.SNOWY, DogVariants.BLACK, DogVariants.MOLTEN, DogVariants.HIMALAYAN_SALT, DogVariants.CHERRY);
    private static final int[] possibleColors = new int[]{-5231066, -8337633, -12827478, -3715395, -15295332, -12930086, -816214, -7785800, -425955, -75715, -8170446, -14869215, -10585066};
    private static final Random random = new Random();
    private ModelPart root;
    private ModelPart tail;
    private ModelPart rootAmmy;
    private ModelPart tailAmmy;
    private ModelPart rootHope;
    private ModelPart tailHope;
    private Vector3f buf = new Vector3f();
    public static final AnimationDefinition TAIL_CHASE_LOOP = AnimationDefinition.Builder.m_232275_((float)1.75f).m_232274_().m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)2.25f, (float)-1.0f, (float)1.75f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)2.25f, (float)-1.0f, (float)1.75f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)-90.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("body", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)-1.17f, (float)-2.22f, (float)-1.55f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)-1.17f, (float)-2.22f, (float)-1.55f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("body", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-0.76f, (float)16.57f, (float)8.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)-0.76f, (float)16.57f, (float)8.5f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)1.4f, (float)-0.14f, (float)-0.79f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253126_((float)0.25f, (float)-0.14f, (float)-1.27f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)1.4f, (float)-0.14f, (float)-0.79f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("right_hind_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)16.52f, (float)-3.33f, (float)-9.87f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.7083434f, KeyframeAnimations.m_253186_((float)16.52f, (float)-3.33f, (float)-9.87f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9583434f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.1676667f, KeyframeAnimations.m_253186_((float)16.52f, (float)-3.33f, (float)-9.87f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.375f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.625f, KeyframeAnimations.m_253186_((float)16.52f, (float)-3.33f, (float)-9.87f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)32.5f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)-1.0f, (float)-2.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)-1.0f, (float)-2.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_hind_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)16.37f, (float)5.96f, (float)-12.31f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.6766666f, KeyframeAnimations.m_253186_((float)16.37f, (float)5.96f, (float)-12.31f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9583434f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.125f, KeyframeAnimations.m_253186_((float)16.37f, (float)5.96f, (float)-12.31f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.375f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.625f, KeyframeAnimations.m_253186_((float)16.37f, (float)5.96f, (float)-12.31f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-27.5f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("right_front_leg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.67f, (float)-1.28f, (float)-0.65f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)0.67f, (float)-1.28f, (float)-0.65f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("right_front_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-36.72f, (float)-1.14f, (float)8.05f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-30.04f, (float)-1.13f, (float)-8.27f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-36.72f, (float)-1.14f, (float)8.05f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.7083434f, KeyframeAnimations.m_253186_((float)-30.04f, (float)-1.13f, (float)-8.27f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)-36.72f, (float)-1.14f, (float)8.05f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_front_leg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)-1.25f, (float)2.75f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)-1.25f, (float)2.75f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_front_leg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)9.01f, (float)-20.7f, (float)-24.15f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)9.01f, (float)-20.7f, (float)-24.15f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("tail", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)1.7f, (float)-2.68f, (float)-1.66f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)1.7f, (float)-2.68f, (float)-1.66f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("tail", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)0.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.7083434f, KeyframeAnimations.m_253186_((float)0.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9583434f, KeyframeAnimations.m_253186_((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.1676667f, KeyframeAnimations.m_253186_((float)0.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.375f, KeyframeAnimations.m_253186_((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.625f, KeyframeAnimations.m_253186_((float)0.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.8343333f, KeyframeAnimations.m_253186_((float)120.0f, (float)13.33f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("upper_body", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)-0.06f, (float)-2.33f, (float)-0.32f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)-0.06f, (float)-2.33f, (float)-0.32f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("upper_body", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-4.75f, (float)-36.46f, (float)-8.92f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)-4.75f, (float)-36.46f, (float)-8.92f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.9583434f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-30.0f, (float)-360.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)15.0f, (float)-720.0f, (float)25.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.4167666f, KeyframeAnimations.m_253186_((float)0.0f, (float)-1080.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)-1440.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("right_ear", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("right_ear", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-45.19f, (float)-0.15f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_ear", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)-0.25f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("left_ear", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-32.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232282_();

    public static DoggySpinModel get() {
        if (INSTANCE == null) {
            throw new IllegalStateException("DoggySpinModel is not initilized. If this exception get thrown again, please disable DTN world load icon and report to the DTN Server.");
        }
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new DoggySpinModel();
    }

    private DoggySpinModel() {
        this.root = DogModel.createBodyLayer().m_171564_();
        this.rootAmmy = AmaterasuModel.createBodyLayer().m_171564_();
        this.rootHope = HopeModel.createBodyLayer().m_171564_();
        this.tail = this.root.m_171324_("tail");
        this.tailAmmy = this.rootAmmy.m_171324_("tail");
        this.tailHope = this.rootHope.m_171324_("tail");
    }

    private ModelPart getRootForStyle() {
        if (this.style == Style.AMMY) {
            return this.rootAmmy;
        }
        if (this.style == Style.HOPE) {
            return this.rootHope;
        }
        return this.root;
    }

    private ModelPart getTailForStyle() {
        if (this.style == Style.AMMY) {
            return this.tailAmmy;
        }
        if (this.style == Style.HOPE) {
            return this.tailHope;
        }
        return this.tail;
    }

    private void pickDogVariant() {
        if (possibleVariants.isEmpty()) {
            return;
        }
        int random_indx = random.nextInt(possibleVariants.size());
        this.variant = possibleVariants.get(random_indx).get();
    }

    private void pickCollarColor() {
        if (possibleColors.length <= 0) {
            return;
        }
        int random_indx = random.nextInt(possibleColors.length);
        this.collarColor = possibleColors[random_indx];
    }

    public void configureRandomStyle() {
        float r = random.nextFloat();
        Style selected_style = Style.CHOPIN;
        selected_style = r >= 0.5f ? Style.CHOPIN : (r >= 0.27f ? Style.BACKFLIP : (r >= 0.04f ? Style.SIT : (((Boolean)ConfigHandler.CLIENT.AMMY_SPINNA.get()).booleanValue() ? (r >= 0.01f ? Style.AMMY : Style.HOPE) : Style.BACKFLIP)));
        this.style = selected_style;
        if (this.style != Style.AMMY && this.style != Style.HOPE) {
            this.pickCollarColor();
            this.pickDogVariant();
        }
    }

    private void resetPart(ModelPart part) {
        if (part == this.getTailForStyle()) {
            part.m_233569_();
            this.getTailForStyle().f_104203_ = 1.73f;
            return;
        }
        part.m_233569_();
    }

    public void resetAllPose() {
        if (this.style == Style.AMMY) {
            this.rootAmmy.m_171331_().forEach(x -> x.m_233569_());
            return;
        }
        if (this.style == Style.HOPE) {
            this.rootHope.m_171331_().forEach(x -> x.m_233569_());
            return;
        }
        this.root.m_171331_().forEach(x -> x.m_233569_());
    }

    public void prepareRender(long elapsed_millis) {
        this.resetAllPose();
        if (this.style == Style.CHOPIN || this.style == Style.AMMY || this.style == Style.HOPE) {
            long len_millis = Mth.m_14167_((float)(TAIL_CHASE_LOOP.f_232255_() * 1000.0f));
            long passed_millis = elapsed_millis % len_millis;
            AnimationDefinition seq = TAIL_CHASE_LOOP;
            DogKeyframeAnimations.keyframeAnimate(DogKeyframeAnimations.AnimationContext.of(name -> DogKeyframeAnimations.searchForPartWithName(this.getRootForStyle(), name), this::resetPart), seq, passed_millis, 1.0f, this.buf);
        } else if (this.style == Style.SIT) {
            long len_millis = Mth.m_14167_((float)(DogAnimationSequences.SIT_LOOK_AROUND.f_232255_() * 1000.0f));
            long passed_millis = (long)Mth.m_14143_((float)((float)elapsed_millis * 1.7f)) % len_millis;
            AnimationDefinition seq = DogAnimationSequences.SIT_LOOK_AROUND;
            DogKeyframeAnimations.keyframeAnimate(DogKeyframeAnimations.AnimationContext.of(name -> DogKeyframeAnimations.searchForPartWithName(this.getRootForStyle(), name), this::resetPart), seq, passed_millis, 1.0f, this.buf);
        } else if (this.style == Style.BACKFLIP) {
            long len_millis = Mth.m_14167_((float)(DogAnimationSequences.BACKFLIP.f_232255_() * 1000.0f));
            long passed_millis = elapsed_millis % len_millis;
            AnimationDefinition seq = DogAnimationSequences.BACKFLIP;
            DogKeyframeAnimations.keyframeAnimate(DogKeyframeAnimations.AnimationContext.of(name -> DogKeyframeAnimations.searchForPartWithName(this.getRootForStyle(), name), this::resetPart), seq, passed_millis, 1.0f, this.buf);
        }
    }

    public void renderGui(GuiGraphics graphics, float mid_x, float mid_y) {
        Quaternionf rotation;
        int scale = 70;
        Vector3f offset = new Vector3f(0.0f, 0.4375f, 0.0f);
        if (this.style == Style.CHOPIN || this.style == Style.AMMY || this.style == Style.HOPE) {
            rotation = Axis.f_252529_.m_252977_(15.0f);
        } else if (this.style == Style.BACKFLIP) {
            rotation = Axis.f_252529_.m_252977_(4.0f).mul((Quaternionfc)Axis.f_252436_.m_252977_(20.0f));
            offset.sub(0.0f, -0.15f, 0.0f);
        } else {
            rotation = Axis.f_252529_.m_252977_(10.0f);
            offset.sub(0.0f, -0.08f, 0.0f);
        }
        this.renderGui(graphics, mid_x, mid_y, scale, offset, rotation);
    }

    public void renderGui(GuiGraphics graphics, float mid_x, float mid_y, float scale, Vector3f offset, Quaternionf rot) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_((double)mid_x, (double)mid_y, 50.0);
        graphics.m_280168_().m_252931_(new Matrix4f().scaling(scale, scale, -scale));
        graphics.m_280168_().m_252880_(offset.x, offset.y, offset.z);
        graphics.m_280168_().m_252781_(rot);
        graphics.m_280168_().m_252880_(0.0f, -1.501f, 0.0f);
        Lighting.m_166384_();
        RenderSystem.runAsFancy(() -> this.doRenderModel(graphics.m_280168_(), (MultiBufferSource)graphics.m_280091_()));
        graphics.m_280262_();
        graphics.m_280168_().m_85849_();
        Lighting.m_84931_();
    }

    private void doRenderModel(PoseStack stack, MultiBufferSource source) {
        if (this.style == Style.AMMY) {
            this.doRenderModelWithTexture(stack, source, true, Resources.OKAMI_AMATERASU, -1);
            return;
        }
        if (this.style == Style.HOPE) {
            this.doRenderModelWithTexture(stack, source, true, Resources.SOL_HOPE, -1);
            return;
        }
        this.doRenderModelWithTexture(stack, source, false, this.variant.texture(), -1);
        this.doRenderModelWithTexture(stack, source, false, Resources.COLLAR_THICC, this.collarColor);
    }

    private void doRenderModelWithTexture(PoseStack stack, MultiBufferSource source, boolean translucent, ResourceLocation loc, int color) {
        RenderType renderType = translucent ? RenderType.m_110473_((ResourceLocation)loc) : RenderType.m_110458_((ResourceLocation)loc);
        VertexConsumer buffer = source.m_6299_(renderType);
        this.renderToBuffer(stack, buffer, 0xF000F0, OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false)), color);
    }

    public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay_coord, int color_overlay) {
        ModelPart root = this.getRootForStyle();
        Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;
        stack.m_85836_();
        stack.m_85837_((double)(root.f_104200_ / 16.0f), (double)(root.f_104201_ / 16.0f), (double)(root.f_104202_ / 16.0f));
        stack.m_85837_((double)(pivot.x / 16.0f), (double)(pivot.y / 16.0f), (double)(pivot.z / 16.0f));
        if (root.f_104205_ != 0.0f) {
            stack.m_252781_(Axis.f_252403_.m_252961_(root.f_104205_));
        }
        if (root.f_104204_ != 0.0f) {
            stack.m_252781_(Axis.f_252436_.m_252961_(root.f_104204_));
        }
        if (root.f_104203_ != 0.0f) {
            stack.m_252781_(Axis.f_252529_.m_252961_(root.f_104203_));
        }
        float xRot0 = root.f_104203_;
        float yRot0 = root.f_104204_;
        float zRot0 = root.f_104205_;
        float x0 = root.f_104200_;
        float y0 = root.f_104201_;
        float z0 = root.f_104202_;
        root.f_104203_ = 0.0f;
        root.f_104204_ = 0.0f;
        root.f_104205_ = 0.0f;
        root.f_104200_ = 0.0f;
        root.f_104201_ = 0.0f;
        root.f_104202_ = 0.0f;
        stack.m_85836_();
        stack.m_85837_((double)(-pivot.x / 16.0f), (double)(-pivot.y / 16.0f), (double)(-pivot.z / 16.0f));
        root.m_104306_(stack, consumer, light, overlay_coord, (float)FastColor.ARGB32.m_13665_((int)color_overlay) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color_overlay) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color_overlay) / 255.0f, (float)FastColor.ARGB32.m_13655_((int)color_overlay) / 255.0f);
        stack.m_85849_();
        stack.m_85849_();
        root.f_104203_ = xRot0;
        root.f_104204_ = yRot0;
        root.f_104205_ = zRot0;
        root.f_104200_ = x0;
        root.f_104201_ = y0;
        root.f_104202_ = z0;
    }

    public static enum Style {
        CHOPIN,
        BACKFLIP,
        SIT,
        AMMY,
        HOPE;

    }
}

