/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class DogGroupsManager {
    public static final int MAX_GROUP_STRLEN = 16;
    public static final int MAX_GROUP_SIZE = 3;
    private List<DogGroup> groups = new ArrayList<DogGroup>(3);

    public List<DogGroup> getGroupsReadOnly() {
        return Collections.unmodifiableList(this.groups);
    }

    public void load(CompoundTag compound) {
        ListTag groupsListTag = compound.m_128437_("doggy_groups", 10);
        for (Tag tag : groupsListTag) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag groupTag = (CompoundTag)tag;
            String group_name = groupTag.m_128461_("group_name");
            int group_color = groupTag.m_128451_("group_color");
            this.add(new DogGroup(group_name, group_color));
        }
    }

    public void save(CompoundTag compound) {
        ListTag groupsListTag = new ListTag();
        for (DogGroup group : this.getGroupsReadOnly()) {
            CompoundTag groupTag = new CompoundTag();
            groupTag.m_128359_("group_name", group.name);
            groupTag.m_128405_("group_color", group.color);
            groupsListTag.add((Object)groupTag);
        }
        compound.m_128365_("doggy_groups", (Tag)groupsListTag);
    }

    public boolean isGroup(DogGroup group) {
        return this.getGroupsReadOnly().contains(group);
    }

    public boolean add(DogGroup group) {
        if (this.groups.size() >= 3) {
            return false;
        }
        if (this.groups.contains(group)) {
            return false;
        }
        if (group.name.length() > 16) {
            return false;
        }
        if (group.name.isEmpty()) {
            return false;
        }
        this.groups.add(group);
        return true;
    }

    public boolean remove(DogGroup group) {
        if (!this.groups.contains(group)) {
            return false;
        }
        this.groups.remove(group);
        return true;
    }

    public void clear() {
        this.groups.clear();
    }

    public static class DogGroup {
        public final int color;
        public final String name;

        public DogGroup(String name, int color) {
            this.color = color;
            this.name = name == null ? "" : (name.length() > 16 ? name.substring(0, 16) : name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DogGroup)) {
                return false;
            }
            DogGroup group = (DogGroup)obj;
            return group.color == this.color && group.name.equals(this.name);
        }
    }
}

