/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import com.mojang.datafixers.util.Pair;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.network.packet.ParticlePackets;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class DogEddibleItem
extends Item
implements IDogEddible {
    private final FoodProperties foodProps;

    public DogEddibleItem(Item.Properties itemProps, FoodProperties foodProps) {
        super(itemProps.m_41489_(foodProps));
        this.foodProps = foodProps;
    }

    public DogEddibleItem(Item.Properties itemProps, Function<FoodProperties.Builder, FoodProperties.Builder> propsCreator) {
        this(itemProps, propsCreator.apply(new FoodProperties.Builder()).m_38767_());
    }

    public DogEddibleItem(Item.Properties itemProps, Function<Item.Properties, Item.Properties> itemPropsCreator, Function<FoodProperties.Builder, FoodProperties.Builder> propsCreator) {
        this(itemPropsCreator.apply(itemProps), propsCreator.apply(new FoodProperties.Builder()).m_38767_());
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.m_41720_() == this;
    }

    @Override
    public boolean canConsume(AbstractDog dog, ItemStack stackIn, @Nullable Entity entityIn) {
        return !dog.isDefeated() && this.isFood(stackIn);
    }

    @Override
    public InteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
        if (dog.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        DogEddibleItem dogEddible = this;
        if (!dogEddible.alwaysEatWhenDogConsume(dog) && !dog.canStillEat()) {
            return InteractionResult.FAIL;
        }
        if (!dog.m_9236_().f_46443_) {
            float heal = dogEddible.getAddedHungerWhenDogConsume(stack, dog);
            dog.addHunger(heal);
            dog.consumeItemFromStack(entityIn, stack);
            for (Pair<MobEffectInstance, Float> pair : dogEddible.getAdditionalEffectsWhenDogConsume(stack, dog)) {
                if (pair.getFirst() == null || !(dog.m_217043_().m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                dog.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
            if (dog.m_9236_() instanceof ServerLevel) {
                ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)this));
            }
            dog.m_5496_(dogEddible.getDogEatingSound(dog), dog.m_6121_(), (dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
            ItemStack returnStack = dogEddible.getReturnStackAfterDogConsume(stack, dog);
            if (!returnStack.m_41619_()) {
                dog.m_19983_(returnStack);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public float getAddedHungerWhenDogConsume(ItemStack useStack, AbstractDog dog) {
        return this.foodProps.m_38744_() * 5;
    }

    @Override
    public List<Pair<MobEffectInstance, Float>> getAdditionalEffectsWhenDogConsume(ItemStack useStack, AbstractDog dog) {
        return this.foodProps.m_38749_();
    }
}

