/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item.itemgroup;

import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.DogBathBlock;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.FoodBowlBlock;
import doggytalents.common.block.RiceMillBlock;
import doggytalents.common.item.AccessoryItem;
import doggytalents.common.item.EmptyLocatorOrbItem;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.util.DogBedUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;

public class DTNItemCategory {
    private static Set<Item> main;
    private static Set<Item> agri_base;

    public static void init() {
        main = new HashSet<Item>(List.of(DoggyItems.DOGGY_CHARM.get(), DoggyItems.TRAINING_TREAT.get(), DoggyItems.SUPER_TREAT.get(), DoggyItems.MASTER_TREAT.get(), DoggyItems.KAMI_TREAT.get(), DoggyItems.CONDUCTING_BONE.get(), DoggyItems.CANINE_TRACKER.get(), DoggyItems.WHISTLE.get(), DoggyItems.SCENT_TREAT.get(), DoggyItems.AMNESIA_BONE.get(), DoggyItems.THROW_BONE.get(), DoggyItems.THROW_STICK.get(), DoggyItems.BREEDING_BONE.get(), DoggyItems.TREAT_BAG.get(), DoggyItems.GENDER_BONE.get(), DoggyItems.STARTER_BUNDLE.get(), DoggyItems.MAGNIFYING_BONE.get(), DoggyItems.SHRINKING_MALLET.get(), DoggyItems.BANDAID.get(), DoggyItems.FRISBEE.get(), ((FoodBowlBlock)((Object)DoggyBlocks.FOOD_BOWL.get())).m_5456_(), ((DogBathBlock)((Object)DoggyBlocks.DOG_BATH.get())).m_5456_()));
        agri_base = new HashSet<Item>(List.of(DoggyItems.RICE_GRAINS.get(), DoggyItems.RICE_WHEAT.get(), ((RiceMillBlock)((Object)DoggyBlocks.RICE_MILL.get())).m_5456_(), DoggyItems.UNCOOKED_RICE_BOWL.get(), DoggyItems.UNCOOKED_RICE.get(), DoggyItems.KOJI.get(), DoggyItems.UNCOOKED_RICE.get(), DoggyItems.SOY_BEANS_DRIED.get(), DoggyItems.SOY_PODS_DRIED.get(), DoggyItems.SOY_PODS.get(), DoggyItems.SOY_BEANS.get(), DoggyItems.MISO_PASTE.get(), DoggyItems.EDAMAME.get()));
    }

    public static boolean isMain(Item item) {
        if (main == null || item == null) {
            return false;
        }
        return main.contains(item);
    }

    public static boolean isStyle(Item item) {
        if (item == null) {
            return false;
        }
        if (item instanceof AccessoryItem) {
            return true;
        }
        return item instanceof EmptyLocatorOrbItem;
    }

    public static boolean isAgri(Item item) {
        if (item == null) {
            return false;
        }
        if (item == DoggyItems.EASTER_EGG_CANDY.get()) {
            return false;
        }
        if (item instanceof IDogEddible) {
            return true;
        }
        return agri_base != null && agri_base.contains(item);
    }

    public static boolean isDogBed(Item item) {
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        return blockItem.m_40614_() instanceof DogBedBlock;
    }

    public static boolean isMisc(Item item) {
        if (DTNItemCategory.isMain(item)) {
            return false;
        }
        if (DTNItemCategory.isAgri(item)) {
            return false;
        }
        if (DTNItemCategory.isStyle(item)) {
            return false;
        }
        if (DTNItemCategory.isDogBed(item)) {
            return false;
        }
        return !DTNItemCategory.isHidden(item);
    }

    public static boolean isHidden(Item item) {
        return item == DoggyItems.DOG_ANIM_DEBUG.get();
    }

    public static Stream<Item> getAllItemOfCategory(Predicate<Item> pred) {
        Collection all_items = DoggyItems.ITEMS.getEntries();
        ArrayList<Item> item_list = new ArrayList<Item>();
        for (RegistryObject item_holder : all_items) {
            Item item = (Item)item_holder.get();
            if (item == null || item_list.contains(item) || !pred.test(item)) continue;
            item_list.add(item);
        }
        return item_list.stream();
    }

    public static Stream<ItemStack> getRandomBedsForTab() {
        int maxBeddingEntries = 13;
        int maxCasingEntries = 13;
        List beddingList = DogBedMaterialManager.getBeddings().entrySet().stream().map(x -> (IBeddingMaterial)x.getValue()).filter(x -> !(x instanceof DogBedMaterialManager.NaniBedding)).collect(Collectors.toList());
        List casingList = DogBedMaterialManager.getCasings().entrySet().stream().map(x -> (ICasingMaterial)x.getValue()).filter(x -> !(x instanceof DogBedMaterialManager.NaniCasing)).collect(Collectors.toList());
        Collections.shuffle(beddingList);
        Collections.shuffle(casingList);
        ArrayList<ItemStack> bed_list = new ArrayList<ItemStack>();
        for (int i = 0; i < Math.min(13, casingList.size()); ++i) {
            for (int j = 0; j < Math.min(13, beddingList.size()); ++j) {
                IBeddingMaterial beddingId = (IBeddingMaterial)beddingList.get(j);
                ICasingMaterial casingId = (ICasingMaterial)casingList.get(i);
                ItemStack created = DogBedUtil.createItemStack(casingId, beddingId);
                bed_list.add(created);
            }
        }
        return bed_list.stream();
    }
}

