/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTalents;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.misc.DogArrow;
import doggytalents.common.entity.misc.DogThrownTrident;
import doggytalents.common.talent.doggy_tools.DoggyToolsRangedAttack;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public interface ShootHandler {
    public static final ShootHandler NONE = new ShootHandler(){

        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            return false;
        }
    };
    public static final ShootHandler BOW = new BowlikeShootHandler(){

        @Override
        public boolean isToolReadyToShoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, int tick_using) {
            return tick_using >= 20;
        }

        @Override
        public void shoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, LivingEntity target, int tick_using) {
            this.shootFromBow(ranged_manager, dog, target, BowItem.m_40661_((int)tick_using));
        }

        private void shootFromBow(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, LivingEntity target, float damage) {
            Optional<AbstractArrow> arrowOptional = this.getAndConsumeDogArrow(dog, damage);
            if (!arrowOptional.isPresent()) {
                return;
            }
            AbstractArrow arrow = arrowOptional.get();
            ranged_manager.shootProjectile(dog, (Projectile)arrow, target, SoundEvents.f_12382_);
        }

        public Optional<AbstractArrow> getAndConsumeDogArrow(AbstractDog dog, float damage) {
            Optional<AbstractArrow> projArrowOptional;
            ItemStack bowStack = dog.m_21205_();
            if (!(bowStack.m_41720_() instanceof BowItem)) {
                return Optional.empty();
            }
            Optional<Pair<ItemStackHandler, Integer>> arrowInvOptional = DoggyToolsRangedAttack.findArrowsInInventory(dog);
            ItemStackHandler inv = null;
            int id = -1;
            if (arrowInvOptional.isPresent()) {
                inv = (ItemStackHandler)arrowInvOptional.get().getLeft();
                id = (Integer)arrowInvOptional.get().getRight();
            }
            ItemStack arrow_stack = ItemStack.f_41583_;
            if (inv != null && id >= 0) {
                arrow_stack = inv.getStackInSlot(id).m_41777_();
            }
            if (!(projArrowOptional = this.getArrowFromBow(dog, bowStack, arrow_stack, damage)).isPresent()) {
                return Optional.empty();
            }
            this.consumeArrow(dog, bowStack, arrow_stack);
            if (inv != null && id >= 0) {
                inv.setStackInSlot(id, arrow_stack);
            }
            bowStack.m_41622_(1, (LivingEntity)dog, p_150845_ -> p_150845_.m_21190_(InteractionHand.MAIN_HAND));
            return projArrowOptional;
        }

        private Optional<AbstractArrow> getArrowFromBow(AbstractDog dog, ItemStack bow_stack, ItemStack arrowStack, float power) {
            boolean flaming_arrow;
            int k;
            int j;
            Item item;
            Item item2 = bow_stack.m_41720_();
            if (!(item2 instanceof BowItem)) {
                return Optional.empty();
            }
            BowItem bow = (BowItem)item2;
            boolean is_infinity_bow = DoggyToolsRangedAttack.isInfinityBow(bow_stack);
            ItemStack select_arrowStack = null;
            Item select_arrow = null;
            if (is_infinity_bow) {
                select_arrow = Items.f_42412_;
                select_arrowStack = new ItemStack((ItemLike)select_arrow);
            }
            if ((item = arrowStack.m_41720_()) instanceof ArrowItem) {
                ArrowItem arrowItem = (ArrowItem)item;
                select_arrow = arrowItem;
                select_arrowStack = arrowStack;
            }
            if (select_arrowStack == null || select_arrowStack.m_41619_()) {
                return Optional.empty();
            }
            if (!(select_arrow instanceof ArrowItem)) {
                return Optional.empty();
            }
            ArrowItem arrow = (ArrowItem)select_arrow;
            arrowStack = select_arrowStack;
            AbstractArrow arrow_proj = this.createDogArrow(dog, arrow, arrowStack);
            if (arrow_proj == null) {
                return Optional.empty();
            }
            arrow_proj = bow.customArrow(arrow_proj);
            if (power >= 1.0f) {
                arrow_proj.m_36762_(true);
            }
            if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bow_stack)) > 0) {
                arrow_proj.m_36781_(arrow_proj.m_36789_() + (double)j * 0.5 + 0.5);
            }
            if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bow_stack)) > 0) {
                arrow_proj.m_36735_(k);
            }
            boolean bl = flaming_arrow = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bow_stack) > 0 || dog.getDogLevel((Supplier)DoggyTalents.HELL_HOUND) >= 5;
            if (flaming_arrow) {
                arrow_proj.m_20254_(100);
            }
            arrow_proj.f_36705_ = is_infinity_bow ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
            return Optional.of(arrow_proj);
        }

        private AbstractArrow createDogArrow(AbstractDog dog, ArrowItem arrow_item, ItemStack arrow_stack) {
            if (!((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_BOW_VANILLA_PROJ.get()).booleanValue()) {
                return arrow_item.m_6394_(dog.m_9236_(), arrow_stack, (LivingEntity)dog);
            }
            return new DogArrow(dog.m_9236_(), dog, arrow_stack.m_255036_(1));
        }

        private void consumeArrow(AbstractDog dog, ItemStack bow_stack, ItemStack arrowStack) {
            boolean is_infinity_bow = DoggyToolsRangedAttack.isInfinityBow(bow_stack);
            if (!is_infinity_bow) {
                arrowStack.m_41774_(1);
            }
        }
    };
    public static final ShootHandler TRIDENT = new BowlikeShootHandler(){

        @Override
        public boolean isToolReadyToShoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, int tick_using) {
            return tick_using >= 20 && !ranged_manager.hasAwaitingTrident();
        }

        @Override
        public void shoot(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, LivingEntity target, int tick_using) {
            this.shootFromTrident(ranged_manager, dog, target);
        }

        private void shootFromTrident(DoggyToolsRangedAttack ranged_manager, AbstractDog ddog, LivingEntity target) {
            boolean flaming_trident;
            if (!(ddog instanceof Dog)) {
                return;
            }
            Dog dog = (Dog)ddog;
            Optional<DogThrownTrident> tridentOptional = this.getAndConsumeDogTrident(dog);
            if (!tridentOptional.isPresent()) {
                return;
            }
            DogThrownTrident trident = tridentOptional.get();
            boolean bl = flaming_trident = dog.getDogLevel((Supplier)DoggyTalents.HELL_HOUND) >= 5;
            if (flaming_trident) {
                trident.m_20254_(100);
            }
            ranged_manager.shootProjectile(dog, (Projectile)trident, target, SoundEvents.f_12520_);
            ranged_manager.setAwaitingTrident(trident);
        }

        private Optional<DogThrownTrident> getAndConsumeDogTrident(Dog dog) {
            ItemStack trident_stack = dog.m_21205_();
            if (!DogUtil.isTrident(trident_stack)) {
                return Optional.empty();
            }
            DogThrownTrident proj = new DogThrownTrident(dog, trident_stack.m_41777_());
            proj.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            trident_stack.m_41622_(1, (LivingEntity)dog, p_150845_ -> p_150845_.m_21190_(InteractionHand.MAIN_HAND));
            return Optional.of(proj);
        }
    };
    public static final ShootHandler CROSSBOW = new ShootHandler(){

        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            AbstractDog dog = ctx.dog;
            ItemStack crossbow_stack = dog.m_21205_();
            if (!(crossbow_stack.m_41720_() instanceof CrossbowItem)) {
                if (dog.m_6117_()) {
                    dog.m_5810_();
                }
                return false;
            }
            Optional<Pair<ItemStackHandler, Integer>> arrow_optional = DoggyToolsRangedAttack.findArrowsInInventory(dog);
            if (!arrow_optional.isPresent()) {
                if (dog.m_6117_()) {
                    dog.m_5810_();
                }
                return false;
            }
            Pair<ItemStackHandler, Integer> arrow_stack = arrow_optional.get();
            boolean attack_result = false;
            if (this.isCrossbowCharged(crossbow_stack)) {
                attack_result = this.updateCrossbowAttack(ranged_manager, dog, ctx.target, crossbow_stack);
            } else {
                this.updateChargeCrossbow(ranged_manager, dog, crossbow_stack, arrow_stack, ctx);
            }
            return attack_result;
        }

        private boolean isCrossbowCharged(ItemStack crossbow_stack) {
            return CrossbowItem.m_40932_((ItemStack)crossbow_stack);
        }

        private void updateChargeCrossbow(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, ItemStack crossbow_stack, Pair<ItemStackHandler, Integer> arrow_getter, IDogRangedAttackManager.UsingWeaponContext ctx) {
            boolean should_stop_using;
            ranged_manager.setDelayedCrossbowAttack(10);
            if (!dog.m_6117_()) {
                this.mayStartUsingWeapon(ctx);
                return;
            }
            boolean bl = should_stop_using = !ctx.canSeeTarget && ctx.seeTime < -60;
            if (should_stop_using) {
                dog.m_5810_();
                return;
            }
            int using_tick = dog.m_21252_();
            if (using_tick >= CrossbowItem.m_40939_((ItemStack)crossbow_stack)) {
                dog.m_5810_();
                this.chargeCrossbowAndConsumeArrow(dog, crossbow_stack, arrow_getter);
            }
        }

        private void chargeCrossbowAndConsumeArrow(AbstractDog dog, ItemStack crossbow_stack, Pair<ItemStackHandler, Integer> arrow_getter) {
            ItemStackHandler inv = null;
            int id = -1;
            inv = (ItemStackHandler)arrow_getter.getLeft();
            id = (Integer)arrow_getter.getRight();
            ItemStack arrow_stack = ItemStack.f_41583_;
            if (inv != null && id >= 0) {
                arrow_stack = inv.getStackInSlot(id).m_41777_();
            }
            if (arrow_stack.m_41619_()) {
                return;
            }
            boolean is_multishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)crossbow_stack) > 0;
            int shoot_amount = is_multishot ? 3 : 1;
            ArrayList<ItemStack> item_list = new ArrayList<ItemStack>(shoot_amount);
            for (int i = 0; i < shoot_amount; ++i) {
                item_list.add(arrow_stack.m_255036_(1));
            }
            if (item_list.isEmpty()) {
                return;
            }
            ItemUtil.addCrossbowProj(crossbow_stack, item_list);
            if (inv != null) {
                arrow_stack = arrow_stack.m_41777_();
                arrow_stack.m_41774_(1);
                inv.setStackInSlot(id, arrow_stack);
            }
            dog.m_5496_(SoundEvents.f_11841_, 1.0f, 1.0f / (dog.m_217043_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }

        private boolean updateCrossbowAttack(DoggyToolsRangedAttack ranged_manager, AbstractDog dog, LivingEntity target, ItemStack crossbow_stack) {
            ranged_manager.decDelayedCrossbowAttack();
            if (ranged_manager.getDelayedCrossbowAttack() <= 0) {
                ranged_manager.setDelayedCrossbowAttack(20);
                this.shootViaCrossbow(dog, target, crossbow_stack);
                return true;
            }
            return false;
        }

        private void shootViaCrossbow(AbstractDog dog, LivingEntity target, ItemStack crossbow_stack) {
            Item item = crossbow_stack.m_41720_();
            if (!(item instanceof CrossbowItem)) {
                return;
            }
            CrossbowItem crossbowitem = (CrossbowItem)item;
            CrossbowItem.m_40887_((Level)dog.m_9236_(), (LivingEntity)dog, (InteractionHand)InteractionHand.MAIN_HAND, (ItemStack)crossbow_stack, (float)1.6f, (float)2.0f);
            CrossbowItem.m_40884_((ItemStack)crossbow_stack, (boolean)false);
            this.hellHoundSetFireToOwnedArrows(dog);
        }

        private boolean hellHoundSetFireToOwnedArrows(AbstractDog dog) {
            if (!dog.m_5825_()) {
                return false;
            }
            Predicate<AbstractArrow> is_target_arrow = e -> {
                if (!e.m_6084_()) {
                    return false;
                }
                return e.m_19749_() == dog;
            };
            AABB bb = dog.m_20191_().m_82400_(1.0);
            List targets = dog.m_9236_().m_6443_(AbstractArrow.class, bb, is_target_arrow);
            if (targets.isEmpty()) {
                return false;
            }
            for (AbstractArrow target : targets) {
                target.m_20254_(20);
            }
            return true;
        }

        private void mayStartUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
            if (ctx.cooldown <= 0 && ctx.seeTime >= -60) {
                ctx.dog.m_6672_(InteractionHand.MAIN_HAND);
            }
        }
    };

    public boolean updateUsingWeapon(DoggyToolsRangedAttack var1, IDogRangedAttackManager.UsingWeaponContext var2);

    public static abstract class BowlikeShootHandler
    implements ShootHandler {
        @Override
        public boolean updateUsingWeapon(DoggyToolsRangedAttack ranged_manager, IDogRangedAttackManager.UsingWeaponContext ctx) {
            int using_tick;
            boolean should_stop_using;
            AbstractDog dog = ctx.dog;
            if (!dog.m_6117_()) {
                this.mayStartUsingWeapon(ctx);
                return false;
            }
            boolean bl = should_stop_using = !ctx.canSeeTarget && ctx.seeTime < -60;
            if (should_stop_using) {
                dog.m_5810_();
                return false;
            }
            if (ctx.canSeeTarget && this.isToolReadyToShoot(ranged_manager, dog, using_tick = dog.m_21252_())) {
                dog.m_5810_();
                this.shoot(ranged_manager, dog, ctx.target, using_tick);
                return true;
            }
            return false;
        }

        private void mayStartUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
            if (ctx.cooldown <= 0 && ctx.seeTime >= -60) {
                ctx.dog.m_6672_(InteractionHand.MAIN_HAND);
            }
        }

        public abstract boolean isToolReadyToShoot(DoggyToolsRangedAttack var1, AbstractDog var2, int var3);

        public abstract void shoot(DoggyToolsRangedAttack var1, AbstractDog var2, LivingEntity var3, int var4);
    }
}

