/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class DogHoldChunkToTeleportPromise
extends AbstractPromise {
    private final List<Dog> dogs;
    private final ServerLevel level;
    private int timeOut;

    public DogHoldChunkToTeleportPromise(List<Dog> dogs, ServerLevel level) {
        this.dogs = dogs;
        this.level = level;
    }

    @Override
    public void start() {
        this.forceDogChunk();
        this.timeOut = 40;
    }

    @Override
    public void tick() {
        if (--this.timeOut <= 0) {
            this.setState(AbstractPromise.State.FULFILLED);
            return;
        }
    }

    @Override
    public void onFulfilled() {
    }

    @Override
    public void onRejected() {
    }

    private void forceDogChunk() {
        for (Dog dog : this.dogs) {
            if (!dog.isDoingFine()) continue;
            ChunkPos chunkpos = new ChunkPos(dog.m_20183_());
            this.accquireChunk(this.level, chunkpos);
        }
    }
}

