/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.client.ClientSetup;
import doggytalents.client.block.model.RiceMillModel;
import doggytalents.common.block.RiceMillBlock;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import doggytalents.common.lib.Resources;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RiceMillRenderer
implements BlockEntityRenderer<RiceMillBlockEntity> {
    private RiceMillModel model;

    public RiceMillRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new RiceMillModel(ctx.bakeLayer(ClientSetup.RICE_MILL));
    }

    public void render(RiceMillBlockEntity mill, float pTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        stack.pushPose();
        stack.scale(1.0f, -1.0f, -1.0f);
        stack.translate(0.5f, 0.0f, -0.5f);
        BlockState state = mill.getBlockState();
        Direction facing = RiceMillBlock.getFacing(state);
        stack.mulPose(Axis.YP.rotationDegrees(facing.getOpposite().toYRot()));
        stack.scale(2.0f, 2.0f, 2.0f);
        stack.translate(-0.25f, -1.501f, -0.25f);
        this.model.setUpMillAnim(mill, pTicks);
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)Resources.RICE_MILL_MODEL));
        this.model.renderToBuffer(stack, consumer, light, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
    }

    public AABB getRenderBoundingBox(RiceMillBlockEntity mill) {
        return mill.getRenderBoundingBox();
    }
}

