/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.google.common.collect.Maps;
import doggytalents.api.events.RegisterCustomDogModelsEvent;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.dog.AkitaAmericanModel;
import doggytalents.client.entity.model.dog.AkitaJapaneseModel;
import doggytalents.client.entity.model.dog.AmaterasuModel;
import doggytalents.client.entity.model.dog.AmmyChiModel;
import doggytalents.client.entity.model.dog.AmmyJinModel;
import doggytalents.client.entity.model.dog.AmmyRebirthModel;
import doggytalents.client.entity.model.dog.AmmyReiModel;
import doggytalents.client.entity.model.dog.AmmyShinModel;
import doggytalents.client.entity.model.dog.AmmyShiranuiModel;
import doggytalents.client.entity.model.dog.AmmyTeiModel;
import doggytalents.client.entity.model.dog.ArcanineModel;
import doggytalents.client.entity.model.dog.AustralianKelpieModel;
import doggytalents.client.entity.model.dog.BassetHoundModel;
import doggytalents.client.entity.model.dog.BelgianMalinoisModel;
import doggytalents.client.entity.model.dog.BichonMaltaisModel;
import doggytalents.client.entity.model.dog.BoltModel;
import doggytalents.client.entity.model.dog.BorzoiLongModel;
import doggytalents.client.entity.model.dog.BorzoiModel;
import doggytalents.client.entity.model.dog.BoxerFloppyModel;
import doggytalents.client.entity.model.dog.BoxerPointyModel;
import doggytalents.client.entity.model.dog.BullTerrierModel;
import doggytalents.client.entity.model.dog.ChihuahuaModel;
import doggytalents.client.entity.model.dog.CollieBorderModel;
import doggytalents.client.entity.model.dog.CollieBorderShortModel;
import doggytalents.client.entity.model.dog.CollieRoughModel;
import doggytalents.client.entity.model.dog.CollieSmoothModel;
import doggytalents.client.entity.model.dog.CorgiModel;
import doggytalents.client.entity.model.dog.CustomDogModel;
import doggytalents.client.entity.model.dog.DachshundModel;
import doggytalents.client.entity.model.dog.DeathModel;
import doggytalents.client.entity.model.dog.DobermanModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.EnglishBulldogModel;
import doggytalents.client.entity.model.dog.FrenchBulldogModel;
import doggytalents.client.entity.model.dog.GermanPointerShorthaired;
import doggytalents.client.entity.model.dog.GermanPointerWirehaired;
import doggytalents.client.entity.model.dog.GermanShepherdModel;
import doggytalents.client.entity.model.dog.HoundstoneModel;
import doggytalents.client.entity.model.dog.HungarianPuliModel;
import doggytalents.client.entity.model.dog.IwankoModel;
import doggytalents.client.entity.model.dog.JackModel;
import doggytalents.client.entity.model.dog.JunoModel;
import doggytalents.client.entity.model.dog.LegoshiModel;
import doggytalents.client.entity.model.dog.LucarioModel;
import doggytalents.client.entity.model.dog.MiniaturePinscherModel;
import doggytalents.client.entity.model.dog.MochiModel;
import doggytalents.client.entity.model.dog.Na;
import doggytalents.client.entity.model.dog.NewfoundlandModel;
import doggytalents.client.entity.model.dog.NorfolkTerrierModel;
import doggytalents.client.entity.model.dog.OtterModel;
import doggytalents.client.entity.model.dog.PochitaModel;
import doggytalents.client.entity.model.dog.PoodleModel;
import doggytalents.client.entity.model.dog.PugModel;
import doggytalents.client.entity.model.dog.RangaModel;
import doggytalents.client.entity.model.dog.SamoyedModel;
import doggytalents.client.entity.model.dog.ScrapsModel;
import doggytalents.client.entity.model.dog.ShibaModel;
import doggytalents.client.entity.model.dog.ShikokuModel;
import doggytalents.client.entity.model.dog.SparkyModel;
import doggytalents.client.entity.model.dog.StBernardModel;
import doggytalents.client.entity.model.dog.VariantDogModel;
import doggytalents.client.entity.model.dog.WolfLinkModel;
import doggytalents.client.entity.model.dog.ZeroModel;
import doggytalents.client.entity.model.dog.kusa.ChiModel;
import doggytalents.client.entity.model.dog.kusa.HayabusaModel;
import doggytalents.client.entity.model.dog.kusa.KoModel;
import doggytalents.client.entity.model.dog.kusa.ReiModel;
import doggytalents.client.entity.model.dog.kusa.ShinModel;
import doggytalents.client.entity.model.dog.kusa.TakeModel;
import doggytalents.client.entity.model.dog.kusa.TeiModel;
import doggytalents.client.entity.model.dog.kusa.UmeModel;
import doggytalents.client.entity.model.dog.oina.HopeModel;
import doggytalents.client.entity.model.dog.oina.KaipokuModel;
import doggytalents.client.entity.model.dog.oina.KawausoModel;
import doggytalents.client.entity.model.dog.oina.KemushiriModel;
import doggytalents.client.entity.model.dog.oina.OinaMerchant1Model;
import doggytalents.client.entity.model.dog.oina.OinaMerchant2Model;
import doggytalents.client.entity.model.dog.oina.OkikurumiModel;
import doggytalents.client.entity.model.dog.oina.PirikoModel;
import doggytalents.client.entity.model.dog.oina.RisuModel;
import doggytalents.client.entity.model.dog.oina.ShamikuruModel;
import doggytalents.client.entity.model.dog.oina.TodoModel;
import doggytalents.client.entity.model.dog.oina.TusukuruModel;
import doggytalents.client.entity.model.dog.oina.WariModel;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;

public class DogModelRegistry {
    private static Map<ResourceLocation, DogModelHolder> MODEL_MAP;

    public static <T extends AbstractDog> void register(ResourceLocation id, Function<EntityRendererProvider.Context, DogModel> getter) {
        MODEL_MAP.putIfAbsent(id, new DogModelHolder(getter));
    }

    public static void register(String name, Function<EntityRendererProvider.Context, DogModel> getter) {
        DogModelRegistry.register(Util.getResource(name), getter);
    }

    public static DogModelHolder getDogModelHolder(ResourceLocation id) {
        return MODEL_MAP.get(id);
    }

    public static DogModelHolder getDogModelHolder(String name) {
        ResourceLocation loc = name.indexOf(58) >= 0 ? ResourceLocation.parse((String)name) : Util.getResource(name);
        return DogModelRegistry.getDogModelHolder(loc);
    }

    public static void resolve(EntityRendererProvider.Context ctx) {
        for (Map.Entry<ResourceLocation, DogModelHolder> holder : MODEL_MAP.entrySet()) {
            try {
                holder.getValue().resolve(ctx);
            }
            catch (NoSuchElementException e) {
                String msg = "Dog Model [" + String.valueOf(holder.getKey()) + "] is missing crucial parts! [" + e.getMessage() + "]";
                throw new NoSuchElementException(msg);
            }
        }
    }

    public static void init() {
        MODEL_MAP = Maps.newConcurrentMap();
        DogModelRegistry.register("default", (EntityRendererProvider.Context ctx) -> new DogModel(ctx.bakeLayer(ClientSetup.DOG)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("variant", (EntityRendererProvider.Context ctx) -> new VariantDogModel(ctx.bakeLayer(ClientSetup.DOG_LEGACY)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("iwanko", (EntityRendererProvider.Context ctx) -> new IwankoModel(ctx.bakeLayer(ClientSetup.DOG_IWANKO)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("lucario", (EntityRendererProvider.Context ctx) -> new LucarioModel(ctx.bakeLayer(ClientSetup.DOG_LUCARIO)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("death", (EntityRendererProvider.Context ctx) -> new DeathModel(ctx.bakeLayer(ClientSetup.DOG_DEATH)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("legoshi", (EntityRendererProvider.Context ctx) -> new LegoshiModel(ctx.bakeLayer(ClientSetup.DOG_LEGOSHI)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("jack", (EntityRendererProvider.Context ctx) -> new JackModel(ctx.bakeLayer(ClientSetup.DOG_JACK)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("juno", (EntityRendererProvider.Context ctx) -> new JunoModel(ctx.bakeLayer(ClientSetup.DOG_JUNO)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("st_bernard", (EntityRendererProvider.Context ctx) -> new StBernardModel(ctx.bakeLayer(ClientSetup.DOG_ST_BERNARD)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("okami_amaterasu", (EntityRendererProvider.Context ctx) -> new AmaterasuModel(ctx.bakeLayer(ClientSetup.OKAMI_AMATERASU)).setAccessoryState(DogModel.AccessoryState.SOME_WILL_FIT));
        DogModelRegistry.register("ammy_divine_chi", (EntityRendererProvider.Context ctx) -> new AmmyChiModel(ctx.bakeLayer(ClientSetup.AMMY_CHI)).setAccessoryState(DogModel.AccessoryState.SOME_WILL_FIT));
        DogModelRegistry.register("ammy_divine_jin", (EntityRendererProvider.Context ctx) -> new AmmyJinModel(ctx.bakeLayer(ClientSetup.AMMY_JIN)).setAccessoryState(DogModel.AccessoryState.SOME_WILL_FIT));
        DogModelRegistry.register("ammy_divine_rei", (EntityRendererProvider.Context ctx) -> new AmmyReiModel(ctx.bakeLayer(ClientSetup.AMMY_REI)).setAccessoryState(DogModel.AccessoryState.SOME_WILL_FIT));
        DogModelRegistry.register("ammy_divine_shin", (EntityRendererProvider.Context ctx) -> new AmmyShinModel(ctx.bakeLayer(ClientSetup.AMMY_SHIN)).setAccessoryState(DogModel.AccessoryState.SOME_WILL_FIT));
        DogModelRegistry.register("ammy_divine_shiranui", (EntityRendererProvider.Context ctx) -> new AmmyShiranuiModel(ctx.bakeLayer(ClientSetup.AMMY_SHIRANUI)).setAccessoryState(DogModel.AccessoryState.SOME_WILL_FIT));
        DogModelRegistry.register("ammy_divine_rebirth", (EntityRendererProvider.Context ctx) -> new AmmyRebirthModel(ctx.bakeLayer(ClientSetup.AMMY_REBIRTH)));
        DogModelRegistry.register("ammy_divine_tei", (EntityRendererProvider.Context ctx) -> new AmmyTeiModel(ctx.bakeLayer(ClientSetup.AMMY_TEI)).setAccessoryState(DogModel.AccessoryState.SOME_WILL_FIT));
        DogModelRegistry.register("kusa_hayabusa", (EntityRendererProvider.Context ctx) -> new HayabusaModel(ctx.bakeLayer(ClientSetup.KUSA_HAYABUSA)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("kusa_chi", (EntityRendererProvider.Context ctx) -> new ChiModel(ctx.bakeLayer(ClientSetup.KUSA_CHI)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("kusa_ko", (EntityRendererProvider.Context ctx) -> new KoModel(ctx.bakeLayer(ClientSetup.KUSA_KO)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("kusa_rei", (EntityRendererProvider.Context ctx) -> new ReiModel(ctx.bakeLayer(ClientSetup.KUSA_REI)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("kusa_shin", (EntityRendererProvider.Context ctx) -> new ShinModel(ctx.bakeLayer(ClientSetup.KUSA_SHIN)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("kusa_take", (EntityRendererProvider.Context ctx) -> new TakeModel(ctx.bakeLayer(ClientSetup.KUSA_TAKE)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("kusa_tei", (EntityRendererProvider.Context ctx) -> new TeiModel(ctx.bakeLayer(ClientSetup.KUSA_TEI)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("kusa_ume", (EntityRendererProvider.Context ctx) -> new UmeModel(ctx.bakeLayer(ClientSetup.KUSA_UME)).setAccessoryState(DogModel.AccessoryState.RECOMMENDED));
        DogModelRegistry.register("oina_kaipoku", (EntityRendererProvider.Context ctx) -> new KaipokuModel(ctx.bakeLayer(ClientSetup.OINA_KAIPOKU)));
        DogModelRegistry.register("oina_kawauso", (EntityRendererProvider.Context ctx) -> new KawausoModel(ctx.bakeLayer(ClientSetup.OINA_KAWAUSO)));
        DogModelRegistry.register("oina_kemushiri", (EntityRendererProvider.Context ctx) -> new KemushiriModel(ctx.bakeLayer(ClientSetup.OINA_KEMUSHIRI)));
        DogModelRegistry.register("oina_merchant", (EntityRendererProvider.Context ctx) -> new OinaMerchant1Model(ctx.bakeLayer(ClientSetup.OINA_MERCHANT)));
        DogModelRegistry.register("oina_merchant2", (EntityRendererProvider.Context ctx) -> new OinaMerchant2Model(ctx.bakeLayer(ClientSetup.OINA_MERCHANT2)));
        DogModelRegistry.register("oina_okikurumi", (EntityRendererProvider.Context ctx) -> new OkikurumiModel(ctx.bakeLayer(ClientSetup.OINA_OKIKURUMI)));
        DogModelRegistry.register("oina_piriko", (EntityRendererProvider.Context ctx) -> new PirikoModel(ctx.bakeLayer(ClientSetup.OINA_PIRIKO)));
        DogModelRegistry.register("oina_risu", (EntityRendererProvider.Context ctx) -> new RisuModel(ctx.bakeLayer(ClientSetup.OINA_RISU)));
        DogModelRegistry.register("oina_shamikuru", (EntityRendererProvider.Context ctx) -> new ShamikuruModel(ctx.bakeLayer(ClientSetup.OINA_SHAMIKURU)));
        DogModelRegistry.register("oina_todo", (EntityRendererProvider.Context ctx) -> new TodoModel(ctx.bakeLayer(ClientSetup.OINA_TODO)));
        DogModelRegistry.register("oina_tusukuru", (EntityRendererProvider.Context ctx) -> new TusukuruModel(ctx.bakeLayer(ClientSetup.OINA_TUSUKURU)));
        DogModelRegistry.register("oina_wari", (EntityRendererProvider.Context ctx) -> new WariModel(ctx.bakeLayer(ClientSetup.OINA_WARI)));
        DogModelRegistry.register("sol_hope", (EntityRendererProvider.Context ctx) -> new HopeModel(ctx.bakeLayer(ClientSetup.DOG_SOL_HOPE)));
        DogModelRegistry.register("wolf_link", (EntityRendererProvider.Context ctx) -> new WolfLinkModel(ctx.bakeLayer(ClientSetup.DOG_WOLF_LINK)));
        DogModelRegistry.register("arcanine", (EntityRendererProvider.Context ctx) -> new ArcanineModel(ctx.bakeLayer(ClientSetup.DOG_ARCANINE)).setAccessoryState(DogModel.AccessoryState.SOME_WILL_FIT));
        DogModelRegistry.register("pochita", (EntityRendererProvider.Context ctx) -> new PochitaModel(ctx.bakeLayer(ClientSetup.DOG_POCHITA)));
        DogModelRegistry.register("dachshund", (EntityRendererProvider.Context ctx) -> new DachshundModel(ctx.bakeLayer(ClientSetup.DOG_DACHSHUND)));
        DogModelRegistry.register("doberman", (EntityRendererProvider.Context ctx) -> new DobermanModel(ctx.bakeLayer(ClientSetup.DOG_DOBERMAN)));
        DogModelRegistry.register("pug", (EntityRendererProvider.Context ctx) -> new PugModel(ctx.bakeLayer(ClientSetup.DOG_PUG)));
        DogModelRegistry.register("borzoi", (EntityRendererProvider.Context ctx) -> new BorzoiModel(ctx.bakeLayer(ClientSetup.DOG_BORZOI)));
        DogModelRegistry.register("borzoi_long", (EntityRendererProvider.Context ctx) -> new BorzoiLongModel(ctx.bakeLayer(ClientSetup.DOG_BORZOI_LONG)));
        DogModelRegistry.register("english_bulldog", (EntityRendererProvider.Context ctx) -> new EnglishBulldogModel(ctx.bakeLayer(ClientSetup.DOG_ENGLISH_BULLDOG)));
        DogModelRegistry.register("french_bulldog", (EntityRendererProvider.Context ctx) -> new FrenchBulldogModel(ctx.bakeLayer(ClientSetup.DOG_FRENCH_BULLDOG)));
        DogModelRegistry.register("poodle", (EntityRendererProvider.Context ctx) -> new PoodleModel(ctx.bakeLayer(ClientSetup.DOG_POODLE)));
        DogModelRegistry.register("chihuahua", (EntityRendererProvider.Context ctx) -> new ChihuahuaModel(ctx.bakeLayer(ClientSetup.DOG_CHIHUAHUA)));
        DogModelRegistry.register("boxer_floppy", (EntityRendererProvider.Context ctx) -> new BoxerFloppyModel(ctx.bakeLayer(ClientSetup.DOG_BOXER_FLOPPY)));
        DogModelRegistry.register("boxer_pointy", (EntityRendererProvider.Context ctx) -> new BoxerPointyModel(ctx.bakeLayer(ClientSetup.DOG_BOXER_POINTY)));
        DogModelRegistry.register("miniature_pinscher", (EntityRendererProvider.Context ctx) -> new MiniaturePinscherModel(ctx.bakeLayer(ClientSetup.DOG_MINIATURE_PINSCHER)));
        DogModelRegistry.register("hungarian_puli", (EntityRendererProvider.Context ctx) -> new HungarianPuliModel(ctx.bakeLayer(ClientSetup.DOG_HUNGARIAN_PULI)));
        DogModelRegistry.register("basset_hound", (EntityRendererProvider.Context ctx) -> new BassetHoundModel(ctx.bakeLayer(ClientSetup.DOG_BASSET_HOUND)));
        DogModelRegistry.register("collie_smooth", (EntityRendererProvider.Context ctx) -> new CollieSmoothModel(ctx.bakeLayer(ClientSetup.DOG_COLLIE_SMOOTH)));
        DogModelRegistry.register("collie_rough", (EntityRendererProvider.Context ctx) -> new CollieRoughModel(ctx.bakeLayer(ClientSetup.DOG_COLLIE_ROUGH)));
        DogModelRegistry.register("collie_border", (EntityRendererProvider.Context ctx) -> new CollieBorderModel(ctx.bakeLayer(ClientSetup.DOG_COLLIE_BORDER)));
        DogModelRegistry.register("collie_border_short", (EntityRendererProvider.Context ctx) -> new CollieBorderShortModel(ctx.bakeLayer(ClientSetup.DOG_COLLIE_BORDER_SHORT)));
        DogModelRegistry.register("bichon_maltais", (EntityRendererProvider.Context ctx) -> new BichonMaltaisModel(ctx.bakeLayer(ClientSetup.DOG_BICHON_MALTAIS)));
        DogModelRegistry.register("belgian_malinois", (EntityRendererProvider.Context ctx) -> new BelgianMalinoisModel(ctx.bakeLayer(ClientSetup.DOG_BELGIAN_MALINOIS)));
        DogModelRegistry.register("german_shepherd", (EntityRendererProvider.Context ctx) -> new GermanShepherdModel(ctx.bakeLayer(ClientSetup.DOG_GERMAN_SHEPHERD)));
        DogModelRegistry.register("otter", (EntityRendererProvider.Context ctx) -> new OtterModel(ctx.bakeLayer(ClientSetup.DOG_OTTER)));
        DogModelRegistry.register("bull_terrier", (EntityRendererProvider.Context ctx) -> new BullTerrierModel(ctx.bakeLayer(ClientSetup.DOG_BULL_TERRIER)));
        DogModelRegistry.register("akita_inu", (EntityRendererProvider.Context ctx) -> new AkitaJapaneseModel(ctx.bakeLayer(ClientSetup.INU_AKITA)));
        DogModelRegistry.register("akita_dog", (EntityRendererProvider.Context ctx) -> new AkitaAmericanModel(ctx.bakeLayer(ClientSetup.DOG_AKITA)));
        DogModelRegistry.register("shiba_inu", (EntityRendererProvider.Context ctx) -> new ShibaModel(ctx.bakeLayer(ClientSetup.INU_SHIBA)));
        DogModelRegistry.register("shikoku_inu", (EntityRendererProvider.Context ctx) -> new ShikokuModel(ctx.bakeLayer(ClientSetup.INU_SHIKOKU)));
        DogModelRegistry.register("houndstone", (EntityRendererProvider.Context ctx) -> new HoundstoneModel(ctx.bakeLayer(ClientSetup.DOG_HOUNDSTONE)));
        DogModelRegistry.register("zero", (EntityRendererProvider.Context ctx) -> new ZeroModel(ctx.bakeLayer(ClientSetup.DOG_ZERO)));
        DogModelRegistry.register("scraps", (EntityRendererProvider.Context ctx) -> new ScrapsModel(ctx.bakeLayer(ClientSetup.DOG_SCRAPS)));
        DogModelRegistry.register("sparky", (EntityRendererProvider.Context ctx) -> new SparkyModel(ctx.bakeLayer(ClientSetup.DOG_SPARKY)));
        DogModelRegistry.register("german_pointer_shorthaired", (EntityRendererProvider.Context ctx) -> new GermanPointerShorthaired(ctx.bakeLayer(ClientSetup.DOG_POINTER_SHORT)));
        DogModelRegistry.register("german_pointer_wirehaired", (EntityRendererProvider.Context ctx) -> new GermanPointerWirehaired(ctx.bakeLayer(ClientSetup.DOG_POINTER_WIRE)));
        DogModelRegistry.register("samoyed", (EntityRendererProvider.Context ctx) -> new SamoyedModel(ctx.bakeLayer(ClientSetup.DOG_SAMOYED)));
        DogModelRegistry.register("ranga", (EntityRendererProvider.Context ctx) -> new RangaModel(ctx.bakeLayer(ClientSetup.RANGA)));
        DogModelRegistry.register("bolt", (EntityRendererProvider.Context ctx) -> new BoltModel(ctx.bakeLayer(ClientSetup.BOLT)));
        DogModelRegistry.register("norfolk_terrier", (EntityRendererProvider.Context ctx) -> new NorfolkTerrierModel(ctx.bakeLayer(ClientSetup.DOG_NORFOLK_TERRIER)));
        DogModelRegistry.register("australian_kelpie", (EntityRendererProvider.Context ctx) -> new AustralianKelpieModel(ctx.bakeLayer(ClientSetup.DOG_AUSTRALIAN_KELPIE)));
        DogModelRegistry.register("newfoundland", (EntityRendererProvider.Context ctx) -> new NewfoundlandModel(ctx.bakeLayer(ClientSetup.DOG_NEWFOUNDLAND)));
        DogModelRegistry.register("na", (EntityRendererProvider.Context ctx) -> new Na(ctx.bakeLayer(ClientSetup.NA)));
        DogModelRegistry.register("mochi", (EntityRendererProvider.Context ctx) -> new MochiModel(ctx.bakeLayer(ClientSetup.MOCHI)));
        DogModelRegistry.register("corgi", (EntityRendererProvider.Context ctx) -> new CorgiModel(ctx.bakeLayer(ClientSetup.DOG_CORGI)));
        DogModelRegistry.registerFromEvent();
    }

    private static void registerFromEvent() {
        ArrayList<RegisterCustomDogModelsEvent.DogModelProps> entries = new ArrayList<RegisterCustomDogModelsEvent.DogModelProps>();
        ModLoader.postEvent((Event)new RegisterCustomDogModelsEvent(entries));
        if (entries.isEmpty()) {
            return;
        }
        for (RegisterCustomDogModelsEvent.DogModelProps entry : entries) {
            if (entry.id == null || entry.layer == null || MODEL_MAP.containsKey(entry.id)) continue;
            DogModelRegistry.register(entry.id, (EntityRendererProvider.Context ctx) -> new CustomDogModel(ctx.bakeLayer(entry.layer), entry));
        }
    }

    public static class DogModelHolder {
        private DogModel value;
        private Function<EntityRendererProvider.Context, DogModel> getter;

        public DogModelHolder(Function<EntityRendererProvider.Context, DogModel> getter) {
            this.getter = getter;
        }

        public DogModel getValue() {
            return this.value;
        }

        public void resolve(EntityRendererProvider.Context ctx) {
            this.value = this.getter.apply(ctx);
        }
    }
}

