/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.api.inferface.IColoredObject;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogFrontLegsSeperate;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;

public class DefaultAccessoryRenderer
extends RenderLayer<Dog, DogModel> {
    private DogModel defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
    private DogFrontLegsSeperate hindLegDiffTextModel;

    public DefaultAccessoryRenderer(RenderLayerParent parentRenderer, EntityRendererProvider.Context ctx) {
        super(parentRenderer);
        this.hindLegDiffTextModel = new DogFrontLegsSeperate(ctx.bakeLayer(ClientSetup.DOG_FRONT_LEGS_SEPERATE));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!dog.isTame() || dog.isInvisible()) {
            return;
        }
        for (AccessoryInstance accessoryInst : dog.getClientSortedAccessories()) {
            Accessory accessory;
            DogModel model;
            DogSkin skin = dog.getClientSkin();
            if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).acessoryShouldRender(dog, accessoryInst) || !(accessory = accessoryInst.getAccessory()).shouldRender() || !this.isOverlay(accessory)) continue;
            if (accessory.hasHindLegDiffTex()) {
                this.renderHindLegDifferentAccessory(poseStack, buffer, packedLight, dog, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, accessoryInst);
                continue;
            }
            this.renderNormalAccessory(poseStack, buffer, packedLight, dog, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, accessoryInst);
        }
    }

    private void renderNormalAccessory(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, AccessoryInstance accessoryInst) {
        DogModel dogModel;
        DogModel parentModel = (DogModel)this.getParentModel();
        if (parentModel.useDefaultModelForAccessories()) {
            dogModel = this.defaultModel;
            parentModel.copyPropertiesTo(dogModel);
            dogModel.copyFrom(parentModel);
        } else {
            dogModel = parentModel;
        }
        ResourceLocation texture_rl = accessoryInst.getModelTexture(dog);
        boolean isTranslucent = this.isAcceossryRenderTranslucent(accessoryInst.getAccessory());
        if (texture_rl == null) {
            return;
        }
        boolean tailVisible0 = dogModel.tail.visible;
        if (dog.getClientSkin().useCustomModel()) {
            dogModel.tail.visible = false;
        }
        if (accessoryInst instanceof IColoredObject) {
            IColoredObject coloredObject = (IColoredObject)((Object)accessoryInst);
            float[] color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                RenderLayer.renderColoredCutoutModel((EntityModel)dogModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (int)FastColor.ARGB32.colorFromFloat((float)1.0f, (float)color[0], (float)color[1], (float)color[2]));
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderLayer.renderColoredCutoutModel((EntityModel)dogModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (int)-1);
        }
        dogModel.tail.visible = tailVisible0;
    }

    private void renderHindLegDifferentAccessory(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, AccessoryInstance accessoryInst) {
        float[] color;
        IColoredObject coloredObject;
        DogModel parentModel = (DogModel)this.getParentModel();
        DogModel dogModel = parentModel.useDefaultModelForAccessories() ? this.defaultModel : parentModel;
        if (dogModel != parentModel) {
            ((DogModel)this.getParentModel()).copyPropertiesTo(dogModel);
            dogModel.copyFrom(parentModel);
        }
        ResourceLocation texture_rl = accessoryInst.getModelTexture(dog);
        boolean isTranslucent = this.isAcceossryRenderTranslucent(accessoryInst.getAccessory());
        if (texture_rl == null) {
            return;
        }
        boolean tailVisible0 = dogModel.tail.visible;
        if (dog.getClientSkin().useCustomModel()) {
            dogModel.tail.visible = false;
        }
        boolean rightFrontLegVisible0 = dogModel.legFrontRight.visible;
        boolean leftFrontLegVisible0 = dogModel.legFrontLeft.visible;
        dogModel.legFrontLeft.visible = false;
        dogModel.legFrontRight.visible = false;
        if (accessoryInst instanceof IColoredObject) {
            coloredObject = (IColoredObject)((Object)accessoryInst);
            color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                RenderLayer.renderColoredCutoutModel((EntityModel)dogModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (int)FastColor.ARGB32.colorFromFloat((float)1.0f, (float)color[0], (float)color[1], (float)color[2]));
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(dogModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderLayer.renderColoredCutoutModel((EntityModel)dogModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (int)-1);
        }
        dogModel.tail.visible = tailVisible0;
        dogModel.legFrontRight.visible = rightFrontLegVisible0;
        dogModel.legFrontLeft.visible = leftFrontLegVisible0;
        dogModel.copyPropertiesTo(this.hindLegDiffTextModel);
        this.hindLegDiffTextModel.sync(dogModel);
        if (accessoryInst instanceof IColoredObject) {
            coloredObject = (IColoredObject)((Object)accessoryInst);
            color = coloredObject.getColor();
            if (isTranslucent) {
                DefaultAccessoryRenderer.renderTranslucentModel(this.hindLegDiffTextModel, texture_rl, poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                RenderLayer.renderColoredCutoutModel((EntityModel)this.hindLegDiffTextModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (int)FastColor.ARGB32.colorFromFloat((float)1.0f, (float)color[0], (float)color[1], (float)color[2]));
            }
        } else if (isTranslucent) {
            DefaultAccessoryRenderer.renderTranslucentModel(this.hindLegDiffTextModel, texture_rl, poseStack, buffer, packedLight, dog, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            RenderLayer.renderColoredCutoutModel((EntityModel)this.hindLegDiffTextModel, (ResourceLocation)texture_rl, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)dog, (int)-1);
        }
    }

    public boolean isOverlay(Accessory accessory) {
        Accessory.AccessoryRenderType type = accessory.getAccessoryRenderType();
        return type == Accessory.AccessoryRenderType.OVERLAY || type == Accessory.AccessoryRenderType.OVERLAY_AND_MODEL;
    }

    public boolean isAcceossryRenderTranslucent(Accessory accessory) {
        if (((Boolean)ConfigHandler.CLIENT.TRANSLUCENT_ALL_OVERLAY.get()).booleanValue()) {
            return true;
        }
        return accessory.renderTranslucent();
    }

    public static <T extends LivingEntity> void renderTranslucentModel(EntityModel<T> p_117377_, ResourceLocation p_117378_, PoseStack p_117379_, MultiBufferSource p_117380_, int p_117381_, T p_117382_, float p_117383_, float p_117384_, float p_117385_, float opascity) {
        VertexConsumer vertexconsumer = p_117380_.getBuffer(RenderType.entityTranslucent((ResourceLocation)p_117378_));
        p_117377_.renderToBuffer(p_117379_, vertexconsumer, p_117381_, LivingEntityRenderer.getOverlayCoords(p_117382_, (float)0.0f), FastColor.ARGB32.colorFromFloat((float)opascity, (float)p_117383_, (float)p_117384_, (float)p_117385_));
    }
}

