/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.MainInfoView;

import doggytalents.client.event.ClientEventHandler;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.common.entity.Dog;
import doggytalents.common.variant.DogVariant;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;

public class DogDescriptionViewBoxElement
extends AbstractElement {
    private Dog dog;
    private Font font;

    public DogDescriptionViewBoxElement(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        Minecraft mc = this.getScreen().getMinecraft();
        this.font = mc.font;
    }

    @Override
    public AbstractElement init() {
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int startY;
        String name = this.dog.getName().getString();
        String age = "" + this.dog.getAge();
        String gender = this.dog.getGenderName().getString();
        String owner = this.dog.isOwnedBy((LivingEntity)Minecraft.getInstance().player) ? I18n.get((String)"doggui.owner.you", (Object[])new Object[0]) : this.dog.getOwnersName().orElse((Component)Component.translatable((String)"entity.doggytalents.dog.unknown_owner")).getString();
        String friendlyFire = "" + this.dog.canOwnerAttack();
        String obeyOther = "" + this.dog.willObeyOthers();
        int startX = this.getRealX();
        int n = this.getRealY();
        int n2 = this.getSizeY();
        Objects.requireNonNull(this.font);
        int pY = startY = n + (n2 - (7 * 9 + 12)) / 2;
        graphics.drawString(this.font, this.createDescEntry(I18n.get((String)"doggui.home.name", (Object[])new Object[0]) + " ", name, -1), startX, pY, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.createDescEntry(I18n.get((String)"doggui.age", (Object[])new Object[0]) + " ", age, -1), startX, pY += 9 + 2, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.createDescEntry(I18n.get((String)"doggui.gender", (Object[])new Object[0]) + " ", gender, -1), startX, pY += 9 + 2, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.createDescEntry(I18n.get((String)"doggui.owner", (Object[])new Object[0]) + " ", owner, -1), startX, pY += 9 + 2, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.createDescEntry(I18n.get((String)"doggui.friendlyfire", (Object[])new Object[0]) + " ", friendlyFire, this.dog.canOwnerAttack() ? -3299584 : -1), startX, pY += 9 + 2, -1);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, this.createDescEntry(I18n.get((String)"doggui.obeyothers", (Object[])new Object[0]) + " ", obeyOther, this.dog.willObeyOthers() ? -3299584 : -1), startX, pY += 9 + 2, -1);
        Objects.requireNonNull(this.font);
        DogVariant variant = this.dog.dogVariant();
        String variant_str = I18n.get((String)"doggui.classical.variant", (Object[])new Object[0]) + " " + ClientEventHandler.getTranslatedVariantStr(variant);
        MutableComponent variant_c1 = Component.literal((String)variant_str).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(variant.guiColor()));
        graphics.drawString(this.font, (Component)variant_c1, startX, pY += 9 + 2, -1);
    }

    private Component createDescEntry(String descName, String descVal, int valColor) {
        MutableComponent c0 = Component.literal((String)(descName + " "));
        MutableComponent c1 = Component.literal((String)descVal).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(valColor));
        c0.append((Component)c1);
        return c0;
    }
}

