/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework;

import doggytalents.client.screen.framework.AbstractSlice;
import doggytalents.client.screen.framework.CommonUIActionTypes;
import doggytalents.client.screen.framework.IStoreSubscriber;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.ToolTipOverlayManager;
import doggytalents.client.screen.framework.UIAction;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class StoreConnectedScreen
extends Screen
implements IStoreSubscriber {
    private final ArrayList<Class<? extends AbstractSlice>> subscribedTo = new ArrayList();
    private boolean isResizing = false;
    protected AbstractElement rootView;

    protected StoreConnectedScreen(Component title) {
        super(title);
    }

    protected void init() {
        this.reRenderRoot();
    }

    private AbstractElement createRootView() {
        return new RootView(null, this, this::renderRootView).setPosition(ElementPosition.PosType.ABSOLUTE, 0, 0).setSize(this.width, this.height).init();
    }

    public void renderRootView(AbstractElement rootView) {
    }

    public void removed() {
        super.removed();
        Store.finish();
        ToolTipOverlayManager.finish();
    }

    public void resize(Minecraft p_96575_, int width, int height) {
        this.width = width;
        this.height = height;
        Store.get(this).dispatchAll(new UIAction(CommonUIActionTypes.RESIZE, new Object()));
        this.isResizing = true;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        Store.get(this).update();
        if (this.isResizing) {
            this.reRenderRoot();
            this.isResizing = false;
        }
        if (this.doRenderBackground()) {
            this.renderBackground(graphics, mouseX, mouseY, pTicks);
        }
        this.renderDarkBackground_1_21_1_above(graphics);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, pTicks);
        }
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof AbstractElement) {
            return;
        }
        super.setFocused(guiEventListener);
    }

    protected void renderBlurredBackground(float p_330683_) {
        super.renderBlurredBackground(p_330683_);
    }

    public boolean mouseClicked(double p_94695_, double p_94696_, int p_94697_) {
        this.setFocused(null);
        return super.mouseClicked(p_94695_, p_94696_, p_94697_);
    }

    public boolean keyPressed(int p_96552_, int p_96553_, int p_96554_) {
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)child;
            e.keyPressedRegardlessIfFocus(p_96552_, p_96553_, p_96554_);
        }
        return super.keyPressed(p_96552_, p_96553_, p_96554_);
    }

    public boolean keyReleased(int p_94715_, int p_94716_, int p_94717_) {
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)child;
            e.KeyReleasedRegardlessIfFocus(p_94715_, p_94716_, p_94717_);
        }
        return super.keyReleased(p_94715_, p_94716_, p_94717_);
    }

    public boolean doRenderBackground() {
        return true;
    }

    public List<Class<? extends AbstractSlice>> getSlices() {
        return List.of();
    }

    @Override
    public void onStoreUpdated(List<Class<? extends AbstractSlice>> changedSlices) {
        if (this.isResizing) {
            return;
        }
        this.rootView.onStoreUpdated(changedSlices);
    }

    public void reRenderRoot() {
        this.setFocused(null);
        this.clearWidgets();
        this.rootView = this.createRootView();
        this.addRenderableWidget((GuiEventListener)this.rootView);
    }

    private void renderDarkBackground_1_21_1_above(GuiGraphics graphics) {
        graphics.fill(0, 0, this.width, this.height, 0x40000000);
    }

    private static class RootView
    extends AbstractElement {
        private Consumer<AbstractElement> reRenderer;

        public RootView(AbstractElement parent, Screen screen, Consumer<AbstractElement> reRenderer) {
            super(parent, screen);
            this.reRenderer = reRenderer;
        }

        @Override
        public AbstractElement init() {
            this.reRenderer.accept(this);
            return this;
        }
    }
}

