/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.widget;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class OneLineLimitedTextArea
extends AbstractWidget {
    private Font font;
    private Tooltip msgTooltip;

    public OneLineLimitedTextArea(int x, int y, int w, Component msg) {
        super(x, y, w, 0, msg);
        this.font = Minecraft.getInstance().font;
        this.msgTooltip = Tooltip.create((Component)msg);
        Objects.requireNonNull(this.font);
        this.height = 9 + 2;
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        int acceptedWidth = this.width - 5;
        int tX = this.getX();
        int tY = this.getY();
        Component msg = this.getMessage();
        if (msg == null) {
            return;
        }
        int msgWidth = this.font.width((FormattedText)msg);
        if (msgWidth > acceptedWidth) {
            String posfix = "..";
            String newStr = this.font.plainSubstrByWidth(msg.getString(), acceptedWidth - this.font.width(posfix)) + posfix;
            msg = Component.literal((String)newStr).withStyle(msg.getStyle());
            this.setTooltip(this.msgTooltip);
        }
        graphics.drawString(this.font, msg, tX, tY, -1);
    }

    protected void updateWidgetNarration(NarrationElementOutput p_259858_) {
    }

    public boolean keyPressed(int p_94745_, int p_94746_, int p_94747_) {
        return false;
    }

    public boolean keyReleased(int p_94750_, int p_94751_, int p_94752_) {
        return false;
    }

    public boolean mouseClicked(double p_93641_, double p_93642_, int p_93643_) {
        return false;
    }
}

