/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.PlacedTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public class DogBedTileEntity
extends PlacedTileEntity {
    private ICasingMaterial casingType = DogBedMaterialManager.NaniCasing.NULL;
    private IBeddingMaterial beddingType = DogBedMaterialManager.NaniBedding.NULL;
    public static ModelProperty<ICasingMaterial> CASING = new ModelProperty();
    public static ModelProperty<IBeddingMaterial> BEDDING = new ModelProperty();
    public static ModelProperty<Direction> FACING = new ModelProperty();
    @Deprecated
    @Nullable
    private Dog dog;
    @Nullable
    private UUID dogUUID;
    @Nullable
    private Component name;
    @Nullable
    private Component ownerName;

    public DogBedTileEntity(BlockPos pos, BlockState blockState) {
        super(DoggyTileEntityTypes.DOG_BED.get(), pos, blockState);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider prov) {
        super.loadAdditional(compound, prov);
        this.casingType = DogBedMaterialManager.getCasing(compound, "casingId");
        this.beddingType = DogBedMaterialManager.getBedding(compound, "beddingId");
        this.dogUUID = NBTUtil.getUniqueId(compound, "ownerId");
        this.name = NBTUtil.getTextComponent(compound, "name");
        this.ownerName = NBTUtil.getTextComponent(compound, "ownerName");
        this.requestModelDataUpdate();
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider prov) {
        super.saveAdditional(compound, prov);
        NBTUtil.putRegistryValue(compound, "casingId", DogBedMaterialManager.getKey(this.casingType));
        NBTUtil.putRegistryValue(compound, "beddingId", DogBedMaterialManager.getKey(this.beddingType));
        NBTUtil.putUniqueId(compound, "ownerId", this.dogUUID);
        NBTUtil.putTextComponent(compound, "name", this.name);
        NBTUtil.putTextComponent(compound, "ownerName", this.ownerName);
    }

    public void setCasing(ICasingMaterial casingType) {
        this.casingType = casingType;
        this.setChanged();
        this.requestModelDataUpdate();
    }

    public void setBedding(IBeddingMaterial beddingType) {
        this.beddingType = beddingType;
        this.setChanged();
        this.requestModelDataUpdate();
    }

    public ICasingMaterial getCasing() {
        return this.casingType;
    }

    public IBeddingMaterial getBedding() {
        return this.beddingType;
    }

    public ModelData getModelData() {
        BlockState state = this.getBlockState();
        Direction facing = Direction.NORTH;
        if (state != null && state.hasProperty((Property)DogBedBlock.FACING)) {
            facing = (Direction)state.getValue((Property)DogBedBlock.FACING);
        }
        return ModelData.builder().with(CASING, (Object)this.casingType).with(BEDDING, (Object)this.beddingType).with(FACING, (Object)facing).build();
    }

    public void setOwner(@Nullable Dog owner) {
        this.setOwner(owner == null ? null : owner.getUUID());
        this.dog = owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.dog = null;
        this.dogUUID = owner;
        this.setChanged();
    }

    @Nullable
    public UUID getOwnerUUID() {
        return this.dogUUID;
    }

    @Nullable
    public Dog getOwner() {
        return WorldUtil.getCachedEntity(this.level, Dog.class, this.dog, this.dogUUID);
    }

    @Nullable
    public Component getBedName() {
        return this.name;
    }

    @Nullable
    public Component getOwnerName() {
        Component text;
        if (this.dogUUID == null || this.level == null) {
            return null;
        }
        DogLocationData locData = DogLocationStorage.get(this.level).getData(this.dogUUID);
        if (locData != null && (text = locData.getName()) != null) {
            this.ownerName = text;
        }
        return this.ownerName;
    }

    public boolean shouldDisplayName(LivingEntity camera) {
        return true;
    }

    public void setBedName(@Nullable Component nameIn) {
        this.name = nameIn;
        this.setChanged();
    }
}

