/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.feature.DogSize;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.util.RandomUtil;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ObjectUtils;

public class DogPettingManager {
    private final Dog dog;
    private boolean locked = false;
    private long lastPetTimestamp = 0L;
    private int burn_cooldown = 10;

    public DogPettingManager(Dog dog) {
        this.dog = dog;
    }

    public boolean isPetting() {
        return this.dog.getPettingState().is_petting();
    }

    public UUID getPetterId() {
        return this.dog.getPettingState().petting_id();
    }

    public void setPetting(Player petter, DogPettingType type) {
        if (petter == null || type == null || !this.canPet(petter)) {
            return;
        }
        if (this.isPetting()) {
            return;
        }
        this.dog.setPettingState(new DogPettingState(petter.getUUID(), true, type));
        petter.yBodyRot = petter.yHeadRot;
    }

    public void stopPetting() {
        if (!this.dog.level().isClientSide) {
            this.lastPetTimestamp = this.dog.level().getDayTime();
        }
        this.dog.setPettingState(DogPettingState.NULL);
    }

    public long getTimeSinceLastPet() {
        long ret = this.dog.level().getDayTime() - this.lastPetTimestamp;
        if (ret < 0L) {
            ret = 0L;
        }
        return ret;
    }

    public float getJealousChance() {
        long chance_time_start = 400L;
        long chance_time_end = 6000L;
        float max_chance = 0.2f;
        float min_chance = 0.05f;
        long last_pet_time = this.getTimeSinceLastPet();
        if (last_pet_time <= 400L) {
            return -1.0f;
        }
        long chance_time = last_pet_time - 400L;
        double progress = (double)chance_time / 5600.0;
        progress = Mth.clamp((double)progress, (double)0.0, (double)1.0);
        double ret = (double)0.05f + progress * (double)0.15f;
        return (float)ret;
    }

    public void tick() {
        Player petter;
        if (!this.dog.level().isClientSide && this.isPetting() && !this.canPet(this.getPetterFromDog())) {
            this.stopPetting();
        }
        if (this.dog.level().isClientSide && this.isPetting()) {
            this.playParticleEffect();
        }
        if (!this.dog.level().isClientSide && this.isPetting() && this.dog.dogVariant().burnsPetter()) {
            this.mayDoLoveBurns();
        }
        if (this.isPetting() && (petter = this.getPetterFromDog()) != null) {
            petter.yBodyRot = petter.yHeadRot;
        }
    }

    public void mayDoLoveBurns() {
        if (--this.burn_cooldown > 0) {
            return;
        }
        RandomSource random = this.dog.getRandom();
        if (random.nextInt(100) != 0) {
            return;
        }
        this.burn_cooldown = (7 + random.nextInt(9)) * 20;
        Player petter = this.getPetterFromDog();
        if (petter == null) {
            return;
        }
        boolean hurt_result = petter.hurt(petter.damageSources().lava(), 0.1f);
        if (hurt_result) {
            petter.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + random.nextFloat() * 0.4f);
            if (this.dog.level() instanceof ServerLevel) {
                ((ServerLevel)this.dog.level()).sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, petter.getX(), petter.getY(), petter.getZ(), random.nextIntBetweenInclusive(2, 4), (double)petter.getBbWidth(), (double)0.8f, (double)petter.getBbWidth(), 0.1);
            }
        }
    }

    public void playParticleEffect() {
        RandomSource random = this.dog.getRandom();
        if (this.dog.getRandom().nextInt(20) == 0) {
            double x = this.dog.getX() + (double)RandomUtil.nextFloatRemapped(random) * ((double)(this.dog.getBbWidth() / 2.0f) + 0.3);
            double y = this.dog.getY() + 0.4 + (double)random.nextFloat() * ((double)this.dog.getBbHeight() - 0.4);
            double z = this.dog.getZ() + (double)RandomUtil.nextFloatRemapped(random) * ((double)(this.dog.getBbWidth() / 2.0f) + 0.3);
            double dx = random.nextGaussian() * 0.02;
            double dy = random.nextGaussian() * 0.02;
            double dz = random.nextGaussian() * 0.02;
            this.dog.level().addParticle((ParticleOptions)ParticleTypes.HEART, x, y, z, dx, dy, dz);
        }
    }

    public boolean canPet(Player player) {
        if (this.locked) {
            return false;
        }
        if (player == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)this.dog.getOwnerUUID(), (Object)player.getUUID())) {
            return false;
        }
        if (!this.isInPetDistance(this.dog, player)) {
            return false;
        }
        if (!this.isSelectingDog(player, this.dog)) {
            return false;
        }
        if (!DogPettingManager.isPlayerAbleToPet(player)) {
            return false;
        }
        return DogPettingManager.isDogAbleToBePet(this.dog);
    }

    public static boolean isPlayerAbleToPet(Player player) {
        ItemStack mainhand_item = player.getMainHandItem();
        if (mainhand_item != null && !mainhand_item.isEmpty()) {
            return false;
        }
        if (player.isVehicle() || player.isPassenger()) {
            return false;
        }
        if (player.isSpectator()) {
            return false;
        }
        return player.isShiftKeyDown();
    }

    public static boolean isDogAbleToBePet(Dog dog) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!dog.isInSittingPose() || !DogPettingManager.isDogPoseCanPet(dog.getDogPose())) {
            return false;
        }
        if (dog.isOnFire()) {
            return false;
        }
        if (dog.isVehicle() || dog.isPassenger()) {
            return false;
        }
        DogSize size = dog.getDogSize();
        return size.largerOrEquals(DogSize.MODERATO);
    }

    public static boolean isDogPoseCanPet(DogPose dogPose) {
        return dogPose == DogPose.SIT || dogPose == DogPose.REST_BELLY;
    }

    public boolean isInPetDistance(Dog dog, Player player) {
        double max_dist = this.getMaxPetDistance(dog, player);
        if (dog.distanceToSqr((Entity)player) >= max_dist * max_dist) {
            return false;
        }
        return this.checkEyeDistance(dog, player);
    }

    private double getMaxPetDistance(Dog dog, Player player) {
        float dog_bbw = dog.getBbWidth();
        return (double)(dog_bbw / 2.0f + player.getBbWidth() / 2.0f) + 0.5;
    }

    private boolean checkEyeDistance(Dog dog, Player player) {
        double dog_eye_y;
        double player_eye_y = player.getEyeY();
        double d_eye_y = player_eye_y - (dog_eye_y = dog.getEyeY());
        return 0.3 <= d_eye_y || d_eye_y <= 0.5;
    }

    private boolean isSelectingDog(Player player, Dog dog) {
        Vec3 eye_pos;
        double pick_range = player.entityInteractionRange();
        Vec3 view_vec = player.getViewVector(1.0f);
        Vec3 from_vec = eye_pos = player.getEyePosition(0.0f);
        Vec3 to_vec = eye_pos.add(view_vec.scale(pick_range));
        AABB dog_bb = dog.getBoundingBox();
        boolean hit_dog = dog_bb.clip(from_vec, to_vec).isPresent();
        return hit_dog;
    }

    private Player getPetterFromDog() {
        if (!this.isPetting()) {
            return null;
        }
        UUID pet_uuid = this.getPetterId();
        Player petter = this.dog.level().getPlayerByUUID(pet_uuid);
        return petter;
    }

    public boolean checkPush(Entity source) {
        if (!this.isPetting()) {
            return false;
        }
        Player petting = this.getPetterFromDog();
        if (petting != source) {
            return false;
        }
        float max_go_inside_bb_dist = this.getMinClipDistanceWhenPet();
        if (max_go_inside_bb_dist <= 0.0f) {
            return false;
        }
        return !(petting.distanceToSqr((Entity)this.dog) < (double)(max_go_inside_bb_dist * max_go_inside_bb_dist));
    }

    private float getMinClipDistanceWhenPet() {
        DogPettingType type = this.dog.getPettingState().type();
        if (type == DogPettingType.BACK_HUG || type == DogPettingType.BELLY_RUB) {
            return 0.7f * this.dog.getBbWidth() / 2.0f;
        }
        return -1.0f;
    }

    public void setLocked(boolean lock) {
        this.locked = lock;
    }

    public void save(CompoundTag tag) {
        CompoundTag tag0 = new CompoundTag();
        tag0.putLong("dog_last_pet_time", this.lastPetTimestamp);
        tag.put("dogPettingManager", (Tag)tag0);
    }

    public void load(CompoundTag tag) {
        this.lastPetTimestamp = 0L;
        if (tag.contains("dogPettingManager", 10)) {
            CompoundTag tag0 = tag.getCompound("dogPettingManager");
            this.lastPetTimestamp = tag0.getLong("dog_last_pet_time");
        }
    }

    public record DogPettingState(UUID petting_id, boolean is_petting, DogPettingType type) {
        public static DogPettingState NULL = new DogPettingState(Util.NIL_UUID, false, DogPettingType.FACERUB);
    }

    public static enum DogPettingType {
        FACERUB(0),
        HUG(1),
        BELLY_RUB(2),
        BACK_HUG(3);

        private final int id;

        private DogPettingType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static DogPettingType fromId(int id) {
            DogPettingType[] vals = DogPettingType.values();
            if (id < 0 || id >= vals.length) {
                id = 0;
            }
            return vals[id];
        }
    }
}

