/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalents;
import doggytalents.api.feature.DogSize;
import doggytalents.client.DTNClientDogSleepOnManager;
import doggytalents.common.entity.Dog;
import doggytalents.common.talent.BedDogTalent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class DogSleepOnManager {
    private static final DogSleepOnManager SERVER_INSTANCE = new DogSleepOnManager();
    private final Map<UUID, SleepOnPair> sleepingOnPairs = Maps.newHashMap();
    private final List<SleepOnPair> toRemove = new ArrayList<SleepOnPair>();

    private DogSleepOnManager() {
    }

    public static DogSleepOnManager getServer(Level level) {
        if (level.isClientSide) {
            throw new IllegalStateException("Only access this class's instance from the Logical Server.");
        }
        return SERVER_INSTANCE;
    }

    public static DogSleepOnManager getServer(MinecraftServer server) {
        if (server == null) {
            throw new IllegalStateException("Only access this class's instance from the Logical Server.");
        }
        return SERVER_INSTANCE;
    }

    public StartSleepOnDogResult setOrRequestSleepOn(Dog dog, Player player) {
        StartSleepOnDogResult sleep_condition = this.isSleepCondition(dog);
        if (!sleep_condition.ok()) {
            return sleep_condition;
        }
        if (dog.sleepOnManager.isSleepOnReady()) {
            return this.setPlayerSleepOn(dog, player);
        }
        dog.sleepOnManager.setRequestedSleepOn(true);
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult setPlayerSleepOn(Dog dog, Player player) {
        StartSleepOnDogResult can_start = this.canPlayerStartSleepOnDog(dog, player);
        if (!can_start.ok()) {
            return can_start;
        }
        Optional<Pair<Float, Vec3>> sleep_pair_optional = this.findSleepRot(dog, player);
        if (!sleep_pair_optional.isPresent()) {
            return DogSleepOnFailMessage.NO_POS.asResult();
        }
        Pair<Float, Vec3> sleep_pair = sleep_pair_optional.get();
        float sleep_yrot = ((Float)sleep_pair.getLeft()).floatValue();
        player.startSleeping(dog.blockPosition());
        player.moveTo((Vec3)sleep_pair.getRight());
        this.rotateDogPerpenToSleepYRot(dog, sleep_yrot);
        DogSleepOnManager.rotatePlayerYRotToDog(dog, player, sleep_yrot);
        dog.setSleepOnState(new DogSleepOnState(player.getUUID(), true, sleep_yrot));
        this.addDogSleepOnPair(player, dog);
        ((ServerLevel)player.level()).updateSleepingPlayerList();
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult canPlayerStartSleepOnDog(Dog dog, Player player) {
        StartSleepOnDogResult sleep_condition = this.isSleepCondition(dog);
        if (!sleep_condition.ok()) {
            return sleep_condition;
        }
        if (!dog.sleepOnManager.sleepOnReady) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult isSleepCondition(Dog dog) {
        if (!dog.isDoingFine()) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        ServerLevel level = (ServerLevel)dog.level();
        if (level.isDay()) {
            return DogSleepOnFailMessage.NOT_SLEEP_TIME.asResult();
        }
        if (!level.canSleepThroughNights()) {
            return DogSleepOnFailMessage.CANT_SLEEP_THROUGH_NIGHT.asResult();
        }
        if (!level.dimensionType().bedWorks()) {
            return DogSleepOnFailMessage.NO_SLEEP_DIM.asResult();
        }
        if (!dog.getDogSize().largerOrEquals(DogSize.MODERATO)) {
            return DogSleepOnFailMessage.TOO_SMOL.asResult();
        }
        if (dog.getDogSize().largerOrEquals(DogSize.FORTE)) {
            return DogSleepOnFailMessage.TOO_BIG.asResult();
        }
        Optional<BedDogTalent> inst = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst.isPresent()) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        StartSleepOnDogResult inst_result = BedDogTalent.isSleepCondition(dog, inst.get());
        if (!inst_result.ok()) {
            return inst_result;
        }
        return StartSleepOnDogResult.OK;
    }

    private Optional<Pair<Float, Vec3>> findSleepRot(Dog dog, Player player) {
        float check_yrot1 = player.getYRot() + 180.0f;
        Vec3 check_pos1 = this.getPlayerSleepPos(dog, check_yrot1);
        if (this.checkIfSleepPosIsEligible(dog, check_pos1)) {
            return Optional.of(Pair.of((Object)Float.valueOf(check_yrot1), (Object)check_pos1));
        }
        float dog_yrot = dog.getYRot();
        for (int i = 0; i < 8; ++i) {
            float check_yrot = dog_yrot + (float)i * 45.0f;
            Vec3 check_pos = this.getPlayerSleepPos(dog, check_yrot);
            if (!this.checkIfSleepPosIsEligible(dog, check_pos)) continue;
            return Optional.of(Pair.of((Object)Float.valueOf(check_yrot), (Object)check_pos));
        }
        return Optional.empty();
    }

    private boolean checkIfSleepPosIsEligible(Dog dog, Vec3 check_pos) {
        Iterable air_iterater = BlockPos.betweenClosed((BlockPos)BlockPos.containing((Position)check_pos.add(-1.0, 0.0, -1.0)), (BlockPos)BlockPos.containing((Position)check_pos.add(1.0, 0.0, 1.0)));
        for (BlockPos pos : air_iterater) {
            BlockState state = dog.level().getBlockState(pos);
            if (state.isAir()) continue;
            return false;
        }
        Iterable solid_iterater = BlockPos.betweenClosed((BlockPos)BlockPos.containing((Position)check_pos.add(-1.0, -1.0, -1.0)), (BlockPos)BlockPos.containing((Position)check_pos.add(1.0, -1.0, 1.0)));
        for (BlockPos pos : solid_iterater) {
            BlockState state = dog.level().getBlockState(pos);
            if (state.isCollisionShapeFullBlock((BlockGetter)dog.level(), pos)) continue;
            return false;
        }
        return true;
    }

    private Vec3 getPlayerSleepPos(Dog dog, float dog_sleep_rot) {
        Vec3 sleep_on_pos = this.getSleepOnHeadPos(dog, dog_sleep_rot);
        Vec3 dog_view_vec = dog.calculateViewVector(0.0f, dog_sleep_rot);
        double distance_to_dog = 0.3;
        return new Vec3(dog_view_vec.x, 0.0, dog_view_vec.z).normalize().scale(0.3).add(sleep_on_pos);
    }

    private Vec3 getSleepOnHeadPos(Dog dog, float dog_sleep_rot) {
        float side_translate = -0.3f;
        float translate_rot = dog_sleep_rot + 90.0f;
        Vec3 translate_vec = dog.calculateViewVector(0.0f, translate_rot).scale((double)-0.3f);
        return dog.position().add(translate_vec);
    }

    private void rotateDogPerpenToSleepYRot(Dog dog, float dog_sleep_yrot) {
        float rotate_yrot = Mth.wrapDegrees((float)(dog_sleep_yrot + 90.0f));
        dog.setYRot(rotate_yrot);
        dog.yHeadRot = dog.yBodyRot = dog.getYRot();
    }

    public Optional<Dog> getSleepingOnDog(LivingEntity entity) {
        if (this.sleepingOnPairs.isEmpty()) {
            return Optional.empty();
        }
        if (!(entity instanceof Player)) {
            return Optional.empty();
        }
        Player player = (Player)entity;
        return Optional.ofNullable(this.sleepingOnPairs.get(player.getUUID()).dog());
    }

    public void stopPlayerSleepOn(Dog dog) {
        dog.setSleepOnState(DogSleepOnState.NULL);
        this.clearPlayerSleepOnFor(dog);
    }

    public static void tickServer(MinecraftServer server) {
        DogSleepOnManager.getServer(server).invalidateSleepers();
    }

    public static void onServerStop(MinecraftServer server) {
        DogSleepOnManager.getServer((MinecraftServer)server).sleepingOnPairs.clear();
    }

    private void invalidateSleepers() {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, SleepOnPair> entry : this.sleepingOnPairs.entrySet()) {
            SleepOnPair pair = entry.getValue();
            if (this.stillValidSleepingPair(pair.dog(), pair.player())) continue;
            this.toRemove.add(pair);
        }
        if (this.toRemove.isEmpty()) {
            return;
        }
        for (SleepOnPair x : this.toRemove) {
            this.stopPlayerSleepOn(x.dog());
        }
        this.toRemove.clear();
    }

    private boolean stillValidSleepingPair(Dog dog, Player player) {
        if (!player.isAlive() || !dog.isAlive()) {
            return false;
        }
        if (!player.isSleeping()) {
            return false;
        }
        DogSleepOnState dog_sleeping_state = dog.getSleepOnState();
        if (!dog_sleeping_state.is_sleeping()) {
            return false;
        }
        if (!this.isSleepCondition(dog).ok()) {
            return false;
        }
        Vec3 sleep_pos = this.getPlayerSleepPos(dog, dog_sleeping_state.sleep_yrot());
        return !(player.distanceToSqr(sleep_pos) > 0.010000000000000002);
    }

    private void addDogSleepOnPair(Player player, Dog dog) {
        UUID uuid = player.getUUID();
        if (uuid == null) {
            return;
        }
        this.sleepingOnPairs.put(uuid, new SleepOnPair(dog, player));
    }

    private void removeSleepingOnDogToMap(UUID sleeper_id) {
        this.sleepingOnPairs.remove(sleeper_id);
    }

    private void clearPlayerSleepOnFor(Dog dog) {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, SleepOnPair> entry : this.sleepingOnPairs.entrySet()) {
            if (entry.getValue().dog() != dog) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID key : toRemove) {
            this.removeSleepingOnDogToMap(key);
        }
    }

    private void checkAndClearWhenPlayerWakeUp(Player player) {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        SleepOnPair pair = this.sleepingOnPairs.get(player.getUUID());
        if (pair == null) {
            return;
        }
        this.stopPlayerSleepOn(pair.dog());
    }

    private void notifySleepSuccesAllDogAndStopSleeping(ServerLevel level) {
        this.invalidateSleepers();
        ArrayList<SleepOnPair> toRemove = new ArrayList<SleepOnPair>();
        for (Map.Entry<UUID, SleepOnPair> entry : this.sleepingOnPairs.entrySet()) {
            SleepOnPair pair = entry.getValue();
            Dog dog = pair.dog();
            if (!this.stillValidSleepingPair(dog, pair.player()) || dog.level() != level) continue;
            this.notifySleepSuccessDog(dog);
            toRemove.add(pair);
        }
        for (SleepOnPair sleepOnPair : toRemove) {
            this.stopPlayerSleepOn(sleepOnPair.dog());
        }
    }

    private void notifySleepSuccessDog(Dog dog) {
        Optional<BedDogTalent> inst = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst.isPresent()) {
            return;
        }
        inst.get().onSuccessfulSleep(dog);
    }

    public static void canPlayerContinueSleeping(CanContinueSleepingEvent event) {
        if (event.getProblem() != Player.BedSleepingProblem.NOT_POSSIBLE_HERE) {
            return;
        }
        LivingEntity player = event.getEntity();
        Optional<Dog> dog_optional = DogSleepOnManager.getServer(player.getServer()).getSleepingOnDog(player);
        if (!dog_optional.isPresent()) {
            return;
        }
        event.setContinueSleeping(true);
    }

    public static void beforeSleepFinishedForAllPlayer(SleepFinishedTimeEvent event) {
        ServerLevel level = (ServerLevel)event.getLevel();
        DogSleepOnManager.getServer((Level)level).notifySleepSuccesAllDogAndStopSleeping(level);
    }

    public static void onPlayerWakeUp(Player player) {
        ServerLevel level = (ServerLevel)player.level();
        DogSleepOnManager.getServer((Level)level).checkAndClearWhenPlayerWakeUp(player);
    }

    public static void onDogSleepOnDataUpdated(Dog dog, DogSleepOnState state) {
        if (dog.level().isClientSide) {
            DTNClientDogSleepOnManager.get().onDogSleepOnDataUpdated(dog, state);
        }
    }

    public static void onSleepGoalStop(Dog dog) {
        dog.sleepOnManager.onSleepOnGoalStop();
        DogSleepOnManager.getServer(dog.level()).stopPlayerSleepOn(dog);
    }

    public static void onHurt(Dog dog) {
        if (dog.level().isClientSide) {
            return;
        }
        if (!dog.getSleepOnState().is_sleeping()) {
            return;
        }
        DogSleepOnManager.getServer(dog.level()).stopPlayerSleepOn(dog);
    }

    public static boolean shouldBlockPush(Dog dog) {
        return dog.getSleepOnState().is_sleeping();
    }

    public static void rotatePlayerYRotToDog(Dog dog, Player player, float dog_sleep_yrot) {
        float rotate_yrot = Mth.wrapDegrees((float)(dog_sleep_yrot - 180.0f));
        player.setYRot(rotate_yrot);
        player.yHeadRot = player.yBodyRot = player.getYRot();
    }

    public static Optional<Player> getSleeperFromDog(Dog dog) {
        DogSleepOnState state = dog.getSleepOnState();
        return DogSleepOnManager.getSleeperFromDog(dog, state);
    }

    public static Optional<Player> getSleeperFromDog(Dog dog, DogSleepOnState state) {
        Player sleeper = dog.level().getPlayerByUUID(state.sleeper());
        return Optional.ofNullable(sleeper);
    }

    public static class StartSleepOnDogResult {
        public static StartSleepOnDogResult OK = new StartSleepOnDogResult(Optional.empty());
        private Optional<DogSleepOnFailMessage> failMsg = Optional.empty();

        public StartSleepOnDogResult(Optional<DogSleepOnFailMessage> failMsg) {
            this.failMsg = failMsg;
        }

        public boolean ok() {
            return !this.failMsg.isPresent();
        }

        public boolean other() {
            return this.isFailMsg(DogSleepOnFailMessage.OTHER);
        }

        public DogSleepOnFailMessage failMsg() {
            return this.failMsg.orElse(null);
        }

        public boolean isFailMsg(DogSleepOnFailMessage msg) {
            return this.failMsg.isPresent() && this.failMsg.get() == msg;
        }
    }

    public static class PerDog {
        private final Dog dog;
        private boolean sleepOnRequested = false;
        private boolean sleepOnReady = false;
        private int requestTimeout = 0;

        public PerDog(Dog dog) {
            this.dog = dog;
        }

        public void tick() {
            if (!this.dog.level().isClientSide) {
                this.invalidateRequest();
            }
        }

        public void setSleepOnReady(boolean val) {
            this.sleepOnReady = val;
        }

        public boolean isSleepOnReady() {
            return this.sleepOnReady;
        }

        private void invalidateRequest() {
            if (!this.sleepOnRequested) {
                return;
            }
            if (this.requestTimeout > 0) {
                --this.requestTimeout;
            }
            if (this.requestTimeout <= 0) {
                this.sleepOnRequested = false;
            }
        }

        public void setRequestedSleepOn(boolean val) {
            this.sleepOnRequested = val;
            this.requestTimeout = 20;
        }

        public boolean isSleepOnRequested() {
            return this.sleepOnRequested;
        }

        public void onSleepOnGoalStop() {
            this.sleepOnRequested = false;
            this.sleepOnReady = false;
        }
    }

    public static enum DogSleepOnFailMessage {
        NOT_SLEEP_TIME("not_sleep_time", (dog, locId) -> Component.translatable((String)locId, (Object[])new Object[]{dog.getName().getString()})),
        OTHER("other", (dog, locId) -> Component.translatable((String)locId)),
        CANT_SLEEP_THROUGH_NIGHT("cant_sleep_thru_night", (dog, locId) -> Component.translatable((String)locId)),
        NO_SLEEP_DIM("no_sleep_dim", (dog, locId) -> Component.translatable((String)locId)),
        DOG_LOW_HUNGER("low_hunger", (dog, locId) -> Component.translatable((String)locId, (Object[])new Object[]{dog.getName().getString(), dog.getGenderSubject()})),
        COOLDOWN("cooldown", (dog, locId) -> Component.empty()),
        NO_POS("no_pos", (dog, locId) -> Component.translatable((String)locId, (Object[])new Object[]{dog.getName().getString(), dog.getGenderSubject()})),
        TOO_SMOL("to_smol", (dog, locId) -> Component.translatable((String)locId, (Object[])new Object[]{dog.getName().getString(), dog.getGenderSubject()})),
        TOO_BIG("to_big", (dog, locId) -> Component.translatable((String)locId, (Object[])new Object[]{dog.getName().getString(), dog.getGenderSubject()}));

        private final String locId;
        private final BiFunction<Dog, String, Component> msgGetter;

        private DogSleepOnFailMessage(String locId, BiFunction<Dog, String, Component> msgGetter) {
            this.locId = "talent.doggytalents.bed_dog.fail." + locId;
            this.msgGetter = msgGetter;
        }

        public Component getMsg(Dog dog) {
            return this.msgGetter.apply(dog, this.locId);
        }

        public StartSleepOnDogResult asResult() {
            return new StartSleepOnDogResult(Optional.of(this));
        }
    }

    public record DogSleepOnState(UUID sleeper, boolean is_sleeping, float sleep_yrot) {
        public static DogSleepOnState NULL = new DogSleepOnState(Util.NIL_UUID, false, 0.0f);
    }

    private record SleepOnPair(Dog dog, Player player) {
    }
}

