/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;

public class DogFollowOwnerGoal
extends Goal
implements DogAiManager.IHasTickNonRunning {
    private final Dog dog;
    private final Level world;
    private final double followSpeed;
    private final float stopDist;
    private final float startDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private int tickTillSearchForTp = 0;
    private float oldWaterCost;
    private int followRequest = 0;

    public DogFollowOwnerGoal(Dog dogIn, double speedIn, float minDistIn, float maxDistIn) {
        this.dog = dogIn;
        this.world = dogIn.level();
        this.followSpeed = speedIn;
        this.startDist = minDistIn;
        this.stopDist = maxDistIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity owner = this.dog.getOwner();
        if (owner == null) {
            return false;
        }
        if (!this.dog.getMode().shouldFollowOwner()) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        if (this.dog.isInSittingPose()) {
            return false;
        }
        if (!this.dog.hasBone() && this.dog.distanceToSqr((Entity)owner) < (double)this.getMinStartDistanceSq() && this.followRequest <= 0) {
            return false;
        }
        if (this.dog.getDogSitOverridePos().isPresent()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.dog.getNavigation().isDone()) {
            return false;
        }
        if (this.dog.isInSittingPose()) {
            return false;
        }
        return this.dog.distanceToSqr((Entity)this.owner) > (double)(this.stopDist * this.stopDist);
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dog.getPathfindingMalus(PathType.WATER);
        this.dog.setDogFollowingSomeone(true);
    }

    public void stop() {
        double distanceToOwner;
        if (this.dog.hasBone() && (distanceToOwner = this.owner.distanceToSqr((Entity)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.spawnAtLocation(fetchItem, 0.0f);
            this.dog.setBoneVariant(ItemStack.EMPTY);
        }
        this.owner = null;
        this.dog.getNavigation().stop();
        this.dog.setDogFollowingSomeone(false);
        this.followRequest = 0;
        this.dog.randomStrollCooldown = 40;
    }

    public void tick() {
        this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.dog.isDogFlying() ? 5 : 10;
            DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.followSpeed, 144.0, true, --this.tickTillSearchForTp <= 0, 400.0, this.dog.getMaxFallDistance());
            if (this.tickTillSearchForTp <= 0) {
                this.tickTillSearchForTp = 10;
            }
        }
    }

    public float getMinStartDistanceSq() {
        return this.startDist * this.startDist;
    }

    @Override
    public void tickDogWhenNotRunning() {
        if (this.followRequest > 0) {
            --this.followRequest;
        }
    }

    public void requestFollow() {
        this.followRequest = 20;
    }
}

