/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogRandomSitIdleGoal
extends Goal {
    private Dog dog;
    private int stopTick;
    private DogAnimation currentAnimation = DogAnimation.NONE;

    public DogRandomSitIdleGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.dog.isOrderedToSit()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        if ((double)this.dog.getRandom().nextFloat() >= 0.02) {
            return false;
        }
        this.currentAnimation = this.getIdleAnim();
        return this.currentAnimation != DogAnimation.NONE;
    }

    public boolean canContinueToUse() {
        if (!this.dog.isOrderedToSit()) {
            return false;
        }
        if (this.dog.getDogPose() != DogPose.SIT) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        return this.dog.tickCount < this.stopTick;
    }

    public void start() {
        this.stopTick = this.dog.tickCount + this.currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(this.currentAnimation);
    }

    public void tick() {
    }

    public void stop() {
        if (this.dog.getAnim() == this.currentAnimation) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    private DogAnimation getIdleAnim() {
        float r = this.dog.getRandom().nextFloat();
        if (r <= 0.1f) {
            return DogAnimation.SCRATCHIE;
        }
        if (r <= 0.2f) {
            return DogAnimation.SIT_LOOK_AROUND;
        }
        if (r <= 0.3f) {
            return DogAnimation.BELLY_RUB;
        }
        return DogAnimation.NONE;
    }
}

