/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class DogRandomSniffGoal
extends Goal
implements DogAiManager.IHasTickNonRunning {
    private Dog dog;
    private int stopTick;
    private BlockPos sniffAtPos;
    private BlockPos sniffUnderPos;
    private BlockState sniffAtState;
    private BlockState sniffUnderState;
    private BlockPos currentPos;
    private DogAnimation currentAnimation = DogAnimation.NONE;
    private int tickAnim = 0;
    private boolean isDoingAnim = false;
    private boolean shouldMoveSignificantly = false;
    private final int EXPLORE_RADIUS = 6;
    private int stillRememberBeingBurnedTick = 0;
    private boolean continueEvenWhenChanged = false;

    public DogRandomSniffGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        if (this.dog.randomStrollCooldown > 0) {
            return false;
        }
        if (this.dog.isOnFire()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        return !(this.dog.getRandom().nextFloat() >= 0.01f);
    }

    @Override
    public void tickDogWhenNotRunning() {
        if (this.stillRememberBeingBurnedTick > 0) {
            --this.stillRememberBeingBurnedTick;
        }
    }

    public boolean canContinueToUse() {
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.isDoingAnim) {
            return true;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != this.currentAnimation) {
            return false;
        }
        this.validateSniff();
        if (this.sniffAtPos == null) {
            return false;
        }
        return this.dog.tickCount < this.stopTick;
    }

    public void start() {
        this.isDoingAnim = false;
        BlockPos moveToPos = this.findMoveToPos();
        this.dog.getNavigation().moveTo((double)moveToPos.getX(), (double)moveToPos.getY(), (double)moveToPos.getZ(), 1.0);
        this.dog.setDogCurious(true);
        this.continueEvenWhenChanged = false;
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    public void tick() {
        if (this.isDoingAnim) {
            this.tickDoingAnim();
        } else {
            this.tickMoveTo();
        }
    }

    public void stop() {
        if (!this.dog.getAnim().interupting()) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.setDogCurious(false);
        this.resetSniffPos();
        this.dog.dogSoundManager.interuptPlaying();
        this.dog.getNavigation().stop();
        this.dog.dogSoundManager.setAmbientLocked(false);
    }

    private void startDoingAnim() {
        this.currentAnimation = this.getSniffAnim();
        this.stopTick = this.dog.tickCount + this.currentAnimation.getLengthTicks();
        this.dog.setAnimForIdle(this.currentAnimation);
        this.tickAnim = 0;
    }

    private void tickDoingAnim() {
        if (this.sniffAtPos == null) {
            return;
        }
        this.dog.getLookControl().setLookAt(Vec3.atBottomCenterOf((Vec3i)this.sniffAtPos));
        switch (this.currentAnimation) {
            default: {
                if (this.tickAnim == 3) {
                    SoundEvent sniff_sound = this.dog.dogMood.getSniffSound();
                    this.dog.dogSoundManager.playInterruptible(sniff_sound, 1.0f, this.dog.getVoicePitch());
                }
                ++this.tickAnim;
                break;
            }
            case SNIFF_HOT: {
                float maxAwayDist = this.shouldMoveSignificantly ? 0.35f : 0.1f;
                Vec3 current_center = Vec3.atBottomCenterOf((Vec3i)this.currentPos);
                double d_sqr = this.dog.distanceToSqr(current_center);
                double d_sqr_2 = this.dog.distanceToSqr((float)this.sniffAtPos.getX() + 0.5f, this.dog.getY(), (float)this.sniffAtPos.getZ() + 0.5f);
                if (this.tickAnim < 20 && (d_sqr < (double)maxAwayDist || d_sqr_2 > 1.0) && this.sniffAtState.isAir()) {
                    this.dog.getMoveControl().setWantedPosition((double)this.sniffAtPos.getX(), this.dog.getY(), (double)this.sniffAtPos.getZ(), 0.5);
                }
                if (this.tickAnim == 25) {
                    Vec3 pushBackVec = current_center.subtract(this.dog.position()).normalize();
                    this.dog.push(pushBackVec.x() * 0.3, 0.0, pushBackVec.z() * 0.3);
                    this.dog.playSound(SoundEvents.WOLF_HURT, 0.6f, this.dog.getVoicePitch());
                    this.dog.playSound(SoundEvents.GENERIC_BURN, 0.3f, 2.0f + this.dog.getRandom().nextFloat() * 0.4f);
                    this.rememberBeingBurned();
                    this.continueEvenWhenChanged = true;
                }
                ++this.tickAnim;
                break;
            }
            case SNIFF_SNEEZE: {
                if (this.tickAnim == 25) {
                    SoundEvent sneeze_sound = this.dog.dogMood.getSneezeSound();
                    this.dog.playSound(sneeze_sound, 1.0f, this.dog.getVoicePitch());
                    this.continueEvenWhenChanged = true;
                }
                ++this.tickAnim;
                break;
            }
            case TOUCHY_TOUCH: {
                if (this.tickAnim == 35) {
                    this.dog.playSound(SoundEvents.WOLF_HURT, 0.6f, this.dog.getVoicePitch());
                    this.dog.playSound(SoundEvents.GENERIC_BURN, 0.3f, 2.0f + this.dog.getRandom().nextFloat() * 0.4f);
                    this.rememberBeingBurned();
                    this.continueEvenWhenChanged = true;
                }
                ++this.tickAnim;
                break;
            }
            case DOWN_THE_HOLE: {
                float maxAwayDist = 0.1f;
                Vec3 current_center = Vec3.atBottomCenterOf((Vec3i)this.currentPos);
                double d_sqr = this.dog.distanceToSqr(current_center);
                double d_sqr_2 = this.dog.distanceToSqr((float)this.sniffAtPos.getX() + 0.5f, this.dog.getY(), (float)this.sniffAtPos.getZ() + 0.5f);
                if ((d_sqr < (double)maxAwayDist || d_sqr_2 > 1.0) && this.sniffAtState.isAir()) {
                    this.dog.getMoveControl().setWantedPosition((double)this.sniffAtPos.getX(), this.dog.getY(), (double)this.sniffAtPos.getZ(), 0.5);
                }
                if (this.tickAnim == 30) {
                    SoundEvent sound = this.dog.dogMood.getDownTheHoleSound();
                    this.dog.playSound(sound, 1.0f, this.dog.getVoicePitch());
                }
                ++this.tickAnim;
                break;
            }
            case SNIFF_AWW_HAPPY: {
                float max_close_dist = 1.2f;
                Vec3 current_center = Vec3.atBottomCenterOf((Vec3i)this.currentPos);
                Vec3 sniff_center = Vec3.atBottomCenterOf((Vec3i)this.sniffAtPos);
                double d_sqr = this.dog.distanceToSqr(sniff_center);
                if (d_sqr < (double)1.2f) {
                    Vec3 lookAtPos = Vec3.atBottomCenterOf((Vec3i)this.sniffAtPos);
                    this.dog.getLookControl().setLookAt(lookAtPos);
                    this.dog.getMoveControl().strafe(-0.25f, 0.0f);
                }
                if (this.tickAnim == 40) {
                    SoundEvent sound = this.dog.dogMood.getAwwSound();
                    this.dog.dogSoundManager.playInterruptible(sound, 0.6f, this.dog.getVoicePitch());
                }
                ++this.tickAnim;
                break;
            }
            case SPLASH: {
                boolean lava_effect;
                boolean bl = lava_effect = (this.tickAnim == 56 || this.tickAnim == 82 || this.tickAnim == 104) && this.dog.isInLava();
                if (lava_effect) {
                    RandomSource random = this.dog.getRandom();
                    float volume = this.tickAnim > 90 ? 10.0f : 4.0f;
                    this.dog.playSound(SoundEvents.STRIDER_STEP_LAVA, volume, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                    ((ServerLevel)this.dog.level()).sendParticles((ParticleOptions)ParticleTypes.LAVA, this.dog.getX(), this.dog.getY(), this.dog.getZ(), this.tickAnim > 90 ? 10 : 15, (double)this.dog.getBbWidth(), 1.0, (double)this.dog.getBbWidth(), 0.1);
                }
                if (this.tickAnim == 92) {
                    this.dog.getJumpControl().jump();
                    this.continueEvenWhenChanged = true;
                }
                ++this.tickAnim;
                break;
            }
        }
    }

    private void tickMoveTo() {
        if (this.dog.getNavigation().isDone() || this.almostOutOfRestrict() || this.checkMiningCautious()) {
            this.dog.getNavigation().stop();
            this.isDoingAnim = true;
            if (!this.dog.onGround()) {
                return;
            }
            this.findSniffPos();
            if (this.sniffAtPos != null) {
                this.startDoingAnim();
            }
        }
    }

    private boolean almostOutOfRestrict() {
        double restrict_d0_sqr;
        if (!this.dog.hasRestriction()) {
            return false;
        }
        BlockPos restrict_b0 = this.dog.getRestrictCenter();
        if (restrict_b0 == null) {
            return false;
        }
        float restrict_r = this.dog.getRestrictRadius();
        double d_inside_sqr = (double)(restrict_r * restrict_r) - (restrict_d0_sqr = this.dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)restrict_b0)));
        return d_inside_sqr <= 1.0;
    }

    private boolean checkMiningCautious() {
        return this.dog.avoidGoInFrontOfOwnerManager.isActive() && DogUtil.pathGoingInFrontOfOwner(this.dog);
    }

    private BlockPos findMoveToPos() {
        if (this.dog.hasRestriction() && this.dog.getRestrictCenter() != null) {
            BlockPos restrict_b0 = this.dog.getRestrictCenter();
            float restrict_r = this.dog.getRestrictRadius();
            int explore_r = Mth.floor((float)restrict_r) - 1;
            if (explore_r <= 0) {
                return this.dog.blockPosition();
            }
            RandomSource r = this.dog.getRandom();
            int offX = r.nextIntBetweenInclusive(-explore_r, explore_r);
            int offY = r.nextIntBetweenInclusive(-1, 1);
            int offZ = r.nextIntBetweenInclusive(-explore_r, explore_r);
            return restrict_b0.offset(offX, offY, offZ);
        }
        RandomSource r = this.dog.getRandom();
        int offX = r.nextIntBetweenInclusive(-6, 6);
        int offY = r.nextIntBetweenInclusive(-1, 1);
        int offZ = r.nextIntBetweenInclusive(-6, 6);
        return this.dog.blockPosition().offset(offX, offY, offZ);
    }

    private boolean findSniffPos() {
        BlockState sniffStateUnder;
        BlockState sniffState;
        int offset = this.dog.getRandom().nextBoolean() ? 1 : -1;
        boolean offsetX = this.dog.getRandom().nextBoolean();
        BlockPos currentPos = this.getSniffCurrentPos(this.dog);
        BlockPos sniffPos = offsetX ? currentPos.offset(offset, 0, 0) : currentPos.offset(0, 0, offset);
        if (!this.isBlockSniffable(sniffPos, sniffState = this.dog.level().getBlockState(sniffPos))) {
            return false;
        }
        BlockPos sniffPosUnder = this.getSniffPosUnder(this.dog, sniffPos.getX(), sniffPos.getZ());
        if (!this.isBlockBelowSniffable(sniffPosUnder, sniffStateUnder = this.dog.level().getBlockState(sniffPosUnder))) {
            return false;
        }
        this.populateSniffPos(currentPos, sniffPos, sniffState, sniffPosUnder, sniffStateUnder);
        return true;
    }

    private BlockPos getSniffCurrentPos(Dog dog) {
        return dog.blockPosition();
    }

    private BlockPos getSniffPosUnder(Dog dog, int sniffX, int sniffZ) {
        return BlockPos.containing((double)sniffX, (double)(dog.getY() - 0.1), (double)sniffZ);
    }

    private boolean isBlockSniffable(BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (this.stillRememberBeingBurned() && WalkNodeEvaluator.isBurningBlock((BlockState)state)) {
            return false;
        }
        return !state.isCollisionShapeFullBlock((BlockGetter)this.dog.level(), pos);
    }

    private boolean isBlockBelowSniffable(BlockPos posBelow, BlockState state) {
        return !this.stillRememberBeingBurned() || !WalkNodeEvaluator.isBurningBlock((BlockState)state);
    }

    private DogAnimation getSniffAnim() {
        boolean fireImmune = this.dog.fireImmune();
        boolean bl = this.shouldMoveSignificantly = !this.sniffUnderState.isCollisionShapeFullBlock((BlockGetter)this.dog.level(), this.sniffUnderPos);
        if (!fireImmune && WalkNodeEvaluator.isBurningBlock((BlockState)this.sniffUnderState) && this.sniffAtState.isAir()) {
            return DogAnimation.SNIFF_HOT;
        }
        Block atBlock = this.sniffAtState.getBlock();
        if (atBlock instanceof TorchBlock) {
            return DogAnimation.SNIFF_SNEEZE;
        }
        if (atBlock instanceof FlowerBlock) {
            if (this.dog.getRandom().nextBoolean()) {
                return DogAnimation.SNIFF_AWW_HAPPY;
            }
            return DogAnimation.SNIFF_SNEEZE;
        }
        if (!fireImmune && WalkNodeEvaluator.isBurningBlock((BlockState)this.sniffAtState)) {
            return DogAnimation.TOUCHY_TOUCH;
        }
        if (this.sniffAtState.isAir() && this.sniffUnderState.isAir()) {
            return DogAnimation.DOWN_THE_HOLE;
        }
        if (fireImmune && atBlock == Blocks.LAVA) {
            if (this.dog.getRandom().nextBoolean()) {
                return DogAnimation.SNIFF_SNEEZE;
            }
            return DogAnimation.SPLASH;
        }
        return DogAnimation.SNIFF_NEUTRAL;
    }

    private void validateSniff() {
        BlockState newUnderState;
        BlockState newAtState;
        boolean invalidated = false;
        if (this.sniffAtPos == null) {
            invalidated = true;
        }
        if (!invalidated) {
            double max_dist = 2.0;
            if (this.continueEvenWhenChanged) {
                max_dist = 6.0;
            }
            if (this.dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)this.sniffAtPos)) > max_dist * max_dist) {
                invalidated = true;
            }
        }
        if (!invalidated && !this.continueEvenWhenChanged && (newAtState = this.dog.level().getBlockState(this.sniffAtPos)).getBlock() != this.sniffAtState.getBlock()) {
            invalidated = true;
        }
        if (!invalidated && !this.continueEvenWhenChanged && (newUnderState = this.dog.level().getBlockState(this.sniffUnderPos)).getBlock() != this.sniffUnderState.getBlock()) {
            invalidated = true;
        }
        if (invalidated) {
            this.resetSniffPos();
            return;
        }
    }

    private void populateSniffPos(BlockPos current, BlockPos sniffPos, BlockState sniffState, BlockPos sniffUnderPos, BlockState sniffUnderState) {
        if (sniffUnderPos == null || sniffUnderState == null || sniffState == null || current == null) {
            sniffPos = null;
        }
        this.sniffAtState = sniffState;
        this.sniffUnderState = sniffUnderState;
        this.sniffAtPos = sniffPos;
        this.sniffUnderPos = sniffUnderPos;
        this.currentPos = current;
    }

    private void resetSniffPos() {
        this.sniffAtPos = null;
        this.sniffAtState = null;
        this.sniffUnderPos = null;
        this.sniffUnderState = null;
        this.currentPos = null;
    }

    private void rememberBeingBurned() {
        this.stillRememberBeingBurnedTick = this.dog.getRandom().nextInt(5) * 10 * 20;
    }

    private boolean stillRememberBeingBurned() {
        return this.stillRememberBeingBurnedTick > 0;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

