/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DogSoftHeelAction
extends TriggerableAction {
    private LivingEntity owner;
    private int timeToRecalcPath;
    private int timeOut;

    public DogSoftHeelAction(Dog dog, LivingEntity owner) {
        super(dog, false, false);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.timeOut = 200;
    }

    @Override
    public void tick() {
        if (!this.owner.isAlive() || this.owner.isSpectator()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        double d0 = this.dog.distanceToSqr((Entity)this.owner);
        if (d0 < 4.0 || --this.timeOut <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 256.0, false, false, 400.0, this.dog.getMaxFallDistance());
        }
    }

    @Override
    public void onStop() {
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }
}

