/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.Screens;
import doggytalents.common.entity.misc.DogFoodProjectile;
import doggytalents.common.entity.misc.DogGunpowderProjectile;
import doggytalents.common.inventory.TreatBagItemHandler;
import doggytalents.common.util.Cache;
import doggytalents.common.util.DogFoodUtil;
import doggytalents.common.util.ItemUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class TreatBagItem
extends Item
implements IDogFoodHandler {
    private Cache<String> contentsTranslationKey = Cache.make(() -> this.getDescriptionId() + ".contents");

    public TreatBagItem(Item.Properties properties) {
        super(properties.component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (worldIn.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!playerIn.isShiftKeyDown()) {
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)playerIn;
                this.findFoodAndShootOut(sP, stack);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            Screens.openTreatBagScreen(serverPlayer, stack, playerIn.getInventory().selected);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void findFoodAndShootOut(ServerPlayer player, ItemStack stack) {
        TreatBagItemHandler itemHandler = new TreatBagItemHandler(stack);
        int foodStackId = this.findThrowableInItemHandler((IItemHandler)itemHandler);
        if (foodStackId < 0) {
            return;
        }
        ItemStack foodStack = itemHandler.getStackInSlot(foodStackId);
        if (foodStack.isEmpty()) {
            return;
        }
        if (foodStack.is(Items.GUNPOWDER)) {
            this.throwGunpowder((Player)player);
        } else {
            this.throwFood((Player)player, foodStack.getItem());
        }
        foodStack = foodStack.copy();
        foodStack.shrink(1);
        itemHandler.setStackInSlot(foodStackId, foodStack);
        player.getCooldowns().addCooldown((Item)this, 20);
    }

    private void throwFood(Player player, Item item) {
        DogFoodProjectile dogFoodProj = new DogFoodProjectile(player.level(), (LivingEntity)player);
        dogFoodProj.setDogFoodStack(new ItemStack((ItemLike)item));
        dogFoodProj.setOwner((Entity)player);
        dogFoodProj.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.8f, 1.0f);
        player.level().addFreshEntity((Entity)dogFoodProj);
    }

    private void throwGunpowder(Player player) {
        DogGunpowderProjectile dogGunpowderProj = new DogGunpowderProjectile(player.level(), (LivingEntity)player);
        dogGunpowderProj.setOwner((Entity)player);
        dogGunpowderProj.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.8f, 1.0f);
        player.level().addFreshEntity((Entity)dogGunpowderProj);
    }

    private int findThrowableInItemHandler(IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            if (FoodHandler.isFood(stack).isPresent()) {
                return i;
            }
            if (!stack.is(Items.GUNPOWDER)) continue;
            return i;
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.doggytalents.treat_bag.help").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true))));
        this.displayContents(stack, tooltip, flagIn);
    }

    private void displayContents(ItemStack stack, List<Component> tooltip, TooltipFlag flagIn) {
        TreatBagItemHandler inv = new TreatBagItemHandler(stack);
        ItemUtil.ContentOverview contentsOverview = ItemUtil.getContentOverview((IItemHandler)inv);
        Map<Item, Integer> contentsMap = contentsOverview.contents();
        if (contentsMap.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)"item.doggytalents.treat_bag.contents"));
        for (Map.Entry<Item, Integer> entry : contentsMap.entrySet()) {
            MutableComponent c1 = Component.translatable((String)"item.doggytalents.starter_bundle.contains", (Object[])new Object[]{entry.getValue(), entry.getKey().getDescription()}).withStyle(Style.EMPTY.withColor(-6052957));
            tooltip.add((Component)c1);
        }
        if (contentsOverview.isMore() > 0) {
            tooltip.add((Component)Component.translatable((String)"item.doggytalents.treat_bag.contents.more", (Object[])new Object[]{contentsOverview.isMore()}).withStyle(Style.EMPTY.withColor(-6052957)));
        }
    }

    public static List<ItemStack> inventory(ItemStack stack) {
        if (!stack.is(DoggyItems.TREAT_BAG.get())) {
            return List.of();
        }
        ItemContainerContents itemList = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        if (itemList == ItemContainerContents.EMPTY) {
            return List.of();
        }
        return itemList.stream().collect(Collectors.toList());
    }

    public static void flushInveotory(ItemStack stack, NonNullList<ItemStack> inv) {
        if (!stack.is(DoggyItems.TREAT_BAG.get())) {
            return;
        }
        stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(inv));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Override
    public boolean isFood(ItemStack stackIn) {
        return false;
    }

    @Override
    public boolean canConsume(AbstractDog dogIn, ItemStack stackIn, Entity entityIn) {
        if (dogIn.isDefeated()) {
            return false;
        }
        return entityIn instanceof LivingEntity ? dogIn.canInteract((LivingEntity)entityIn) : false;
    }

    @Override
    public InteractionResult consume(AbstractDog dogIn, ItemStack stackIn, Entity entityIn) {
        if (dogIn.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        TreatBagItemHandler treatBag = new TreatBagItemHandler(stackIn);
        return DogFoodUtil.tryFeedAny(dogIn, entityIn, (IItemHandlerModifiable)treatBag);
    }
}

