/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.AllStandSwitchModeData;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;

public class AllStandSwitchModePacket
implements IPacket<AllStandSwitchModeData> {
    @Override
    public void encode(AllStandSwitchModeData data, FriendlyByteBuf buf) {
        buf.writeInt(data.mode.getIndex());
    }

    @Override
    public AllStandSwitchModeData decode(FriendlyByteBuf buf) {
        int mode_id = buf.readInt();
        DogMode mode = DogMode.byIndex(mode_id);
        return new AllStandSwitchModeData(mode);
    }

    @Override
    public void handle(AllStandSwitchModeData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                return;
            }
            ServerPlayer sender = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
            if (sender.getCooldowns().isOnCooldown((Item)DoggyItems.WHISTLE.get())) {
                return;
            }
            DogMode target_mode = data.mode;
            if (target_mode.canWander()) {
                return;
            }
            Predicate<Dog> switch_mode_target = filter_dog -> filter_dog.isDoingFine() && !filter_dog.isOrderedToSit() && filter_dog.isOwnedBy((LivingEntity)sender) && filter_dog.getMode() != target_mode && !filter_dog.getMode().canWander();
            List dogs = sender.level().getEntitiesOfClass(Dog.class, sender.getBoundingBox().inflate(100.0, 50.0, 100.0), switch_mode_target);
            for (Dog dog : dogs) {
                dog.setMode(target_mode);
            }
            sender.level().playSound(null, sender.blockPosition(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + sender.level().random.nextFloat() * 0.1f, 0.4f + sender.level().random.nextFloat() * 0.2f);
            sender.sendSystemMessage((Component)Component.translatable((String)"dogcommand.all_stand_switch_mode", (Object[])new Object[]{Component.translatable((String)data.mode.getUnlocalisedName()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)))}));
            sender.getCooldowns().addCooldown((Item)DoggyItems.WHISTLE.get(), 40);
        });
        ctx.get().setPacketHandled(true);
    }
}

