/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.stats.StatsTracker;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.StatsSyncData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class StatsSyncPackets {

    public static class Response
    implements IPacket<StatsSyncData.Response> {
        @Override
        public void encode(StatsSyncData.Response data, FriendlyByteBuf buf) {
            buf.writeInt(data.entityId);
            data.tracker.serializeToBuf(buf);
        }

        @Override
        public StatsSyncData.Response decode(FriendlyByteBuf buf) {
            int id = buf.readInt();
            StatsTracker newTracker = new StatsTracker();
            newTracker.deserializeFromBuf(buf);
            return new StatsSyncData.Response(id, newTracker);
        }

        @Override
        public void handle(StatsSyncData.Response data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    Minecraft mc = Minecraft.getInstance();
                    Entity e = mc.level.getEntity(data.entityId);
                    if (e instanceof Dog) {
                        Dog d = (Dog)e;
                        d.getStatTracker().shallowCopyFrom(data.tracker);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class Request
    extends DogPacket<StatsSyncData.Request> {
        @Override
        public StatsSyncData.Request decode(FriendlyByteBuf buf) {
            int id = buf.readInt();
            return new StatsSyncData.Request(id);
        }

        @Override
        public void handleDog(Dog dogIn, StatsSyncData.Request data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
            StatsTracker tracker = dogIn.getStatTracker();
            ServerPlayer sender = ctx.get().getSender();
            if (!dogIn.canInteract((LivingEntity)sender)) {
                return;
            }
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new StatsSyncData.Response(dogIn.getId(), tracker));
        }
    }
}

