/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.enu.WetSource;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.talent.HellHoundTalent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class FisherDogTalent
extends TalentInstance {
    private int cookCooldown = 10;
    private boolean renderHat = true;

    public FisherDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.level().isClientSide) {
            return;
        }
        if (this.cookCooldown > 0) {
            --this.cookCooldown;
        }
    }

    @Override
    public void onShakingDry(AbstractDog dogIn, WetSource source) {
        if (dogIn.level().isClientSide) {
            return;
        }
        if (!source.isWaterBlock()) {
            return;
        }
        int r_fish = dogIn.getRandom().nextInt(15);
        if (r_fish >= this.level() * 2) {
            return;
        }
        ItemStack fishItem = this.getRandomFishingLoot(dogIn);
        ItemStack fishStack = this.getFishedStack(dogIn, fishItem);
        dogIn.spawnAtLocation(fishStack);
    }

    private ItemStack getRandomFishingLoot(AbstractDog dog) {
        Level level = dog.level();
        if (!(level instanceof ServerLevel)) {
            return ItemStack.EMPTY;
        }
        ServerLevel sLevel = (ServerLevel)level;
        ResourceKey loot_table = BuiltInLootTables.FISHING_FISH;
        RandomSource r = dog.getRandom();
        if (this.level() >= 5 && (double)r.nextFloat() < 0.0125) {
            loot_table = BuiltInLootTables.FISHING_TREASURE;
        }
        LootParams loot_param = new LootParams.Builder(sLevel).create(LootContextParamSets.EMPTY);
        ObjectArrayList loot_list = sLevel.getServer().reloadableRegistries().getLootTable(loot_table).getRandomItems(loot_param);
        if (loot_list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = (ItemStack)loot_list.get(r.nextInt(loot_list.size()));
        return ret.copy();
    }

    private ItemStack getFishedStack(AbstractDog dog, ItemStack raw_stack) {
        raw_stack = this.mayCookFish(dog, raw_stack);
        return raw_stack;
    }

    private ItemStack mayCookFish(AbstractDog dog, ItemStack fish_raw) {
        float r;
        if (this.cookCooldown > 0) {
            return fish_raw;
        }
        Optional hellhound_optional = dog.getTalent(DoggyTalents.HELL_HOUND);
        if (!hellhound_optional.isPresent()) {
            return fish_raw;
        }
        Object t = hellhound_optional.get();
        if (!(t instanceof HellHoundTalent)) {
            return fish_raw;
        }
        HellHoundTalent hellhound = (HellHoundTalent)t;
        if (!hellhound.canGenerateHeat()) {
            return fish_raw;
        }
        if (hellhound.level() < hellhound.getTalent().getMaxLevel() && (r = dog.getRandom().nextFloat()) > 0.75f) {
            return fish_raw;
        }
        this.cookCooldown = 10;
        return this.tryCookFish(dog, fish_raw);
    }

    private ItemStack tryCookFish(AbstractDog dog, ItemStack fish_raw) {
        RecipeManager recipeMan = dog.level().getRecipeManager();
        Optional recipeOptional = recipeMan.getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(fish_raw.copy()), dog.level());
        if (!recipeOptional.isPresent()) {
            return fish_raw;
        }
        RecipeHolder recipe = (RecipeHolder)recipeOptional.get();
        ItemStack resultStack = ((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)dog.level().registryAccess());
        if (resultStack == null || resultStack.isEmpty()) {
            return fish_raw;
        }
        return resultStack.copy();
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.renderHat = compound.getBoolean("renderHat");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.putBoolean("renderHat", this.renderHat);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.FISHER_DOG_RENDER.get()) {
            return this.renderHat;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.FISHER_DOG_RENDER.get()) {
            this.renderHat = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.FISHER_DOG_RENDER.get());
    }

    public boolean canRenderHat() {
        return this.level() >= this.getTalent().getMaxLevel();
    }

    public boolean renderHat() {
        return this.renderHat;
    }

    public void setRenderHat(boolean hat) {
        this.renderHat = hat;
    }
}

