/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RoaringGaleTalent
extends TalentInstance {
    private int cooldown = 0;

    public RoaringGaleTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        super.init(dogIn);
        this.cooldown = dogIn.tickCount;
    }

    public static int getAffectDuration(int level) {
        if (level >= 5) {
            return 70;
        }
        if (level <= 0) {
            return 0;
        }
        switch (level) {
            case 1: {
                return 20;
            }
            case 2: {
                return 24;
            }
            case 3: {
                return 36;
            }
            case 4: {
                return 48;
            }
        }
        return 20;
    }

    public static int getKnockback(int level) {
        return level;
    }

    public static int getDamage(int level) {
        return level > 4 ? level * 2 : level;
    }

    public static Optional<Integer> roar(List<Dog> dogsList, Level world, Player player) {
        if (world.isClientSide) {
            return Optional.empty();
        }
        List roarDogs = dogsList.stream().filter(dog -> dog.getDogLevel(DoggyTalents.ROARING_GALE) > 0).collect(Collectors.toList());
        if (roarDogs.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"talent.doggytalents.roaring_gale.level"), true);
            return Optional.empty();
        }
        if ((roarDogs = roarDogs.stream().filter(RoaringGaleTalent::isNotOnRoarCooldown).collect(Collectors.toList())).isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"talent.doggytalents.roaring_gale.cooldown"), true);
            return Optional.empty();
        }
        boolean anyHits = false;
        int whistle_cooldown = 0;
        for (Dog dog2 : roarDogs) {
            int level = dog2.getDogLevel(DoggyTalents.ROARING_GALE);
            int damage = RoaringGaleTalent.getDamage(level);
            int effectDuration = RoaringGaleTalent.getAffectDuration(level);
            int knockback = RoaringGaleTalent.getKnockback(level);
            boolean hit = false;
            List targets = dog2.level().getEntitiesOfClass(LivingEntity.class, dog2.getBoundingBox().inflate((double)(level * 4), 4.0, (double)(level * 4)));
            for (LivingEntity mob : targets) {
                if (!(mob instanceof Enemy)) continue;
                hit = true;
                mob.hurt(mob.damageSources().generic(), (float)damage);
                mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, effectDuration, 127, false, false));
                mob.addEffect(new MobEffectInstance(MobEffects.GLOWING, effectDuration, 1, false, false));
                mob.push((double)(Mth.sin((float)(mob.getYRot() * ((float)Math.PI / 180))) * (float)knockback * 0.5f), 0.1, (double)(-Mth.cos((float)(mob.getYRot() * ((float)Math.PI / 180))) * (float)knockback * 0.5f));
            }
            int cooldown = 0;
            if (hit) {
                dog2.playSound(SoundEvents.WOLF_GROWL, 0.7f, 1.0f);
                cooldown = level >= 5 ? 60 : 100;
                anyHits = true;
            } else {
                dog2.playSound(SoundEvents.WOLF_AMBIENT, 1.0f, 1.2f);
                cooldown = level >= 5 ? 30 : 50;
            }
            RoaringGaleTalent.setRoarCooldownFor(dog2, dog2.tickCount + cooldown);
            if (cooldown <= whistle_cooldown) continue;
            whistle_cooldown = cooldown;
        }
        if (!anyHits) {
            player.displayClientMessage((Component)Component.translatable((String)"talent.doggytalents.roaring_gale.miss"), true);
        }
        if (whistle_cooldown <= 0) {
            return Optional.empty();
        }
        return Optional.of(whistle_cooldown);
    }

    private static boolean isNotOnRoarCooldown(Dog dog) {
        Optional<TalentInstance> inst_optional = dog.getTalent(DoggyTalents.ROARING_GALE.get());
        if (!inst_optional.isPresent()) {
            return false;
        }
        TalentInstance inst = inst_optional.get();
        if (!(inst instanceof RoaringGaleTalent)) {
            return false;
        }
        RoaringGaleTalent roar = (RoaringGaleTalent)inst;
        int cooldownDeadline = roar.cooldown;
        return cooldownDeadline <= dog.tickCount;
    }

    private static void setRoarCooldownFor(Dog dog, int val) {
        Optional<TalentInstance> inst_optional = dog.getTalent(DoggyTalents.ROARING_GALE.get());
        if (!inst_optional.isPresent()) {
            return;
        }
        TalentInstance inst = inst_optional.get();
        if (!(inst instanceof RoaringGaleTalent)) {
            return;
        }
        RoaringGaleTalent roar = (RoaringGaleTalent)inst;
        roar.cooldown = val;
    }
}

