/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools.tool_actions;

import doggytalents.DoggyBlocks;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.DoggyToolsItemHandler;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.doggy_tools.tool_actions.ToolAction;
import doggytalents.common.util.RingSearchIterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class DogFarmerAction
extends ToolAction {
    private static final int SEARCH_RADIUS = 4;
    private BlockPos nextFarmBlock;
    private int tickTillPathRecalc;
    private int tickTillResearch;
    private int checkAgainTimestamp;
    private ItemStack seedTarget = ItemStack.EMPTY;
    private ItemStack replacementStack = ItemStack.EMPTY;

    public DogFarmerAction(Dog dog, DoggyToolsTalent talent) {
        super(dog, talent);
    }

    @Override
    public void onStart() {
        this.tickTillPathRecalc = 3;
        this.tickTillResearch = 20;
    }

    @Override
    public void tick() {
        ItemStack hurtStack;
        FarmState farmState;
        ItemStack stack;
        boolean owner_check;
        boolean bl = owner_check = (Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_WANDER_FARM.get() == false || this.dog.getMode().shouldFollowOwner();
        if (owner_check) {
            LivingEntity owner = this.dog.getOwner();
            if (owner == null || this.dog.distanceToSqr((Entity)owner) > (double)this.talent.getMaxOwnerDistSqr()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!owner.isAlive() || owner.isSpectator()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }
        if ((stack = this.dog.getItemInHand(InteractionHand.MAIN_HAND)) == null || !(stack.getItem() instanceof HoeItem)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.tickTillPathRecalc > 0) {
            --this.tickTillPathRecalc;
        }
        this.refreshTargetSeed();
        if (this.nextFarmBlock == null && --this.tickTillResearch <= 0) {
            this.tickTillResearch = 10;
            this.nextFarmBlock = this.findNextFarmBlock();
            if (this.nextFarmBlock == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }
        if ((farmState = this.getFarmState(this.nextFarmBlock)) == FarmState.NONE) {
            this.nextFarmBlock = null;
            return;
        }
        boolean hurtTools = this.moveToAndFarmBlock(farmState);
        if (hurtTools && this.dog.getRandom().nextInt(3) == 0 && (hurtStack = this.dog.getMainHandItem()) != null && hurtStack.getItem() instanceof HoeItem) {
            hurtStack.hurtAndBreak(1, (LivingEntity)this.dog, EquipmentSlot.MAINHAND);
        }
    }

    private void refreshTargetSeed() {
        boolean isDogHarvestable;
        ItemStack stack;
        this.seedTarget = ItemStack.EMPTY;
        this.replacementStack = ItemStack.EMPTY;
        DoggyToolsItemHandler inv = this.talent.getTools();
        int harvest_slot_id = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            stack = inv.getStackInSlot(i);
            isDogHarvestable = this.getCropBlockFromItem(stack).isPresent();
            if (!isDogHarvestable) continue;
            this.seedTarget = stack.copy();
            harvest_slot_id = i;
            break;
        }
        if (this.seedTarget.isEmpty()) {
            return;
        }
        int replace_slot_id = harvest_slot_id + 1;
        if (replace_slot_id < inv.getSlots() && (isDogHarvestable = this.getCropBlockFromItem(stack = inv.getStackInSlot(replace_slot_id)).isPresent()) && !stack.is(this.seedTarget.getItem())) {
            this.replacementStack = stack.copy();
        }
    }

    private boolean moveToAndFarmBlock(FarmState farmState) {
        BlockPos dog_b0 = this.dog.blockPosition();
        PathNavigation dog_nav = this.dog.getNavigation();
        boolean shouldHurtTool = false;
        this.dog.getLookControl().setLookAt(Vec3.atBottomCenterOf((Vec3i)this.nextFarmBlock));
        if (dog_nav.isDone() && dog_b0.distSqr((Vec3i)this.nextFarmBlock) <= 4.0) {
            this.dog.getMoveControl().setWantedPosition((double)this.nextFarmBlock.getX(), (double)this.nextFarmBlock.getY(), (double)this.nextFarmBlock.getZ(), 1.0);
        }
        if (dog_b0.distSqr((Vec3i)this.nextFarmBlock) < 4.0) {
            switch (farmState.ordinal()) {
                case 2: {
                    this.harvest();
                    shouldHurtTool = true;
                    break;
                }
                case 1: {
                    this.placeSeed();
                    shouldHurtTool = true;
                    break;
                }
            }
            this.nextFarmBlock = null;
            return shouldHurtTool;
        }
        if (this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 20;
            dog_nav.moveTo((double)this.nextFarmBlock.getX(), (double)this.nextFarmBlock.getY(), (double)this.nextFarmBlock.getZ(), 1.0);
        }
        return shouldHurtTool;
    }

    @Override
    public void onStop() {
        this.setState(TriggerableAction.ActionState.PENDING);
        this.nextFarmBlock = null;
        this.dog.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
    }

    @Override
    public boolean shouldUse(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (!(stack.getItem() instanceof HoeItem)) {
            return false;
        }
        if (this.dog.tickCount < this.checkAgainTimestamp) {
            return false;
        }
        this.checkAgainTimestamp = this.dog.tickCount + 30;
        this.refreshTargetSeed();
        this.nextFarmBlock = this.findNextFarmBlock();
        return this.nextFarmBlock != null;
    }

    private BlockPos findNextFarmBlock() {
        BlockPos bp = this.dog.blockPosition();
        if (this.seedTarget == null || this.seedTarget.isEmpty()) {
            return null;
        }
        boolean owner_check = (Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_WANDER_FARM.get() == false || this.dog.getMode().shouldFollowOwner();
        LivingEntity owner = null;
        if (owner_check && (owner = this.dog.getOwner()) == null) {
            return null;
        }
        for (BlockPos pos : RingSearchIterator.createWithRandom(bp, 4, 4, true, this.dog.getRandom())) {
            if (owner != null && owner.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)pos)) + 1.0 >= (double)this.talent.getMaxOwnerDistSqr() || this.getFarmState(pos) == FarmState.NONE) continue;
            return pos;
        }
        return null;
    }

    private void placeSeed() {
        BlockState wheatState = this.getCropBlockFromItem(this.replacementStack.isEmpty() ? this.seedTarget : this.replacementStack).orElse(DoggyBlocks.RICE_CROP.get()).defaultBlockState();
        this.dog.level().setBlockAndUpdate(this.nextFarmBlock.above(), wheatState);
        SoundType soundtype = wheatState.getSoundType((LevelReader)this.dog.level(), this.nextFarmBlock.above(), (Entity)this.dog);
        this.dog.playSound(soundtype.getPlaceSound(), (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
    }

    private void harvest() {
        this.dog.level().destroyBlock(this.nextFarmBlock.above(), true);
    }

    private FarmState getFarmState(BlockPos pos) {
        if (pos == null) {
            return FarmState.NONE;
        }
        if (this.seedTarget == null || this.seedTarget.isEmpty()) {
            return FarmState.NONE;
        }
        BlockState state = this.dog.level().getBlockState(pos);
        if (state.getBlock() != Blocks.FARMLAND) {
            return FarmState.NONE;
        }
        BlockState state_above = this.dog.level().getBlockState(pos.above());
        if (state_above.getBlock() == Blocks.AIR) {
            return FarmState.PLACE_SEED;
        }
        Optional<CropBlock> crop_block_optional = this.getCropBlockFromItem(this.seedTarget);
        if (!crop_block_optional.isPresent()) {
            return FarmState.NONE;
        }
        CropBlock crop_block = crop_block_optional.get();
        if (state_above.getBlock() == crop_block && crop_block.isMaxAge(state_above)) {
            return FarmState.HARVEST;
        }
        return FarmState.NONE;
    }

    private Optional<CropBlock> getCropBlockFromItem(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem block_item = (BlockItem)item;
        Block block = block_item.getBlock();
        if (!(block instanceof CropBlock)) {
            return Optional.empty();
        }
        CropBlock crop_block = (CropBlock)block;
        return Optional.of(crop_block);
    }

    private static enum FarmState {
        NONE,
        PLACE_SEED,
        HARVEST;

    }
}

