/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.common.util.ReflectionUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugUtil {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/debug");

    public static List<Pair<ChunkPos, Ticket<?>>> getAllTicketsOfType(ServerLevel level, TicketType<?> type) {
        ServerChunkCache chunk_source = level.getChunkSource();
        DistanceManager distance_manager = ReflectionUtil.getPrivateField(ServerChunkCache.class, chunk_source, "distanceManager", DistanceManager.class).get();
        Long2ObjectOpenHashMap tickets = ReflectionUtil.getPrivateField(DistanceManager.class, distance_manager, "tickets", Long2ObjectOpenHashMap.class).get();
        ArrayList tickets_selected = new ArrayList();
        Long2ObjectMap.FastEntrySet entry_set = tickets.long2ObjectEntrySet();
        for (Long2ObjectMap.Entry entry : entry_set) {
            ChunkPos chunk = new ChunkPos(entry.getLongKey());
            ((Set)entry.getValue()).stream().filter(filter_ticket -> filter_ticket.getType() == type).forEach(x -> tickets_selected.add(Pair.of((Object)chunk, (Object)x)));
        }
        return tickets_selected;
    }

    public static String dumpPath(Path path) {
        StringBuilder builder = new StringBuilder("\n");
        for (int i = 0; i < path.getNodeCount(); ++i) {
            Node node = path.getNode(i);
            builder.append(String.format("%s %s %s %s\n", Integer.toString(node.x), Integer.toString(node.y), Integer.toString(node.z), node.type));
        }
        return builder.toString();
    }
}

