/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.feature;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IDogFoodPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1799;

public class FoodHandler {
    private static final List<IDogFoodHandler> commonHandlers = new ArrayList<IDogFoodHandler>(4);

    public static synchronized void registerHandler(IDogFoodHandler handler) {
        commonHandlers.add(handler);
    }

    public static Optional<IDogFoodPredicate> isFood(class_1799 stackIn) {
        return FoodHandler.isFood(stackIn, null);
    }

    public static Optional<IDogFoodPredicate> isFood(class_1799 stackIn, @Nullable AbstractDog dog) {
        if (dog != null) {
            for (IDogFoodHandler handler : dog.getFoodHandlers()) {
                if (!handler.isFood(stackIn)) continue;
                return Optional.of(handler);
            }
        }
        if (stackIn.method_7909() instanceof IDogFoodHandler && ((IDogFoodHandler)stackIn.method_7909()).isFood(stackIn)) {
            return Optional.of((IDogFoodHandler)stackIn.method_7909());
        }
        for (IDogFoodHandler handler : commonHandlers) {
            if (!handler.isFood(stackIn)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }

    public static Optional<IDogFoodHandler> getMatch(@Nullable AbstractDog dogIn, class_1799 stackIn, @Nullable class_1297 entityIn) {
        if (dogIn == null) {
            return Optional.empty();
        }
        for (IDogFoodHandler handler : dogIn.getFoodHandlers()) {
            if (!handler.canConsume(dogIn, stackIn, entityIn)) continue;
            return Optional.of(handler);
        }
        if (stackIn.method_7909() instanceof IDogFoodHandler && ((IDogFoodHandler)stackIn.method_7909()).canConsume(dogIn, stackIn, entityIn)) {
            return Optional.of((IDogFoodHandler)stackIn.method_7909());
        }
        for (IDogFoodHandler handler : commonHandlers) {
            if (!handler.canConsume(dogIn, stackIn, entityIn)) continue;
            return Optional.of(handler);
        }
        return Optional.empty();
    }
}

