/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import doggytalents.DoggyBlocks;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.backward_imitate.AtlasUtil_1_21_9;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.fabric_helper.block.dogbed.DogBedModelData;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10419;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_10801;
import net.minecraft.class_10802;
import net.minecraft.class_10813;
import net.minecraft.class_10819;
import net.minecraft.class_10820;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1100;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_9826;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class DogBedModel
implements class_1087 {
    private static final class_2960 MISSING_TEXTURE = Util.getVanillaResource("missingno");
    private final class_7775 modelLoader;
    private final class_793 unbakedModel;
    private final class_1087 defaultModelVariant;
    private final Map<class_2350, class_10801> defaultModelVariants = new ConcurrentHashMap<class_2350, class_10801>(class_2350.values().length);
    private final Map<class_2350, class_10801> missingModelVariant = new ConcurrentHashMap<class_2350, class_10801>(class_2350.values().length);
    private static final Map<Triple<ICasingMaterial, IBeddingMaterial, class_2350>, class_10801> cache = Maps.newConcurrentMap();
    private final int maxCacheSize;

    public DogBedModel(class_7775 modelLoader, class_793 model, class_1087 defaultModelVariant, int maxCacheSize) {
        this.modelLoader = modelLoader;
        this.unbakedModel = model;
        this.defaultModelVariant = defaultModelVariant;
        this.maxCacheSize = maxCacheSize;
    }

    public static void clearCache() {
        cache.clear();
    }

    public class_10801 getModelVariant(@Nonnull DogBedModelData data) {
        return this.getModelVariant(data.casing(), data.bedding(), data.direction());
    }

    public class_10801 getModelVariant(ICasingMaterial casing, IBeddingMaterial bedding, class_2350 facing) {
        if (facing == null) {
            facing = class_2350.field_11043;
        }
        if (casing == null || bedding == null) {
            return this.getDefaultVariant(facing);
        }
        if (casing.isNani() || bedding.isNani()) {
            return this.getMissingVariant(facing);
        }
        ImmutableTriple key = ImmutableTriple.of((Object)casing, (Object)bedding, (Object)facing);
        class_10801 model_variant = cache.get(key);
        if (model_variant != null) {
            return model_variant;
        }
        if (cache.size() >= this.maxCacheSize) {
            return this.getDefaultVariant(facing);
        }
        model_variant = this.bakeModelVariant(casing, bedding, facing);
        cache.put((Triple<ICasingMaterial, IBeddingMaterial, class_2350>)key, model_variant);
        return model_variant;
    }

    private class_10801 getMissingVariant(class_2350 dir) {
        class_10801 missing = this.missingModelVariant.get(dir);
        if (missing != null) {
            return missing;
        }
        missing = this.bakeModelVariant(DogBedMaterialManager.NaniCasing.NULL, DogBedMaterialManager.NaniBedding.NULL, dir);
        this.missingModelVariant.put(dir, missing);
        return missing;
    }

    private class_10801 getDefaultVariant(class_2350 dir) {
        class_10801 default_variant = this.defaultModelVariants.get(dir);
        if (default_variant != null) {
            return default_variant;
        }
        default_variant = DogBedModel.bakeModel(this.unbakedModel, dir);
        this.defaultModelVariants.put(dir, default_variant);
        return default_variant;
    }

    public class_10801 bakeModelVariant(@Nullable ICasingMaterial casing, @Nullable IBeddingMaterial bedding, @Nonnull class_2350 facing) {
        class_793 new_model = this.prepareVariantBlockModelForBaking_1_21_5(this.unbakedModel, casing, bedding);
        class_10801 ret = DogBedModel.bakeModel(new_model, facing);
        return ret;
    }

    private static class_10801 bakeModel(class_793 to_bake, class_2350 dir) {
        return DogBedModel.bakeModel_1_21_5(to_bake, dir);
    }

    private static class_1086 getModelRotation(@Nonnull class_2350 dir) {
        switch (dir) {
            default: {
                return class_1086.field_5350;
            }
            case field_11034: {
                return class_1086.field_5366;
            }
            case field_11035: {
                return class_1086.field_5355;
            }
            case field_11039: 
        }
        return class_1086.field_5347;
    }

    private static Either<class_4730, String> findCasingTexture(@Nullable ICasingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<class_4730, String> findBeddingTexture(@Nullable IBeddingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<class_4730, String> findTexture(class_2960 resource) {
        if (resource == null) {
            resource = MISSING_TEXTURE;
        }
        return Either.left((Object)new class_4730(class_1059.field_5275, resource));
    }

    public class_1058 method_68511() {
        return this.defaultModelVariant.method_68511();
    }

    public void method_68513(class_5819 random, List<class_10889> parts) {
        class_10801 part = this.getModelVariant(null, null, class_2350.field_11043);
        if (part != null) {
            parts.add((class_10889)part);
        }
    }

    private static List<class_785> getElements_1_21_5(class_793 model) {
        class_10820 class_108202 = model.comp_3739();
        if (!(class_108202 instanceof class_10802)) {
            return List.of();
        }
        class_10802 element_getter = (class_10802)class_108202;
        return element_getter.comp_3753();
    }

    private class_793 prepareVariantBlockModelForBaking_1_21_5(class_793 model, @Nullable ICasingMaterial casing, @Nullable IBeddingMaterial bedding) {
        List<class_785> elements_old = DogBedModel.getElements_1_21_5(model);
        ArrayList<class_785> elements_new = new ArrayList<class_785>(elements_old.size());
        for (class_785 element : elements_old) {
            class_785 element_copy = new class_785(element.comp_3727(), element.comp_3728(), (Map)Maps.newHashMap((Map)element.comp_3729()), element.comp_3730(), element.comp_3731(), element.comp_3732());
            elements_new.add(element_copy);
        }
        Either<class_4730, String> casing_texture = DogBedModel.findCasingTexture(casing);
        Either<class_4730, String> bedding_texture = DogBedModel.findBeddingTexture(bedding);
        class_10419.class_10420.class_10421 builder = new class_10419.class_10420.class_10421();
        DogBedModel.addMaterialToBuilder_1_21_5(builder, "bedding", bedding_texture);
        DogBedModel.addMaterialToBuilder_1_21_5(builder, "casing", casing_texture);
        DogBedModel.addMaterialToBuilder_1_21_5(builder, "particle", casing_texture);
        class_10419.class_10420 texture_map = builder.method_65547();
        class_793 ret = new class_793((class_10820)new class_10802(elements_new), model.comp_3740(), model.comp_3741(), model.comp_3742(), texture_map, model.comp_3744());
        return ret;
    }

    private static void addMaterialToBuilder_1_21_5(class_10419.class_10420.class_10421 builder, String name, Either<class_4730, String> material) {
        if (material.left().isPresent()) {
            builder.method_65548(name, (class_4730)material.left().get());
            return;
        }
        if (material.right().isPresent()) {
            builder.method_65549(name, (String)material.right().get());
            return;
        }
    }

    private static class_10801 bakeModel_1_21_5(class_793 model, class_2350 dir) {
        class_10819 resolved_model = DogBedModel.resolvedModel_1_21_5((class_1100)model);
        class_7775 baker = DogBedModel.modelBaker_1_21_5(resolved_model);
        return class_10801.method_67931((class_7775)baker, (class_2960)DoggyBlocks.DOG_BED.getId(), (class_3665)DogBedModel.getModelRotation(dir));
    }

    public static class_10819 resolvedModel_1_21_5(final class_1100 model) {
        return new class_10819(){

            public String debugName() {
                return "DTN Dog Bed Variant Model";
            }

            public class_1100 method_68031() {
                return model;
            }

            @Nullable
            public class_10819 method_68038() {
                return null;
            }
        };
    }

    public static class_7775 modelBaker_1_21_5(final class_10819 resolved_model) {
        return new class_7775(){

            public class_10819 method_45872(class_2960 p_405736_) {
                return resolved_model;
            }

            public class_9826 method_65732() {
                return new class_9826(this){

                    public class_1058 method_65739(class_4730 material, class_10813 p_404904_) {
                        return AtlasUtil_1_21_9.getSpriteFromMaterial(material);
                    }

                    public class_1058 method_65740(String p_387031_, class_10813 p_405621_) {
                        return AtlasUtil_1_21_9.getSpriteFromMaterial(new class_4730(class_1059.field_5275, class_1047.method_4539()));
                    }
                };
            }

            public <T> T method_68549(class_7775.class_10897<T> p_410340_) {
                return (T)p_410340_.compute((class_7775)this);
            }
        };
    }

    public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<class_2350> cullTest) {
        class_1920 dataGetter = blockView;
        Object data = dataGetter.getBlockEntityRenderData(pos);
        class_10801 bakedModel = null;
        if (data instanceof DogBedModelData) {
            DogBedModelData dogBedData = (DogBedModelData)data;
            bakedModel = this.getModelVariant(dogBedData);
        } else {
            bakedModel = this.getModelVariant(DogBedModelData.EMPTY);
        }
        bakedModel.emitQuads(emitter, cullTest);
    }
}

