/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import doggytalents.client.backward_imitate.BaseDogModel_21_3;
import doggytalents.client.backward_imitate.ModelUtil_1_21_9;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.joml.Vector3f;

public abstract class SyncedAccessoryModel
extends BaseDogModel_21_3 {
    public final class_630 root;
    private Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;
    public Optional<class_630> head = Optional.empty();
    public Optional<class_630> realHead = Optional.empty();
    public Optional<class_630> body = Optional.empty();
    public Optional<class_630> mane = Optional.empty();
    public Optional<class_630> legBackRight = Optional.empty();
    public Optional<class_630> legBackLeft = Optional.empty();
    public Optional<class_630> legFrontRight = Optional.empty();
    public Optional<class_630> legFrontLeft = Optional.empty();
    public Optional<class_630> tail = Optional.empty();
    public Optional<class_630> realTail = Optional.empty();

    public SyncedAccessoryModel(class_630 root) {
        this.root = root;
        this.populatePart(root);
    }

    protected abstract void populatePart(class_630 var1);

    public void sync(DogModel dogModel) {
        this.syncPart(this.root, dogModel.root);
        this.syncPart(this.head, dogModel.head);
        this.syncPart(this.realHead, dogModel.realHead);
        this.syncPart(this.body, dogModel.body);
        this.syncPart(this.mane, dogModel.mane);
        this.syncPart(this.legBackRight, dogModel.legBackRight);
        this.syncPart(this.legBackLeft, dogModel.legBackLeft);
        this.syncPart(this.legFrontRight, dogModel.legFrontRight);
        this.syncPart(this.legFrontLeft, dogModel.legFrontLeft);
        this.syncPart(this.tail, dogModel.tail);
        this.syncPart(this.realTail, dogModel.realTail);
        this.pivot = DogModel.DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = dogModel.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            this.pivot = custom_pivot;
        }
    }

    private void syncPart(Optional<class_630> part, class_630 dogPart) {
        part.ifPresent(p -> this.syncPart((class_630)p, dogPart));
    }

    private void syncPart(class_630 part, class_630 dogPart) {
        ModelUtil_1_21_9.copyModelPartFrom(part, dogPart);
    }

    @Override
    public void renderToBuffer(class_4587 stack, class_4588 p_103014_, int p_103015_, int p_103016_, int color_overlay) {
        DogModel.renderDogModelFromRootWithPivot(stack, this.createDogRenderContext(p_103014_, p_103015_, p_103016_, color_overlay));
    }

    public DogModel.DogModelRenderContext createDogRenderContext(class_4588 p_103014_, int p_103015_, int p_103016_, int color_overlay) {
        DogModel.DogRenderPartContext part_ctx = new DogModel.DogRenderPartContext(p_103014_, p_103015_, p_103016_, color_overlay);
        return new DogModel.DogModelRenderContext(this.root, this.pivot, SyncedAccessoryModel.getDogModelBabyHead(this.head, this.young), Optional.of(part_ctx), Optional.empty());
    }

    protected static Optional<class_630> getDogModelBabyHead(Optional<class_630> head, boolean young) {
        return young ? head : Optional.empty();
    }

    @Override
    public void prepareMobModel(Dog dogIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
    }

    @Override
    public void setupAnim(Dog entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }
}

