/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model.dog;

import doggytalents.api.anim.DogAnimation;
import doggytalents.api.events.RegisterCustomDogModelsEvent;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.backward_imitate.ModelUtil_1_21_9;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.common.entity.Dog;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import net.minecraft.class_7184;
import org.joml.Vector3f;

public class CustomDogModel
extends DogModel {
    private final RegisterCustomDogModelsEvent.DogModelProps props;
    private class_630 glowingEyes;
    private class_630 realGlowingEyes;

    public CustomDogModel(class_630 box, RegisterCustomDogModelsEvent.DogModelProps props) {
        super(box);
        this.props = props;
        if (this.props.glowingEyes) {
            this.setupGlowingEyes();
        }
    }

    private void setupGlowingEyes() {
        this.glowingEyes = this.root.method_32086("glowing_eyes");
        this.realGlowingEyes = this.glowingEyes.method_32086("real_glowing_eyes");
    }

    @Override
    public boolean acessoryShouldRender(Dog dog, AccessoryInstance inst) {
        if (this.props.renderModelAccessoriesOnly) {
            return inst.getAccessory().getAccessoryRenderType() == Accessory.AccessoryRenderType.MODEL;
        }
        return this.props.shouldRenderAccessories;
    }

    @Override
    public boolean incapShouldRender(Dog dog) {
        return this.props.shouldRenderIncapacitated;
    }

    @Override
    public boolean scaleBabyDog() {
        return false;
    }

    @Override
    @Nullable
    public Vector3f getCustomRootPivotPoint() {
        return this.props.customRootPivot;
    }

    @Override
    public boolean hasDefaultScale() {
        return this.props.hasDefaultScale;
    }

    @Override
    public float getDefaultScale() {
        return this.props.defaultScale;
    }

    @Override
    public boolean armorShouldRender(Dog dog) {
        return false;
    }

    @Override
    public DogModel.AccessoryState getAccessoryState() {
        if (this.props.shouldRenderAccessories) {
            return DogModel.AccessoryState.HAVE_NOT_TESTED;
        }
        if (this.props.renderModelAccessoriesOnly) {
            return DogModel.AccessoryState.MODEL_ONLY;
        }
        return DogModel.AccessoryState.NON_COMPATIBLE;
    }

    @Override
    public void setupAnim(Dog dog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.props.glowingEyes) {
            ModelUtil_1_21_9.copyModelPartFrom(this.glowingEyes, this.head);
            ModelUtil_1_21_9.copyModelPartFrom(this.realGlowingEyes, this.realHead);
        }
    }

    @Override
    protected class_7184 getAnimationSequence(DogAnimation anim) {
        Map<DogAnimation, class_7184> animOverride = this.props.getAnimOverride();
        if (animOverride.isEmpty()) {
            return super.getAnimationSequence(anim);
        }
        class_7184 animDef = animOverride.get((Object)anim);
        if (animDef == null) {
            return super.getAnimationSequence(anim);
        }
        return animDef;
    }

    @Override
    public void method_62100(class_4587 stack, class_4588 vertex_consumer, int light, int overlay, int color_overlay) {
        if (this.props.glowingEyes) {
            this.glowingEyes.field_3665 = false;
            this.realGlowingEyes.field_3665 = false;
        }
        super.method_62100(stack, vertex_consumer, light, overlay, color_overlay);
    }

    @Override
    protected Optional<DogModel.AddtionalHeadRenderer> getDogModelAdditionalHeadRenderer() {
        return Optional.of(this::renderGlowingEyes);
    }

    private void renderGlowingEyes(class_4587 stack, Optional<DogModel.DogRenderPartContext> part_ctx_optional) {
        if (!this.props.glowingEyes) {
            return;
        }
        if (!part_ctx_optional.isPresent()) {
            return;
        }
        DogModel.DogRenderPartContext part_ctx = part_ctx_optional.get();
        if (this.head.field_3665) {
            this.glowingEyes.field_3665 = true;
            this.realGlowingEyes.field_3665 = true;
            part_ctx.renderGlowingPart(stack, this.glowingEyes);
            this.glowingEyes.field_3665 = false;
            this.realGlowingEyes.field_3665 = false;
        }
    }
}

