/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.client.backward_imitate.DogRenderLayer_21_3;
import doggytalents.client.backward_imitate.DogRenderState_21_3;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_9273;
import net.minecraft.class_9282;
import net.minecraft.class_9848;
import org.apache.commons.lang3.tuple.Pair;

public class DogWolfArmorRenderer
extends DogRenderLayer_21_3 {
    private static final Map<class_9273.class_4621, class_2960> ARMOR_CRACK_LOCATIONS = Map.of(class_9273.class_4621.field_21082, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_low.png"), class_9273.class_4621.field_21083, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_medium.png"), class_9273.class_4621.field_21084, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_high.png"));
    private DogModel defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
    private static final class_2960 WOLF_ARMOR_MAIN_21_3 = Util.getVanillaResource("textures/entity/equipment/wolf_body/armadillo_scute.png");
    private static final class_2960 WOLF_ARMOR_DYE_21_3 = Util.getVanillaResource("textures/entity/equipment/wolf_body/armadillo_scute_overlay.png");

    public DogWolfArmorRenderer(class_3883 parentRenderer, class_5617.class_5618 ctx) {
        super((class_3883<DogRenderState_21_3, DogModel>)parentRenderer);
    }

    @Override
    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (!dog.method_6181() || dog.method_5767()) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.RENDER_ARMOR.get()).booleanValue() || dog.hideArmor()) {
            return;
        }
        DogSkin skin = dog.getClientSkin();
        if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        if (dog.wolfArmor().method_7960()) {
            return;
        }
        Optional<Pair<class_1799, class_1792>> wolfArmorOptional = this.getWolfArmorItem(dog);
        if (!wolfArmorOptional.isPresent()) {
            return;
        }
        Pair<class_1799, class_1792> wolfArmorPair = wolfArmorOptional.get();
        DogModel parentModel = this.getParentModel();
        DogModel dogModel = parentModel.useDefaultModelForAccessories() ? this.defaultModel : parentModel;
        if (dogModel != parentModel) {
            this.getParentModel().copyPropertiesTo(dogModel);
            dogModel.copyFrom(parentModel);
        }
        this.renderWolfArmorLayerMain(dogModel, poseStack, buffer, packedLight, (class_1792)wolfArmorPair.getRight());
        this.renderWolfArmorLayerDyed(dogModel, poseStack, buffer, packedLight, (class_1799)wolfArmorPair.getLeft(), (class_1792)wolfArmorPair.getRight());
        this.renderWolfArmorLayerCracks(dogModel, poseStack, buffer, packedLight, (class_1799)wolfArmorPair.getLeft());
    }

    private Optional<Pair<class_1799, class_1792>> getWolfArmorItem(Dog dog) {
        class_1799 wolf_armor_stack = dog.wolfArmor();
        if (!ItemUtil_1_21_5.isWolfArmor(wolf_armor_stack)) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)wolf_armor_stack, (Object)wolf_armor_stack.method_7909()));
    }

    private void renderWolfArmorLayerMain(DogModel model, class_4587 poseStack, class_4597 buffer, int light, class_1792 item) {
        class_4588 vertexConsumer = buffer.method_73477(class_1921.method_23578((class_2960)WOLF_ARMOR_MAIN_21_3));
        model.method_62100(poseStack, vertexConsumer, light, class_4608.field_21444, -1);
    }

    private void renderWolfArmorLayerDyed(DogModel model, class_4587 stack, class_4597 buffer, int light, class_1799 itemStack, class_1792 item) {
        if (item != class_1802.field_47831) {
            return;
        }
        int i = class_9282.method_57470((class_1799)itemStack, (int)0);
        if (class_9848.method_61320((int)i) == 0) {
            return;
        }
        class_2960 armor_overlay = WOLF_ARMOR_DYE_21_3;
        if (armor_overlay == null) {
            return;
        }
        float r = (float)class_9848.method_61327((int)i) / 255.0f;
        float g = (float)class_9848.method_61329((int)i) / 255.0f;
        float b = (float)class_9848.method_61331((int)i) / 255.0f;
        model.method_62100(stack, buffer.method_73477(class_1921.method_23578((class_2960)armor_overlay)), light, class_4608.field_21444, class_9848.method_61318((float)1.0f, (float)r, (float)g, (float)b));
    }

    private void renderWolfArmorLayerCracks(DogModel model, class_4587 stack, class_4597 buffer, int light, class_1799 itemStack) {
        class_9273.class_4621 crack_level = class_9273.field_49211.method_57284(itemStack);
        if (crack_level == class_9273.class_4621.field_21081) {
            return;
        }
        class_2960 crack_rl = ARMOR_CRACK_LOCATIONS.get(crack_level);
        class_4588 vertexconsumer = buffer.method_73477(class_1921.method_23580((class_2960)crack_rl));
        model.method_62100(stack, vertexconsumer, light, class_4608.field_21444, -1);
    }
}

