/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.item.DogAnimDebugItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogAnimDebugData;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_7919;

public class DogAnimDebugScreen
extends StringEntrySelectScreen {
    private class_327 font;
    private List<DogAnimation> animList;
    private DogAnimDebugItem.ItemMode selectMode = DogAnimDebugItem.ItemMode.ANIM;
    private DogAnimation selectAnim = DogAnimation.NONE;

    public DogAnimDebugScreen(class_1657 player) {
        super((class_2561)class_2561.method_43473());
        this.font = class_310.method_1551().field_1772;
        this.animList = Arrays.stream(DogAnimation.values()).collect(Collectors.toList());
        this.getSelectModeFromPlayer(player);
        this.getSelectAnimFromPlayer(player);
    }

    private void getSelectModeFromPlayer(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (stack.method_7909() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        this.selectMode = DogAnimDebugItem.getItemMode(stack);
    }

    private void getSelectAnimFromPlayer(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (stack.method_7909() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        this.selectAnim = DogAnimDebugItem.getSelectedAnimation(stack);
    }

    public static void open(class_1657 player) {
        class_310 mc = class_310.method_1551();
        mc.method_1507((class_437)new DogAnimDebugScreen(player));
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.initEntries();
        this.addModeButton();
    }

    @Override
    protected void onEntrySelected(int id) {
        DogAnimation anim_selected = this.animList.get(id);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogAnimDebugData.UpdateItemSettingsData(anim_selected, this.selectMode));
        this.field_22787.method_1507(null);
    }

    private void addModeButton() {
        int mx = this.field_22789 / 2;
        int my = this.field_22790 / 2;
        int modeButton_width = 70;
        int modeButton_height = 20;
        boolean help_render_below_view = this.shouldRenderHelpBelow();
        FlatButton modeButton = new FlatButton(mx - this.getSelectAreaSize() / 2 - 70 - 2, my - this.getSelectAreaSize() / 2, 70, 20, this.getModeTitle(this.selectMode), b -> {
            DogAnimDebugItem.ItemMode new_mode;
            this.selectMode = new_mode = this.selectMode.cycleMode();
            b.method_25355(this.getModeTitle(this.selectMode));
            this.sendItemChangeRequest();
            if (!help_render_below_view) {
                b.method_47400(class_7919.method_47407((class_2561)this.getModeHelp(this.selectMode)));
            }
        });
        if (!help_render_below_view) {
            modeButton.method_47400(class_7919.method_47407((class_2561)this.getModeHelp(this.selectMode)));
        }
        this.method_37063((class_364)modeButton);
    }

    private void sendItemChangeRequest() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogAnimDebugData.UpdateItemSettingsData(this.selectAnim, this.selectMode));
    }

    private class_2561 getModeTitle(DogAnimDebugItem.ItemMode mode) {
        return class_2561.method_43471((String)("item.doggytalents.dog_anim_debug_stick.mode." + mode.getId()));
    }

    private class_2561 getModeHelp(DogAnimDebugItem.ItemMode mode) {
        return class_2561.method_43471((String)("item.doggytalents.dog_anim_debug_stick.mode." + mode.getId() + ".help"));
    }

    private void initEntries() {
        this.updateEntries(this.getAnimNameList());
    }

    private List<String> getAnimNameList() {
        return this.animList.stream().map(x -> x.toString()).collect(Collectors.toList());
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.renderHelp(graphics, this.selectMode);
    }

    private boolean shouldRenderHelpBelow() {
        return this.field_22790 > 353;
    }

    private void renderHelp(class_332 graphics, DogAnimDebugItem.ItemMode mode) {
        if (!this.shouldRenderHelpBelow()) {
            return;
        }
        int mX = this.field_22789 / 2;
        class_2561 desc = this.getModeHelp(mode);
        int max_width = Math.min(360, this.field_22789 - 10);
        List desc_lines = this.font.method_1728((class_5348)desc, max_width);
        int tX = mX - this.font.method_27525((class_5348)this.field_22785) / 2;
        int tY = this.field_22790 / 2 + this.getSelectAreaSize() / 2 + 20;
        for (class_5481 line : desc_lines) {
            tX = mX - this.font.method_30880(line) / 2;
            graphics.method_35720(this.font, line, tX, tY, -1);
            Objects.requireNonNull(this.font);
            tY += 9 + 2;
        }
    }

    @Override
    protected boolean matchIgnoreCaseSearch() {
        return true;
    }
}

