/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import com.google.common.collect.Maps;
import doggytalents.DoggyTags;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.block.model.DogBedModel;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.backward_imitate.DogBedHelper_21_3;
import doggytalents.common.block.BeddingMaterial;
import doggytalents.common.block.CasingMaterial;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.TagUtil;
import doggytalents.common.util.Util;
import doggytalents.forge_imitate.event.TagsUpdatedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_7923;

public class DogBedMaterialManager {
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    public static final class_2960 NANI_KEY = Util.getResource("textures/block/dog_bed_nani");
    public static final class_2960 NANI_TEXTURE = Util.getResource("block/dog_bed_casing_nani");
    private static final Map<class_2960, IBeddingMaterial> beddingMap = Maps.newConcurrentMap();
    private static final Map<class_2960, ICasingMaterial> casingMap = Maps.newConcurrentMap();

    public static Map<class_2960, IBeddingMaterial> getBeddings() {
        return beddingMap;
    }

    public static Map<class_2960, ICasingMaterial> getCasings() {
        return casingMap;
    }

    public static IBeddingMaterial getBedding(class_2960 loc) {
        IBeddingMaterial ret = beddingMap.get(loc);
        if (ret == null) {
            return new NaniBedding(loc);
        }
        return ret;
    }

    public static ICasingMaterial getCasing(class_2960 loc) {
        ICasingMaterial ret = casingMap.get(loc);
        if (ret == null) {
            return new NaniCasing(loc);
        }
        return ret;
    }

    public static IBeddingMaterial getBedding(CompoundTag_1_21_5 tag, String id) {
        class_2960 loc = NBTUtil.getResourceLocation(tag, id);
        return DogBedMaterialManager.getBedding(loc);
    }

    public static ICasingMaterial getCasing(CompoundTag_1_21_5 tag, String id) {
        class_2960 loc = NBTUtil.getResourceLocation(tag, id);
        return DogBedMaterialManager.getCasing(loc);
    }

    public static class_2960 getKey(IBeddingMaterial loc) {
        class_2960 key = loc.getSaveKey();
        if (key == null) {
            return NANI_KEY;
        }
        return key;
    }

    public static class_2960 getKey(ICasingMaterial loc) {
        class_2960 key = loc.getSaveKey();
        if (key == null) {
            return NANI_KEY;
        }
        return key;
    }

    public static IBeddingMaterial randomBedding() {
        List list = beddingMap.entrySet().stream().filter(x -> !(x.getValue() instanceof NaniBedding)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return NaniBedding.NULL;
        }
        return (IBeddingMaterial)((Map.Entry)list.get(RANDOM.nextInt(list.size()))).getValue();
    }

    public static ICasingMaterial randomCasing() {
        List list = casingMap.entrySet().stream().filter(x -> !(x.getValue() instanceof NaniCasing)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return NaniCasing.NULL;
        }
        return (ICasingMaterial)((Map.Entry)list.get(RANDOM.nextInt(list.size()))).getValue();
    }

    public static void refresh(TagsUpdatedEvent.UpdateCause cause) {
        beddingMap.clear();
        casingMap.clear();
        List<class_2248> specific_beddings = TagUtil.queryAllValuesForTag(class_7923.field_41175, DoggyTags.DOG_BED_BEDDINGS);
        List<class_2248> specific_casings = TagUtil.queryAllValuesForTag(class_7923.field_41175, DoggyTags.DOG_BED_CASINGS);
        boolean specific_mode = !specific_beddings.isEmpty() && !specific_casings.isEmpty();
        DogBedMaterialManager.populateBedding(cause, specific_mode ? Optional.of(specific_beddings) : Optional.empty());
        DogBedMaterialManager.populateCasing(cause, specific_mode ? Optional.of(specific_casings) : Optional.empty());
        if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && ((Boolean)ConfigHandler.CLIENT.DOG_BED_CLEAR_CACHE_AUTO.get()).booleanValue()) {
            DogBedModel.clearCache();
        }
    }

    private static void populateBedding(TagsUpdatedEvent.UpdateCause cause, Optional<List<class_2248>> specific) {
        ArrayList blocks = specific.isPresent() ? new ArrayList(specific.get()) : DogBedMaterialManager.fetchBeddingBlocksAuto();
        for (class_2248 block : blocks) {
            if (!(block.method_8389() instanceof class_1747)) continue;
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            IBeddingMaterial value = new BeddingMaterial(id, () -> block);
            if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && !ClientEventHandler.vertifyBlockTexture(value.getTexture())) {
                value = new NaniBedding(id);
            }
            beddingMap.put(id, value);
        }
    }

    private static void populateCasing(TagsUpdatedEvent.UpdateCause cause, Optional<List<class_2248>> specific) {
        ArrayList blocks = specific.isPresent() ? new ArrayList(specific.get()) : DogBedMaterialManager.fetchCasingBlocksAuto();
        for (class_2248 block : blocks) {
            if (!(block.method_8389() instanceof class_1747)) continue;
            class_2960 id = class_7923.field_41175.method_10221((Object)block);
            ICasingMaterial value = new CasingMaterial(id, () -> block);
            if (cause == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED && !ClientEventHandler.vertifyBlockTexture(value.getTexture())) {
                value = new NaniCasing(id);
            }
            casingMap.put(id, value);
        }
    }

    private static List<class_2248> fetchCasingBlocksAuto() {
        List planks = TagUtil.queryAllValuesForTag(class_7923.field_41175, class_3481.field_15471);
        List<class_2248> logs = DogBedHelper_21_3.excludeWoodBlocksFromList(TagUtil.queryAllValuesForTag(class_7923.field_41175, class_3481.field_15475));
        ArrayList<class_2248> ret = new ArrayList<class_2248>(planks.size() + logs.size());
        ret.addAll(planks);
        ret.addAll(logs);
        return ret;
    }

    private static List<class_2248> fetchBeddingBlocksAuto() {
        List wools = TagUtil.queryAllValuesForTag(class_7923.field_41175, class_3481.field_15481);
        ArrayList<class_2248> ret = new ArrayList<class_2248>(wools.size());
        ret.addAll(wools);
        return ret;
    }

    public static void onTagsUpdated(TagsUpdatedEvent event) {
        DogBedMaterialManager.refresh(event.getUpdateCause());
    }

    public static class NaniBedding
    extends IBeddingMaterial {
        public static final NaniBedding NULL = new NaniBedding(null);
        private Optional<class_2960> missingLoc;

        public NaniBedding(class_2960 loc) {
            this.missingLoc = loc == null ? Optional.empty() : Optional.of(loc);
        }

        @Override
        public class_2960 getTexture() {
            return NANI_TEXTURE;
        }

        @Override
        public class_2561 getTooltip() {
            String retStr = "nani?";
            if (this.missingLoc.isPresent()) {
                retStr = this.missingLoc.get().toString();
            }
            return class_2561.method_43471((String)retStr).method_27692(class_124.field_1061);
        }

        @Override
        public Optional<class_1856> getIngredient() {
            return Optional.empty();
        }

        public Optional<class_2960> missingLoc() {
            return this.missingLoc;
        }

        @Override
        public boolean isNani() {
            return true;
        }

        @Override
        public class_2960 getSaveKey() {
            return this.missingLoc().orElse(null);
        }
    }

    public static class NaniCasing
    extends ICasingMaterial {
        public static final NaniCasing NULL = new NaniCasing(null);
        private Optional<class_2960> missingLoc;

        public NaniCasing(class_2960 loc) {
            this.missingLoc = loc == null ? Optional.empty() : Optional.of(loc);
        }

        @Override
        public class_2960 getTexture() {
            return NANI_TEXTURE;
        }

        @Override
        public class_2561 getTooltip() {
            String retStr = "nani?";
            if (this.missingLoc.isPresent()) {
                retStr = this.missingLoc.get().toString();
            }
            return class_2561.method_43471((String)retStr).method_27692(class_124.field_1061);
        }

        @Override
        public Optional<class_1856> getIngredient() {
            return Optional.empty();
        }

        public Optional<class_2960> missingLoc() {
            return this.missingLoc;
        }

        @Override
        public class_2960 getSaveKey() {
            return this.missingLoc().orElse(null);
        }

        @Override
        public boolean isNani() {
            return true;
        }
    }
}

