/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.BerserkerModeGoal;
import doggytalents.common.entity.ai.DogAllowSleepOnGoal;
import doggytalents.common.entity.ai.DogAvoidPushWhenIdleGoal;
import doggytalents.common.entity.ai.DogBegGoal;
import doggytalents.common.entity.ai.DogBeingPetGoal;
import doggytalents.common.entity.ai.DogBreedGoal;
import doggytalents.common.entity.ai.DogCommonSitIdleGoal;
import doggytalents.common.entity.ai.DogCommonStandIdleGoal;
import doggytalents.common.entity.ai.DogDrunkGoal;
import doggytalents.common.entity.ai.DogFeelingNakeyGoal;
import doggytalents.common.entity.ai.DogFindWaterGoal;
import doggytalents.common.entity.ai.DogFloatGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoal;
import doggytalents.common.entity.ai.DogFollowOwnerGoalDefeated;
import doggytalents.common.entity.ai.DogGoAwayFromFireGoal;
import doggytalents.common.entity.ai.DogGoBackToSitAfterFinishAction;
import doggytalents.common.entity.ai.DogGoRestOnBedGoalDefeated;
import doggytalents.common.entity.ai.DogHungryGoal;
import doggytalents.common.entity.ai.DogHurtByTargetGoal;
import doggytalents.common.entity.ai.DogLookAtPlayerGoal;
import doggytalents.common.entity.ai.DogLowHealthGoal;
import doggytalents.common.entity.ai.DogMeleeAttackGoal;
import doggytalents.common.entity.ai.DogMoveBackToRestrictGoal;
import doggytalents.common.entity.ai.DogNearestToOwnerAttackableTargetGoal;
import doggytalents.common.entity.ai.DogOwnerHurtByTargetGoal;
import doggytalents.common.entity.ai.DogOwnerHurtTargetGoal;
import doggytalents.common.entity.ai.DogProtestSitOrderGoal;
import doggytalents.common.entity.ai.DogRandomSitIdleGoal;
import doggytalents.common.entity.ai.DogRandomSniffGoal;
import doggytalents.common.entity.ai.DogRandomStandIdleGoal;
import doggytalents.common.entity.ai.DogRandomStrollGoal;
import doggytalents.common.entity.ai.DogRangedAttackGoal;
import doggytalents.common.entity.ai.DogRestWhenSitGoal;
import doggytalents.common.entity.ai.DogSitWhenOrderedGoal;
import doggytalents.common.entity.ai.DogTacticalTargetGoal;
import doggytalents.common.entity.ai.GuardModeGoal;
import doggytalents.common.entity.ai.PatrolAssistTargetGoal;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1308;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1405;
import net.minecraft.class_1547;
import net.minecraft.class_3695;
import net.minecraft.class_4135;

public class DogAiManager {
    private static final String PROFILER_STR = "dogAi";
    private final Dog dog;
    private final Supplier<class_3695> profilerSup;
    private final ArrayList<class_4135> goals = new ArrayList();
    private final ArrayList<class_4135> targetGoals = new ArrayList();
    private final ArrayList<IHasTickNonRunning> tickNonRunningGoals = new ArrayList();
    private final Map<class_1352.class_4134, class_4135> runningGoalsWithFlag = new EnumMap<class_1352.class_4134, class_4135>(class_1352.class_4134.class);
    private final EnumSet<class_1352.class_4134> lockedFlags = EnumSet.noneOf(class_1352.class_4134.class);
    private DogSitWhenOrderedGoal sitGoal;
    private DogBeingPetGoal beingPetGoal;
    private DogFollowOwnerGoal followOwnerGoal;
    private class_4135 sitGoalWrapped;
    private DogActionExecutorGoal nonTrivialActionGoal;
    private DogActionExecutorGoal trivialActionGoal;
    private int delayedActionStart = 0;
    private int timeoutPending = 0;
    private boolean startedSomeGoals = false;

    public DogAiManager(Dog dog, Supplier<class_3695> profileSup) {
        this.dog = dog;
        this.profilerSup = profileSup;
    }

    public void init() {
        int p = 1;
        this.registerDogGoal(p, (class_1352)new DogFloatGoal(this.dog));
        this.registerDogGoal(p, new DogDrunkGoal(this.dog));
        this.registerDogGoal(p, new DogAvoidPushWhenIdleGoal(this.dog));
        this.registerDogGoal(++p, new DogGoAwayFromFireGoal(this.dog));
        this.initSitGoal(++p);
        this.registerDogGoal(p, new DogProtestSitOrderGoal(this.dog));
        this.registerDogGoal(++p, new DogLowHealthGoal.StickToOwner(this.dog));
        this.registerDogGoal(p, new DogLowHealthGoal.RunAway(this.dog));
        this.registerDogGoal(p, new DogAllowSleepOnGoal(this.dog));
        this.initTriggerableActionGoals(false, ++p);
        this.registerDogGoal(++p, new DogHungryGoal(this.dog, 1.0, 2.0f));
        this.registerDogGoal(++p, new GuardModeGoal.Minor(this.dog));
        this.registerDogGoal(p, new GuardModeGoal.Major(this.dog));
        this.registerDogGoal(++p, new DogRangedAttackGoal(this.dog));
        this.registerDogGoal(p, new DogMeleeAttackGoal(this.dog));
        this.registerDogGoal(p, new DogGoRestOnBedGoalDefeated(this.dog));
        this.registerDogGoal(++p, new DogFindWaterGoal(this.dog));
        this.initTriggerableActionGoals(true, ++p);
        this.registerDogGoal(p, new DogFollowOwnerGoalDefeated(this.dog));
        this.initFollowOwnerGoal(p);
        this.registerDogGoal(++p, new DogGoBackToSitAfterFinishAction(this.dog));
        this.registerDogGoal(p, (class_1352)new DogMoveBackToRestrictGoal(this.dog));
        this.registerDogGoal(p, new DogBreedGoal(this.dog, 1.0));
        this.registerDogGoal(++p, (class_1352)new DogRandomStrollGoal(this.dog, 1.0));
        this.registerDogGoal(p, new DogRandomStandIdleGoal(this.dog));
        this.registerDogGoal(p, new DogRandomSniffGoal(this.dog));
        this.registerDogGoal(p, new DogCommonStandIdleGoal(this.dog));
        this.initBeingPetGoal(p);
        this.registerDogGoal(++p, new DogBegGoal(this.dog, 8.0f));
        this.registerDogGoal(++p, new DogFeelingNakeyGoal(this.dog));
        this.registerDogGoal(p, (class_1352)new DogLookAtPlayerGoal(this.dog));
        this.registerDogGoal(p, (class_1352)new class_1376((class_1308)this.dog));
        this.registerDogGoal(p, new DogRandomSitIdleGoal(this.dog));
        this.registerDogGoal(p, new DogCommonSitIdleGoal(this.dog));
        this.registerDogGoal(p, new DogRestWhenSitGoal(this.dog));
        this.registerTargetGoal(1, new DogTacticalTargetGoal(this.dog));
        this.registerTargetGoal(1, (class_1405)new DogOwnerHurtByTargetGoal(this.dog));
        this.registerTargetGoal(2, (class_1405)new DogOwnerHurtTargetGoal(this.dog));
        this.registerTargetGoal(3, (class_1405)new DogHurtByTargetGoal(this.dog));
        this.registerTargetGoal(6, (class_1405)new BerserkerModeGoal(this.dog));
        this.registerTargetGoal(6, (class_1405)new GuardModeGoal(this.dog));
        this.registerTargetGoal(6, (class_1405)new PatrolAssistTargetGoal(this.dog));
        this.registerTargetGoal(7, (class_1405)new DogNearestToOwnerAttackableTargetGoal<class_1547>(this.dog, class_1547.class, false));
    }

    private void initTriggerableActionGoals(boolean trivial, int priority) {
        if (!trivial) {
            this.nonTrivialActionGoal = new DogActionExecutorGoal(this, trivial, priority);
            this.registerDogGoal(priority, this.nonTrivialActionGoal);
        } else {
            this.trivialActionGoal = new DogActionExecutorGoal(this, trivial, priority);
            this.registerDogGoal(priority, this.trivialActionGoal);
        }
    }

    private void initSitGoal(int priority) {
        this.sitGoal = new DogSitWhenOrderedGoal(this.dog);
        this.sitGoalWrapped = this.registerDogGoal(priority, this.sitGoal);
    }

    private void initBeingPetGoal(int priority) {
        this.beingPetGoal = new DogBeingPetGoal(this.dog);
        this.registerDogGoal(priority, this.beingPetGoal);
    }

    private void initFollowOwnerGoal(int priority) {
        this.followOwnerGoal = new DogFollowOwnerGoal(this.dog, 1.0, 10.0f, 2.0f);
        this.registerDogGoal(priority, this.followOwnerGoal);
    }

    private class_4135 registerDogGoal(int priority, class_1352 goal) {
        class_4135 ret = new class_4135(priority, goal);
        if (goal instanceof IHasTickNonRunning) {
            IHasTickNonRunning ticker = (IHasTickNonRunning)goal;
            this.tickNonRunningGoals.add(ticker);
        }
        this.goals.add(ret);
        return ret;
    }

    private void registerTargetGoal(int priority, class_1405 goal) {
        this.targetGoals.add(new class_4135(priority, (class_1352)goal));
    }

    public void tickServer() {
        if (!this.dog.canUpdateDogAi()) {
            if (this.getActiveAction().isPresent()) {
                this.clearTriggerableAction();
            }
            if (this.startedSomeGoals) {
                this.startedSomeGoals = false;
                this.forceStopAllGoal();
            }
            return;
        }
        class_3695 profiler = this.profilerSup.get();
        profiler.method_15396(PROFILER_STR);
        if (this.delayedActionStart > 0) {
            --this.delayedActionStart;
        } else {
            this.timeoutPending();
        }
        this.tickNonRunningGoalWithPrev();
        boolean updateTime = this.isTimeToUpdateNonEveryTick(this.dog);
        this.invalidateRunning(updateTime);
        this.invalidateFlags(updateTime);
        this.startNewGoalOrAction(updateTime);
        this.tickRunning(updateTime);
        profiler.method_15407();
    }

    private void timeoutPending() {
        Optional<TriggerableAction> activeActionOptional = this.getActiveAction();
        if (!activeActionOptional.isPresent()) {
            return;
        }
        if (activeActionOptional.get().getState() != TriggerableAction.ActionState.PENDING) {
            return;
        }
        ++this.timeoutPending;
        if (this.timeoutPending >= 20) {
            this.clearTriggerableAction();
        }
    }

    private void invalidateRunning(boolean goalUpdateTime) {
        if (goalUpdateTime) {
            this.stopRunningGoalIfShouldBeStopped(this.goals);
            this.stopRunningGoalIfShouldBeStopped(this.targetGoals);
        }
    }

    private void invalidateFlags(boolean goalUpdateTime) {
        if (goalUpdateTime) {
            this.invalidateNotRunningFlags();
        }
    }

    private void startNewGoalOrAction(boolean goalUpdateTime) {
        if (goalUpdateTime) {
            this.findNewGoalToStart(this.goals);
            this.findNewGoalToStart(this.targetGoals);
        }
    }

    private void tickRunning(boolean goalUpdateTime) {
        boolean only_tick_always_update = !goalUpdateTime;
        this.tickRunningGoals(this.goals, only_tick_always_update);
        this.tickRunningGoals(this.targetGoals, only_tick_always_update);
    }

    private void tickNonRunningGoalWithPrev() {
        for (IHasTickNonRunning goal : this.tickNonRunningGoals) {
            goal.tickDogWhenNotRunning();
        }
    }

    private boolean isTimeToUpdateNonEveryTick(Dog dog) {
        if (dog.field_6012 <= 1) {
            return false;
        }
        int timeLine = dog.method_73183().method_8503().method_3780() + dog.method_5628();
        return timeLine % 2 == 0;
    }

    private void invalidateNotRunningFlags() {
        Iterator<Map.Entry<class_1352.class_4134, class_4135>> itr = this.runningGoalsWithFlag.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<class_1352.class_4134, class_4135> entry = itr.next();
            class_4135 value = entry.getValue();
            if (value != null && value.method_19056()) continue;
            itr.remove();
        }
    }

    private void stopRunningGoalIfShouldBeStopped(ArrayList<class_4135> goalList) {
        for (class_4135 goal : goalList) {
            if (!goal.method_19056() || !this.goalMustStop(goal)) continue;
            this.stopGoal(goal);
        }
    }

    private boolean goalMustStop(class_4135 goal) {
        if (this.goalHasLockedFlag(goal)) {
            return true;
        }
        return !goal.method_6266();
    }

    private void findNewGoalToStart(ArrayList<class_4135> goalList) {
        for (class_4135 goal : goalList) {
            if (goal.method_19056() || !this.goalCanStart(goal)) continue;
            this.startGoal(goal);
        }
    }

    private void startGoal(class_4135 goal) {
        if (goal.method_19058() == this.beingPetGoal) {
            this.beingPetGoal.dogBeingPetGoalPreStart();
        }
        for (class_1352.class_4134 flag : goal.method_6271()) {
            class_4135 runningGoal = this.runningGoalsWithFlag.get(flag);
            if (runningGoal != null) {
                this.stopGoal(runningGoal);
            }
            this.runningGoalsWithFlag.put(flag, goal);
        }
        goal.method_6269();
        this.startedSomeGoals = true;
    }

    private boolean goalCanStart(class_4135 goal) {
        if (this.goalHasLockedFlag(goal)) {
            return false;
        }
        if (this.isBlockedByAnotherGoalSharingFlag(goal)) {
            return false;
        }
        return goal.method_6264();
    }

    private boolean isBlockedByAnotherGoalSharingFlag(class_4135 goal) {
        EnumSet flags = goal.method_6271();
        if (flags.isEmpty()) {
            return false;
        }
        for (class_1352.class_4134 flag : flags) {
            class_4135 runningGoal = this.runningGoalsWithFlag.get(flag);
            if (runningGoal == null || runningGoal.method_19055(goal)) continue;
            return true;
        }
        return false;
    }

    private void tickRunningGoals(ArrayList<class_4135> goalList, boolean tick_only_always_update) {
        for (class_4135 goal : goalList) {
            if (!goal.method_19056() || tick_only_always_update && !goal.method_38846()) continue;
            goal.method_6268();
        }
    }

    private boolean goalHasLockedFlag(class_4135 goal) {
        for (class_1352.class_4134 flag : goal.method_6271()) {
            if (!this.lockedFlags.contains(flag)) continue;
            return true;
        }
        return false;
    }

    private void stopGoal(class_4135 goal) {
        goal.method_6270();
        if (goal.method_6271().contains(class_1352.class_4134.field_18405)) {
            this.dog.method_5942().method_6340();
        }
    }

    public void setLockedFlag(class_1352.class_4134 flag, boolean free) {
        if (!free) {
            this.lockedFlags.add(flag);
        } else {
            this.lockedFlags.remove(flag);
        }
    }

    public void forceStopAllGoal() {
        this.clearTriggerableAction();
        for (class_4135 goal : this.goals) {
            if (!goal.method_19056()) continue;
            this.stopGoal(goal);
        }
    }

    public void forceStopAllGoalWithFlag(class_1352.class_4134 flag) {
        if (this.nonTrivialActionGoal.method_6271().contains(flag)) {
            this.clearTriggerableAction();
        }
        for (class_4135 goal : this.goals) {
            if (!goal.method_19056() || !goal.method_6271().contains(flag)) continue;
            this.stopGoal(goal);
        }
    }

    private void onNonTrivialActionInterupted() {
        this.trivialActionGoal.clearAction();
    }

    public boolean isBusy() {
        if (this.getActiveAction().isPresent()) {
            return true;
        }
        int trivial_p = this.trivialActionGoal.getPriority();
        for (class_1352.class_4134 flag : this.trivialActionGoal.method_6271()) {
            if (this.lockedFlags.contains(flag)) {
                return true;
            }
            class_4135 runningGoal = this.runningGoalsWithFlag.get(flag);
            if (runningGoal == null || runningGoal.method_19058() == this.sitGoal || !runningGoal.method_19056() || runningGoal.method_19057() > trivial_p) continue;
            return true;
        }
        return false;
    }

    public boolean readyForNonTrivivalAction() {
        boolean hasNonTrivialAction = this.getActiveAction().map(x -> !x.isTrivial()).orElse(false);
        if (hasNonTrivialAction) {
            return false;
        }
        int non_trivial_p = this.nonTrivialActionGoal.getPriority();
        for (class_1352.class_4134 flag : this.nonTrivialActionGoal.method_6271()) {
            if (this.lockedFlags.contains(flag)) {
                return false;
            }
            class_4135 runningGoal = this.runningGoalsWithFlag.get(flag);
            if (runningGoal == null || runningGoal.method_19058() == this.sitGoal || !runningGoal.method_19056() || runningGoal.method_19057() > non_trivial_p) continue;
            return false;
        }
        return true;
    }

    public boolean triggerAction(TriggerableAction action) {
        boolean sitBlock;
        if (action == null) {
            return false;
        }
        if (this.isOtherActionOccupied(action)) {
            return false;
        }
        boolean bl = sitBlock = this.dog.method_24345() && (this.dog.forceSit() || !action.canOverrideSit());
        if (sitBlock) {
            return false;
        }
        if (action.goBackToSitPosWhenFinished()) {
            this.maySaveDogSittingPos();
        }
        this.dog.method_24346(false);
        this.putActionInExecutor(action);
        this.delayedActionStart = 0;
        this.timeoutPending = 0;
        return true;
    }

    public void maySaveDogSittingPos() {
        if (!this.dog.method_24345()) {
            return;
        }
        if (!this.dog.method_6172()) {
            return;
        }
        if (!this.dog.method_24828()) {
            return;
        }
        this.dog.setDogSitOverridePos(this.dog.method_24515());
    }

    private boolean isOtherActionOccupied(TriggerableAction action) {
        Optional<TriggerableAction> activeActionOptional = this.getActiveAction();
        if (!activeActionOptional.isPresent()) {
            return false;
        }
        TriggerableAction activeAction = activeActionOptional.get();
        boolean override_condition = activeAction.isTrivial() && !action.isTrivial();
        return !override_condition;
    }

    private void putActionInExecutor(TriggerableAction action) {
        if (action.isTrivial()) {
            this.trivialActionGoal.setAction(action);
            return;
        }
        TriggerableAction trivialAction = this.trivialActionGoal.getAction();
        if (trivialAction != null) {
            if (trivialAction.canPause()) {
                trivialAction.setState(TriggerableAction.ActionState.PAUSED);
            } else {
                this.trivialActionGoal.clearAction();
            }
        }
        this.nonTrivialActionGoal.setAction(action);
    }

    public boolean triggerActionDelayed(TriggerableAction action, int delayed) {
        boolean ret = this.triggerAction(action);
        if (ret) {
            this.delayedActionStart = delayed;
        }
        return ret;
    }

    public void clearTriggerableAction() {
        this.nonTrivialActionGoal.clearAction();
        this.trivialActionGoal.clearAction();
    }

    public void handleOfflineDog() {
        this.nonTrivialActionGoal.handleOfflineDog();
        this.trivialActionGoal.handleOfflineDog();
    }

    public boolean isActionBlockingSit() {
        Optional<TriggerableAction> actionOptional = this.getActiveAction();
        if (!actionOptional.isPresent()) {
            return false;
        }
        TriggerableAction action = actionOptional.get();
        return action.canPreventSit() && action.getState() == TriggerableAction.ActionState.RUNNING;
    }

    public Optional<TriggerableAction> getActiveAction() {
        TriggerableAction action = null;
        action = this.nonTrivialActionGoal.getAction() != null ? this.nonTrivialActionGoal.getAction() : this.trivialActionGoal.getAction();
        return Optional.ofNullable(action);
    }

    public boolean isSitGoalRunning() {
        if (this.sitGoalWrapped == null) {
            return false;
        }
        return this.sitGoalWrapped.method_19056();
    }

    public void requestFollow() {
        this.followOwnerGoal.requestFollow();
    }

    public static class DogActionExecutorGoal
    extends class_1352 {
        @Nullable
        private TriggerableAction action = null;
        private final DogAiManager dogAi;
        private final int priority;
        private final boolean isTrivial;

        public DogActionExecutorGoal(DogAiManager dogAi, boolean trivial, int p) {
            this.dogAi = dogAi;
            this.isTrivial = trivial;
            this.priority = p;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return this.action != null;
        }

        public boolean method_6266() {
            return this.action != null;
        }

        public void setAction(TriggerableAction action) {
            if (this.action != null) {
                this.clearAction();
            }
            this.action = action;
        }

        public void clearAction() {
            if (this.action == null) {
                return;
            }
            this.action.stop();
            this.action = null;
        }

        public void handleOfflineDog() {
            if (this.action == null) {
                return;
            }
            this.action.onDogGoesOfflineWhileActive();
            this.action = null;
        }

        public boolean hasAction() {
            return this.action != null;
        }

        public TriggerableAction getAction() {
            return this.action;
        }

        public void method_6270() {
            TriggerableAction action = this.action;
            if (action == null) {
                return;
            }
            if (action.getState() == TriggerableAction.ActionState.FINISHED) {
                this.clearAction();
                return;
            }
            if (action.isStarted() && action.canPause()) {
                action.setState(TriggerableAction.ActionState.PAUSED);
                return;
            }
            this.clearAction();
            if (!this.isTrivial) {
                this.dogAi.onNonTrivialActionInterupted();
            }
        }

        public void method_6268() {
            TriggerableAction action = this.action;
            if (action == null) {
                return;
            }
            if (this.dogAi.delayedActionStart > 0) {
                return;
            }
            TriggerableAction.ActionState state = action.getState();
            boolean shouldTick = false;
            if (state == TriggerableAction.ActionState.PENDING) {
                action.setState(TriggerableAction.ActionState.RUNNING);
                action.start();
            } else if (state == TriggerableAction.ActionState.PAUSED) {
                action.setState(TriggerableAction.ActionState.RUNNING);
                if (action.isStarted()) {
                    shouldTick = true;
                } else {
                    action.start();
                }
            } else if (state == TriggerableAction.ActionState.RUNNING) {
                shouldTick = true;
            }
            if (shouldTick) {
                action.doTick();
            }
            if ((state = action.getState()) == TriggerableAction.ActionState.FINISHED) {
                this.clearAction();
            }
        }

        public boolean method_38846() {
            return true;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public static interface IHasTickNonRunning {
        public void tickDogWhenNotRunning();
    }
}

