/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.entity.ai.triggerable.DogWantAttentionAction;
import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import org.apache.commons.lang3.tuple.Pair;

public class DogBeingPetGoal
extends class_1352 {
    private Dog dog;
    private boolean petEnd = false;
    private boolean startInterupt = false;
    private int petEndTickLeft = 0;
    private DogAnimation currentLoopAnim = DogAnimation.FACERUB_PP;
    private static final List<DogAnimation> facerubloopAnims_p_pp = List.of(DogAnimation.FACERUB_PP, DogAnimation.FACERUB_PP2, DogAnimation.FACERUB_P, DogAnimation.FACERUB_P2);
    private static final List<DogAnimation> facerubloopAnims_f_ff = List.of(DogAnimation.FACERUB_F, DogAnimation.FACERUB_F2, DogAnimation.FACERUB_F, DogAnimation.FACERUB_FF2);
    private static final List<DogAnimation> hugloopAnims_p_pp = List.of(DogAnimation.HUG_PP, DogAnimation.HUG_PP2, DogAnimation.HUG_P, DogAnimation.HUG_P2);
    private static final List<DogAnimation> hugloopAnims_f_ff = List.of(DogAnimation.HUG_F, DogAnimation.HUG_F2, DogAnimation.HUG_F, DogAnimation.HUG_FF2);
    private static final List<DogAnimation> bellyloopAnims_p_pp = List.of(DogAnimation.BELLY_PET_PP, DogAnimation.BELLY_PET_PP2, DogAnimation.BELLY_PET_P, DogAnimation.BELLY_PET_P2);
    private static final List<DogAnimation> bellyloopAnims_f_ff = List.of(DogAnimation.BELLY_PET_F, DogAnimation.BELLY_PET_F2, DogAnimation.BELLY_PET_FF, DogAnimation.BELLY_PET_FF2);
    private static final List<DogAnimation> backhugloopAnims_p_pp = List.of(DogAnimation.BACKHUG_PP, DogAnimation.BACKHUG_PP2, DogAnimation.BACKHUG_P, DogAnimation.BACKHUG_P2);
    private static final List<DogAnimation> backhugloopAnims_f_ff = List.of(DogAnimation.BACKHUG_F, DogAnimation.BACKHUG_F2, DogAnimation.BACKHUG_F, DogAnimation.BACKHUG_FF2);
    private DogPettingManager.DogPettingType currentType = DogPettingManager.DogPettingType.FACERUB;
    private int tickTillChangeLoop = 0;
    private int petTick_ff_threshold = 0;
    private int petTick = 0;
    private int sound_cooldown;
    private int triggerCooldown;
    private boolean startWithBellyRub = false;

    public DogBeingPetGoal(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.method_24345()) {
            return false;
        }
        if (!this.dog.pettingManager.isPetting()) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.method_5809()) {
            return false;
        }
        if (!DogPettingManager.isDogPoseCanPet(this.dog.getDogPose())) {
            return false;
        }
        return this.dog.method_24828();
    }

    public boolean method_6266() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.method_24345()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.method_6172()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        return !this.petEnd || this.petEndTickLeft > 0;
    }

    public void dogBeingPetGoalPreStart() {
        DogAnimation anim = this.dog.getAnim();
        this.currentType = this.dog.getPettingState().type();
        if (this.currentType != DogPettingManager.DogPettingType.BELLY_RUB) {
            this.startWithBellyRub = false;
            return;
        }
        this.startWithBellyRub = anim == DogAnimation.BELLY_RUB || anim == DogAnimation.REST_BELLY_LOOP;
    }

    public void method_6269() {
        this.currentType = this.dog.getPettingState().type();
        DogAnimation start_anim = this.getStartAnim();
        DogAnimation first_anim = this.getFirstAnim();
        DogAnimation end_anim = this.getEndAnim();
        this.petEndTickLeft = end_anim.getLengthTicks();
        if (this.startWithBellyRub) {
            start_anim = first_anim;
        }
        this.dog.setAnimForIdle(start_anim);
        this.currentLoopAnim = first_anim;
        this.tickTillChangeLoop = first_anim.getLengthTicks() * 3;
        this.petEnd = false;
        this.startInterupt = false;
        this.petTick = 0;
        int r = this.dog.method_59922().method_39332(0, 25);
        this.petTick_ff_threshold = (5 + r) * 20;
        this.sound_cooldown = 0;
        this.triggerCooldown = this.startTriggerCooldown(this.dog);
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    private void resetLoopAnim() {
        List<DogAnimation> petloopAnims_target = this.getLoopAnims_pp_p();
        if (this.petTick >= this.petTick_ff_threshold) {
            petloopAnims_target = this.getLoopAnims_ff_f();
        }
        int r_anim = this.dog.method_59922().method_43048(petloopAnims_target.size());
        this.currentLoopAnim = petloopAnims_target.get(r_anim);
        int r_loop_count = 1;
        this.tickTillChangeLoop = r_loop_count * this.currentLoopAnim.getLengthTicks();
    }

    public void method_6268() {
        class_1309 owner;
        DogAnimation end_anim = this.getEndAnim();
        DogAnimation start_anim = this.getStartAnim();
        if (this.startInterupt) {
            end_anim = this.getEndAnimWhileStartInterupt(end_anim);
        }
        if (!this.petEnd && !this.dog.pettingManager.isPetting()) {
            this.petEnd = true;
            if (this.dog.getAnim() == this.getStartAnim()) {
                this.startInterupt = true;
                end_anim = this.getEndAnimWhileStartInterupt(end_anim);
            }
            this.petEndTickLeft = end_anim.getLengthTicks();
        }
        if (this.petEnd) {
            --this.petEndTickLeft;
            if (this.dog.getAnim() != end_anim) {
                this.dog.setAnim(end_anim);
            }
            this.dog.pettingManager.setLocked(true);
            this.dog.dogSoundManager.interuptPlaying();
            return;
        }
        if (this.dog.getAnim() == DogAnimation.NONE || this.dog.getAnim() == start_anim && this.dog.animationManager.isHolding()) {
            this.dog.setAnim(this.currentLoopAnim);
        }
        if (this.dog.getAnim() == this.currentLoopAnim) {
            --this.tickTillChangeLoop;
        }
        if (this.tickTillChangeLoop <= 0) {
            this.resetLoopAnim();
            this.dog.setAnim(this.currentLoopAnim);
        }
        if ((owner = this.dog.method_35057()) != null) {
            this.lookWhenPet(owner);
        }
        ++this.petTick;
        this.updateAmbientSound();
        this.updateTriggerNearbyDogsJealous();
        this.rejuvinateDog();
    }

    private void lookWhenPet(class_1309 owner) {
        if (this.currentType == DogPettingManager.DogPettingType.BELLY_RUB) {
            this.lookPerpenticullarToOwner(owner);
        } else {
            this.dog.method_5988().method_6226((class_1297)owner, 10.0f, (float)this.dog.method_5978());
        }
    }

    private void lookPerpenticullarToOwner(class_1309 owner) {
        class_243 dog_pos = this.dog.method_33571();
        class_243 owner_pos = owner.method_73189();
        class_243 v_dog_owner = owner_pos.method_1020(dog_pos);
        v_dog_owner = v_dog_owner.method_1023(0.0, v_dog_owner.field_1351, 0.0).method_1029().method_1024(1.5707964f).method_1019(dog_pos);
        this.dog.method_5988().method_19615(v_dog_owner);
    }

    private void updateAmbientSound() {
        if (this.sound_cooldown > 0) {
            --this.sound_cooldown;
            return;
        }
        class_3414 selectedEvent = null;
        float r = this.dog.method_59922().method_43057();
        if ((double)r >= 0.1) {
            return;
        }
        Pair<class_3414, Boolean> pair = this.dog.dogMood.getPettingAmbient();
        selectedEvent = (class_3414)pair.getLeft();
        boolean is_classic = (Boolean)pair.getRight();
        int n = this.sound_cooldown = is_classic ? 20 : 40;
        if (this.petTick < this.petTick_ff_threshold) {
            this.sound_cooldown = 50;
        }
        if (selectedEvent != null) {
            if (!is_classic) {
                this.dog.dogSoundManager.playInterruptible(selectedEvent, this.dog.method_6107(), this.dog.method_6017());
            } else {
                this.dog.method_5783(selectedEvent, this.dog.method_6107(), this.dog.method_6017());
            }
        }
    }

    private void updateTriggerNearbyDogsJealous() {
        if (--this.triggerCooldown > 0) {
            return;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOG_PETITNG_JEALOUS.get()).booleanValue()) {
            return;
        }
        this.triggerCooldown = this.shortTriggerCooldown(this.dog);
        Optional<Dog> target_optional = EntityUtil.getRandomEntityAround((class_1309)this.dog, Dog.class, 7, 1, filter_dog -> this.isTargetJealousDog((Dog)filter_dog));
        if (!target_optional.isPresent()) {
            return;
        }
        Dog target = target_optional.get();
        float r = this.dog.method_59922().method_43057();
        if (r > target.pettingManager.getJealousChance()) {
            return;
        }
        this.triggerCooldown = this.longTriggerCooldown(this.dog);
        class_1309 owner = target.method_35057();
        if (owner == null) {
            return;
        }
        target.triggerAction(new DogWantAttentionAction(target, owner));
    }

    private void rejuvinateDog() {
        if (this.dog.method_59922().method_43048(60) != 0) {
            return;
        }
        boolean add_hunger = this.dog.method_59922().method_43056();
        if (add_hunger) {
            if (this.dog.getDogHunger() < 25.0f) {
                this.dog.addHunger(1.0f);
            }
        } else if (this.dog.method_6032() / this.dog.method_6063() < 0.25f) {
            this.dog.method_6025(1.0f);
        }
    }

    private int startTriggerCooldown(Dog dog) {
        return 100;
    }

    private int longTriggerCooldown(Dog dog) {
        return 200 + dog.method_59922().method_43048(6) * 20;
    }

    private int shortTriggerCooldown(Dog dog) {
        return 40 + dog.method_59922().method_43048(6) * 20;
    }

    private boolean isTargetJealousDog(Dog target) {
        if (!target.isDoingFine()) {
            return false;
        }
        if (target.isBusy()) {
            return false;
        }
        class_1309 owner = target.method_35057();
        if (owner == null || owner != this.dog.method_35057()) {
            return false;
        }
        DogPettingManager pet_manager = target.pettingManager;
        if (!DogPettingManager.isDogAbleToBePet(target)) {
            return false;
        }
        return !(pet_manager.getJealousChance() <= 0.0f);
    }

    public void method_6270() {
        DogAnimation anim = this.dog.getAnim();
        if (!anim.interupting()) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.pettingManager.stopPetting();
        this.dog.pettingManager.setLocked(false);
        this.dog.dogSoundManager.interuptPlaying();
        this.dog.dogSoundManager.setAmbientLocked(false);
    }

    public boolean method_38846() {
        return true;
    }

    private DogAnimation getStartAnim() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return DogAnimation.HUG_START;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return DogAnimation.BACKHUG_START;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return DogAnimation.BELLY_PET_START;
        }
        return DogAnimation.FACERUB_START;
    }

    private DogAnimation getFirstAnim() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return DogAnimation.HUG_PP;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return DogAnimation.BACKHUG_PP;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return DogAnimation.BELLY_PET_PP;
        }
        return DogAnimation.FACERUB_PP;
    }

    private DogAnimation getEndAnim() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return DogAnimation.HUG_END;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return DogAnimation.BACKHUG_END;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return DogAnimation.BELLY_PET_END;
        }
        return DogAnimation.FACERUB_END;
    }

    private DogAnimation getEndAnimWhileStartInterupt(DogAnimation current) {
        return DogAnimation.FACERUB_END;
    }

    private List<DogAnimation> getLoopAnims_pp_p() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return hugloopAnims_p_pp;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return backhugloopAnims_p_pp;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return bellyloopAnims_p_pp;
        }
        return facerubloopAnims_p_pp;
    }

    private List<DogAnimation> getLoopAnims_ff_f() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return hugloopAnims_f_ff;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return backhugloopAnims_f_ff;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return bellyloopAnims_f_ff;
        }
        return facerubloopAnims_f_ff;
    }
}

