/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_7;

public class DogFollowOwnerGoal
extends class_1352
implements DogAiManager.IHasTickNonRunning {
    private final Dog dog;
    private final class_1937 world;
    private final double followSpeed;
    private final float stopDist;
    private final float startDist;
    private class_1309 owner;
    private int timeToRecalcPath;
    private int tickTillSearchForTp = 0;
    private float oldWaterCost;
    private int followRequest = 0;

    public DogFollowOwnerGoal(Dog dogIn, double speedIn, float minDistIn, float maxDistIn) {
        this.dog = dogIn;
        this.world = dogIn.method_73183();
        this.followSpeed = speedIn;
        this.startDist = minDistIn;
        this.stopDist = maxDistIn;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 owner = this.dog.method_35057();
        if (owner == null) {
            return false;
        }
        if (!this.dog.getMode().shouldFollowOwner()) {
            return false;
        }
        if (owner.method_7325()) {
            return false;
        }
        if (this.dog.method_6172()) {
            return false;
        }
        if (!this.dog.hasBone() && this.dog.method_5858((class_1297)owner) < (double)this.getMinStartDistanceSq() && this.followRequest <= 0) {
            return false;
        }
        if (this.dog.getDogSitOverridePos().isPresent()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean method_6266() {
        if (this.dog.method_5942().method_6357()) {
            return false;
        }
        if (this.dog.method_6172()) {
            return false;
        }
        return this.dog.method_5858((class_1297)this.owner) > (double)(this.stopDist * this.stopDist);
    }

    public void method_6269() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dog.method_5944(class_7.field_18);
        this.dog.setDogFollowingSomeone(true);
    }

    public void method_6270() {
        double distanceToOwner;
        if (this.dog.hasBone() && (distanceToOwner = this.owner.method_5858((class_1297)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            class_1799 fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.method_5699((class_3218)this.dog.method_73183(), fetchItem, 0.0f);
            this.dog.setBoneVariant(class_1799.field_8037);
        }
        this.owner = null;
        this.dog.method_5942().method_6340();
        this.dog.setDogFollowingSomeone(false);
        this.followRequest = 0;
        this.dog.randomStrollCooldown = 40;
    }

    public void method_6268() {
        this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.dog.isDogFlying() ? 5 : 10;
            DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.followSpeed, 144.0, true, --this.tickTillSearchForTp <= 0, 400.0, this.dog.method_5850());
            if (this.tickTillSearchForTp <= 0) {
                this.tickTillSearchForTp = 10;
            }
        }
    }

    public float getMinStartDistanceSq() {
        return this.startDist * this.startDist;
    }

    @Override
    public void tickDogWhenNotRunning() {
        if (this.followRequest > 0) {
            --this.followRequest;
        }
    }

    public void requestFollow() {
        this.followRequest = 20;
    }
}

