/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DogSounds;
import doggytalents.DogVariants;
import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;

public class DogWantsAttentionGoal
extends class_1352 {
    private final Dog dog;
    private class_1309 owner;
    private int lastStopTick;
    private int cooldownTime = 200;
    private Phase phase = Phase.GO_TO_OWNER;
    private int goToOwnerTimeout;
    private int tickTillPathRecalc;
    private boolean whinedToAttention;
    private int tickAnim;
    private int stopTick;

    public DogWantsAttentionGoal(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.method_5809()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        if (this.dog.field_6012 - this.lastStopTick < this.cooldownTime) {
            return false;
        }
        if (this.dog.dogVariant() != DogVariants.CHESTNUT.get()) {
            return false;
        }
        if (this.dog.method_59922().method_43057() >= 0.01f) {
            return false;
        }
        class_1309 owner = this.dog.method_35057();
        if (owner == null) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean method_6266() {
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (this.phase == Phase.GO_TO_OWNER) {
            return this.goToOwnerTimeout > 0;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.PLAY_WITH_MEH) {
            return false;
        }
        if (this.dog.method_5858((class_1297)this.owner) > 16.0) {
            return false;
        }
        return this.dog.field_6012 < this.stopTick;
    }

    public void method_6269() {
        this.phase = Phase.GO_TO_OWNER;
        this.goToOwnerTimeout = 200;
        this.whinedToAttention = false;
    }

    public void method_6268() {
        if (this.phase == Phase.GO_TO_OWNER) {
            this.tickGoToOwner();
        } else {
            this.tickBegForAttention();
        }
    }

    private void tickGoToOwner() {
        boolean closeEnough;
        this.dog.method_5988().method_35111((class_1297)this.owner);
        if (--this.goToOwnerTimeout <= 0) {
            this.goToOwnerTimeout = 0;
            return;
        }
        double d0 = this.dog.method_5858((class_1297)this.owner);
        boolean bl = closeEnough = d0 < 6.0;
        if (--this.tickTillPathRecalc <= 0) {
            if (!closeEnough) {
                this.dog.method_5942().method_6335((class_1297)this.owner, 1.0);
            }
            this.tickTillPathRecalc = 20;
        }
        if (closeEnough) {
            if (!this.dog.method_5942().method_6357()) {
                this.dog.method_5942().method_6340();
            }
            if (!this.whinedToAttention) {
                this.whinedToAttention = true;
                this.dog.method_5783(DogSounds.CLASSIC_WHINE.get(), this.dog.method_6107(), this.dog.method_6017());
            }
            this.checkAndSwitchToAttention();
        }
    }

    private void checkAndSwitchToAttention() {
        if (!DogUtil.checkIfOwnerIsLooking(this.dog, this.owner)) {
            return;
        }
        this.phase = Phase.BEG_FOR_ATTENTION;
        this.tickAnim = 0;
        this.stopTick = this.dog.field_6012 + DogAnimation.PLAY_WITH_MEH.getLengthTicks();
        this.dog.setAnim(DogAnimation.PLAY_WITH_MEH);
    }

    private void tickBegForAttention() {
        this.dog.method_5988().method_35111((class_1297)this.owner);
    }

    public void method_6270() {
        this.owner = null;
        this.lastStopTick = this.dog.field_6012;
        this.cooldownTime = 20 * (1 + this.dog.method_59922().method_43048(3));
        if (this.dog.getAnim() == DogAnimation.PLAY_WITH_MEH) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    public boolean method_38846() {
        return true;
    }

    private static enum Phase {
        GO_TO_OWNER,
        BEG_FOR_ATTENTION;

    }
}

