/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogNodeEvaluator;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.apache.commons.lang3.tuple.Pair;

public class DogPathNavigation
extends class_1408
implements IDogNavLock {
    private Dog dog;
    private boolean locked;
    private boolean moveInTargetNode = false;

    public DogPathNavigation(Dog dog, class_1937 level) {
        super((class_1308)dog, level);
        this.dog = dog;
    }

    public void method_6360() {
        super.method_6360();
        if (this.method_6357() && this.field_6681 != null && this.field_6681.method_46()) {
            this.method_6340();
        }
        this.setSneakIfNextNodesHasDanger();
    }

    protected void method_6339() {
        boolean isCloseEnough;
        if (this.invalidateIfNextNodeIsTooHigh()) {
            return;
        }
        class_243 currentPos = this.method_6347();
        this.field_6683 = 0.45f;
        class_2338 nextPos = this.field_6681.method_31032();
        double dx = Math.abs(this.field_6684.method_23317() - ((double)nextPos.method_10263() + 0.5));
        double dy = Math.abs(this.field_6684.method_23318() - (double)nextPos.method_10264());
        double dz = Math.abs(this.field_6684.method_23321() - ((double)nextPos.method_10260() + 0.5));
        boolean bl = isCloseEnough = dx <= (double)this.field_6683 && dy < 1.0 && dz <= (double)this.field_6683;
        if (isCloseEnough) {
            this.field_6681.method_44();
            this.checkDogAndMoveInTargetNodeWhenReach();
        }
        this.method_6346(currentPos);
        this.dogCheckIfMissedFirstNodeAndMaybeSkip();
    }

    private void dogCheckIfMissedFirstNodeAndMaybeSkip() {
        boolean kinda_far_from_first_node;
        boolean missed_first_node;
        if (this.method_6357()) {
            return;
        }
        class_11 path = this.method_6345();
        if (path == null || path.method_38() < 2) {
            return;
        }
        boolean bl = missed_first_node = path.method_39() == 0;
        if (!missed_first_node) {
            return;
        }
        class_9 first_node = path.method_40(0);
        class_9 second_node = path.method_40(1);
        if (second_node.field_41 != class_7.field_12) {
            return;
        }
        double min_bb_clip = 0.1;
        double max_dist_from_first_node = 0.5 + (double)(this.dog.method_17681() / 2.0f) - 0.1;
        double dog_dist_from_first_node_sqr = this.dog.method_5707(new class_243((double)first_node.field_40 + 0.5, this.dog.method_23318(), (double)first_node.field_38 + 0.5));
        boolean bl2 = kinda_far_from_first_node = dog_dist_from_first_node_sqr > max_dist_from_first_node * max_dist_from_first_node;
        if (kinda_far_from_first_node) {
            return;
        }
        class_2338 bpos = this.dog.method_24515();
        int y_diff = second_node.field_39 - bpos.method_10264();
        if (y_diff > 0 || y_diff < -1) {
            return;
        }
        class_243 pos = this.dog.method_73189();
        class_243 second_node_pos = class_243.method_24955((class_2382)second_node.method_22879());
        class_243 dist_vec = pos.method_1020(second_node_pos);
        double len_xz_sqr = dist_vec.field_1352 * dist_vec.field_1352 + dist_vec.field_1350 * dist_vec.field_1350;
        if (len_xz_sqr > 2.0) {
            return;
        }
        path.method_44();
    }

    protected boolean invalidateIfNextNodeIsTooHigh() {
        boolean is_first_fence_node;
        class_11 path = this.field_6681;
        if (path == null) {
            return true;
        }
        class_2338 nextPos = path.method_31032();
        double dy = this.dog.method_23318() - (double)nextPos.method_10264();
        if (dy < -1.75) {
            this.method_6340();
            return true;
        }
        class_9 nextNode = path.method_29301();
        boolean bl = is_first_fence_node = nextNode.field_41 == class_7.field_10 && path.method_39() == 0;
        if (!is_first_fence_node && this.dog.method_5944(nextNode.field_41) < 0.0f) {
            this.method_6340();
            return true;
        }
        return false;
    }

    private void checkDogAndMoveInTargetNodeWhenReach() {
        if (!this.moveInTargetNode) {
            return;
        }
        class_11 path = this.field_6681;
        if (path == null) {
            return;
        }
        if (!path.method_46() || path.method_38() <= 0 || !path.method_21655()) {
            return;
        }
        class_2338 target = path.method_48();
        class_9 end_node = path.method_45();
        if (target == null || end_node == null) {
            return;
        }
        if (end_node.method_22879().equals((Object)target)) {
            return;
        }
        class_7 type = class_14.method_57625((class_1308)this.dog, (class_2338)target);
        if (this.dog.method_5944(type) < 0.0f) {
            return;
        }
        class_9 node = new class_9(target.method_10263(), target.method_10264(), target.method_10260());
        node.field_41 = type;
        this.field_6681 = new class_11(List.of(node), target, true);
    }

    private void setSneakIfNextNodesHasDanger() {
        Optional<Pair<Integer, class_9>> result_optional = this.getNodesUntilDogApproachDanger();
        if (!result_optional.isPresent()) {
            return;
        }
        if (this.dog.method_52535()) {
            return;
        }
        Pair<Integer, class_9> result = result_optional.get();
        int danger = (Integer)result.getLeft();
        float speed_cap = danger > 1 ? 0.4f : (danger == 1 ? 0.3f : 0.2f);
        this.dog.getDefaultMoveControl().forceSneak(speed_cap);
    }

    public Optional<Pair<Integer, class_9>> getNodesUntilDogApproachDanger() {
        if (this.method_6357()) {
            return Optional.empty();
        }
        class_11 path = this.method_6345();
        if (path == null) {
            return Optional.empty();
        }
        if (path.method_39() >= path.method_38()) {
            return Optional.empty();
        }
        Pair ret = null;
        int start = path.method_39();
        int end = Math.min(start + 2, path.method_38() - 1);
        int prev_node_y = this.dog.method_24515().method_10264();
        for (int i = start; i <= end; ++i) {
            class_9 node = path.method_40(i);
            if (prev_node_y == node.field_39 && i < end) continue;
            prev_node_y = node.field_39;
            class_7 type = node.field_41;
            if (type == null || !DogUtil.isDangerPathType(type = this.dog.inferType(type, InferTypeContext.getDefault()))) continue;
            int danger = i - start;
            ret = danger >= 0 ? Pair.of((Object)danger, (Object)node) : null;
            break;
        }
        return Optional.ofNullable(ret);
    }

    public Optional<class_9> getDogNextNode() {
        if (this.method_6357()) {
            return Optional.empty();
        }
        class_11 path = this.method_6345();
        if (path == null) {
            return Optional.empty();
        }
        int next_indx = path.method_39();
        if (next_indx >= path.method_38()) {
            return Optional.empty();
        }
        return Optional.of(path.method_40(next_indx));
    }

    public boolean shouldDogBlockFluidPush() {
        if (this.dog.method_24828()) {
            return false;
        }
        return this.getDogNextNode().isPresent();
    }

    public void setDogMoveInTargetNode() {
        this.moveInTargetNode = true;
    }

    protected boolean method_6358() {
        boolean ground_canUpdatePath = this.field_6684.method_24828() || this.field_6684.method_52535();
        return ground_canUpdatePath && !this.dog.isOnSwitchNavCooldown() && !this.locked;
    }

    public void method_6356() {
        boolean prevLock = this.locked;
        this.locked = false;
        super.method_6356();
        this.locked = prevLock;
    }

    public boolean method_6334(@Nullable class_11 p_26537_, double p_26538_) {
        this.moveInTargetNode = false;
        return super.method_6334(p_26537_, p_26538_);
    }

    public boolean method_6333(class_2338 pos) {
        if (this.dog.method_5753() && this.field_6677.method_8316(pos).method_15767(class_3486.field_15518)) {
            return true;
        }
        return super.method_6333(pos);
    }

    protected class_13 method_6336(int p_26453_) {
        this.field_6678 = new DogNodeEvaluator(this::getDog);
        this.field_6678.method_15(true);
        return new class_13(this.field_6678, p_26453_);
    }

    private Dog getDog() {
        return this.dog;
    }

    protected class_243 method_6347() {
        return DogPathNavigation.getTempDogPos(this.dog, this);
    }

    public static class_243 getTempDogPos(Dog dog) {
        return DogPathNavigation.getTempDogPos(dog, dog.method_5942());
    }

    public static class_243 getTempDogPos(Dog dog, class_1408 nav) {
        return new class_243(dog.method_23317(), (double)DogPathNavigation.getSurfaceY(dog, nav), dog.method_23321());
    }

    private static int getSurfaceY(Dog dog, class_1408 nav) {
        boolean do_float_y;
        boolean bl = do_float_y = dog.method_52535() && nav.method_6350();
        if (!do_float_y) {
            return DogUtil.getSurfaceStandingInY(dog);
        }
        int y_block = dog.method_31478();
        for (int y_offset = 0; y_offset <= 16; ++y_offset) {
            int check_y = y_block + y_offset;
            class_2338 check_pos = class_2338.method_49637((double)dog.method_23317(), (double)check_y, (double)dog.method_23321());
            class_2680 check_state = dog.method_73183().method_8320(check_pos);
            if (!check_state.method_26227().method_15769()) continue;
            return check_y;
        }
        return y_block;
    }

    @Override
    public void lockDogNavigation() {
        this.locked = true;
    }

    @Override
    public void unlockDogNavigation() {
        this.locked = false;
    }

    @Nullable
    protected class_11 method_18416(@Nonnull Set<class_2338> pos, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        this.dogThrowIfLockAndDebug();
        return super.method_18416(pos, p_148224_, p_148225_, p_148226_, p_148227_);
    }

    private void dogThrowIfLockAndDebug() {
    }

    public boolean method_70686() {
        return true;
    }
}

