/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.talent.WolfMountTalent;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class DogGoAndCarryPlayerAction
extends TriggerableAction {
    @Nonnull
    private final class_1309 owner;
    private int timeout;
    private int tickTillPathRecalc;
    private static final int force_ride_distance = 2;

    public DogGoAndCarryPlayerAction(Dog dog, class_1309 owner) {
        super(dog, false, false);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.timeout = 100;
        this.tickTillPathRecalc = 8;
    }

    @Override
    public void tick() {
        if (this.owner.method_5858((class_1297)this.dog) > 144.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!WolfMountTalent.isValidCarryMeDog(this.dog)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!WolfMountTalent.isValidCarryMeTarget(this.owner)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (--this.timeout <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        double dist_sqr = this.dog.method_5858((class_1297)this.owner);
        if (dist_sqr <= 4.0) {
            this.owner.method_5804((class_1297)this.dog);
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.dog.method_5978());
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 20;
            DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 400.0, false, false, 400.0, this.dog.method_5850());
        }
    }

    @Override
    public void onStop() {
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }

    @Override
    public boolean goBackToSitPosWhenFinished() {
        return false;
    }
}

