/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class DogGoBehindOwnerAction
extends TriggerableAction {
    @Nonnull
    private final class_1309 owner;
    private class_2338 targetPos = null;
    private int holdTimeLeft;

    public DogGoBehindOwnerAction(Dog dog, @Nonnull class_1309 owner) {
        super(dog, false, false);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        if (!this.owner.method_5805() || this.owner.method_5858((class_1297)this.dog) > 256.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.getBehindOwnerPos();
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.method_5942().method_6340();
        DogUtil.moveToIfReachOrElse(this.dog, this.targetPos, this.dog.getUrgentSpeedModifier(), 1, 1, d -> {
            this.targetPos = null;
        });
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.holdTimeLeft = 40;
    }

    @Override
    public void tick() {
        if (this.targetPos == null) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.dog.method_5942().method_6357()) {
            --this.holdTimeLeft;
        }
        if (this.holdTimeLeft <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    @Override
    public void onStop() {
    }

    private void getBehindOwnerPos() {
        class_243 owner_pos0 = this.owner.method_73189();
        float a1 = this.owner.method_5791();
        float dx1 = class_3532.method_15374((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = -class_3532.method_15362((float)(a1 * ((float)Math.PI / 180)));
        class_243 vec_back = new class_243((double)dx1, 0.0, (double)dz1);
        double pX = owner_pos0.field_1352;
        double pY = owner_pos0.field_1351;
        double pZ = owner_pos0.field_1350;
        for (int i = 0; i < 3; ++i) {
            class_2338 bpos = class_2338.method_49637((double)(pX += vec_back.field_1352), (double)pY, (double)(pZ += vec_back.field_1350));
            if (DogUtil.isWalkNodeEvaluatorBlockedPos(this.dog, bpos)) {
                pY += 1.0;
                continue;
            }
            if (!DogUtil.isWalkNodeEvaluatorOpenPos(this.dog, bpos.method_10074())) continue;
            pY -= 1.0;
        }
        class_2338 bpos = class_2338.method_49637((double)pX, (double)pY, (double)pZ);
        this.targetPos = DogUtil.isWalkNodeEvaluatorOpenPos(this.dog, bpos) ? bpos : null;
    }
}

