/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1682;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;

public class DogFoodProjectile
extends class_1682 {
    private class_1799 foodStack = class_1799.field_8037;
    private int tickTillScan = 0;
    private static final class_2940<class_1799> FOOD_STACK = class_2945.method_12791(DogFoodProjectile.class, (class_2941)class_2943.field_13322);

    public DogFoodProjectile(class_1299<? extends class_1682> type, class_1937 worldIn) {
        super(type, worldIn);
    }

    public DogFoodProjectile(class_1937 worldIn, class_1309 livingEntityIn) {
        super(DoggyEntityTypes.DOG_FOOD_PROJ.get(), livingEntityIn.method_23317(), livingEntityIn.method_23320() - (double)0.1f, livingEntityIn.method_23321(), worldIn);
    }

    protected void method_7488(class_239 hitResult) {
        if (!this.method_73183().field_9236 && !this.foodStack.method_7960()) {
            this.method_5775((class_3218)this.method_73183(), this.foodStack);
        }
        if (!this.method_73183().field_9236) {
            this.method_31472();
        }
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_73183().field_9236) {
            this.scanDogAroundAndTrigger();
        }
    }

    private void scanDogAroundAndTrigger() {
        if (this.tickTillScan > 0) {
            --this.tickTillScan;
            return;
        }
        if (this.method_24921() == null) {
            return;
        }
        class_243 pos = this.method_73189();
        class_238 aabb = new class_238(pos.method_1031(-5.0, -5.0, -5.0), pos.method_1031(5.0, 0.0, 5.0));
        class_243 moveVec = this.method_18798();
        class_243 moveVecXZ = new class_243(moveVec.field_1352, 0.0, moveVec.field_1350).method_1029();
        if (moveVecXZ.method_1033() < 1.0) {
            return;
        }
        List dogs = this.method_73183().method_8390(Dog.class, aabb, filter_dog -> this.isValidDog((Dog)filter_dog, moveVecXZ));
        if (dogs.isEmpty()) {
            return;
        }
        this.tickTillScan = 3;
        Dog nearestDog = (Dog)dogs.get(0);
        double minDist = nearestDog.method_5858((class_1297)this);
        for (Dog dog : dogs) {
            double dist = dog.method_5858((class_1297)this);
            if (!(dist < minDist)) continue;
            nearestDog = dog;
            minDist = dist;
        }
        double dy = this.method_73189().field_1351 - nearestDog.method_73189().field_1351;
        double minDistXZ = new class_243(this.method_73189().field_1352 - nearestDog.method_73189().field_1352, 0.0, this.method_73189().field_1350 - nearestDog.method_73189().field_1350).method_1027();
        if (minDist < 4.0) {
            this.feedDog(nearestDog);
        } else if (dy >= 1.5 && minDistXZ >= 10.0) {
            nearestDog.triggerAction(new DogJumpAndEatAction(nearestDog, this));
        }
    }

    private boolean isValidDog(Dog dog, class_243 lookVecXZ) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (dog.method_24345()) {
            return false;
        }
        if (dog.method_35057() != this.method_24921()) {
            return false;
        }
        if (!this.checkIfDogCanCatch(dog, lookVecXZ) && dog.method_5858((class_1297)this) >= 4.0) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return this.dogCanStillEatItem(dog, this.foodStack);
    }

    private boolean checkIfDogCanCatch(Dog dog, class_243 lookVecXZ) {
        class_243 dogPosXZ = new class_243(dog.method_73189().field_1352, 0.0, dog.method_73189().field_1350);
        class_243 posXZ = new class_243(this.method_73189().field_1352, 0.0, this.method_73189().field_1350);
        double dist = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(dogPosXZ, posXZ, lookVecXZ);
        if (dist < 0.0) {
            return false;
        }
        return dist < 2.25;
    }

    private boolean dogCanStillEatItem(Dog dog, class_1799 stack) {
        IDogEddible eddible;
        Optional<IDogFoodHandler> handlerOptional = FoodHandler.getMatch(dog, stack, null);
        if (!handlerOptional.isPresent()) {
            return false;
        }
        IDogFoodHandler handler = handlerOptional.get();
        if (handler instanceof IDogEddible && (eddible = (IDogEddible)handler).alwaysEatWhenDogConsume(dog)) {
            return true;
        }
        return dog.getDogHunger() < dog.getMaxHunger();
    }

    public class_1799 getDogFoodStack() {
        return (class_1799)this.field_6011.method_12789(FOOD_STACK);
    }

    public void setDogFoodStack(class_1799 stack) {
        this.field_6011.method_12778(FOOD_STACK, (Object)stack);
        this.foodStack = stack;
    }

    public boolean feedDog(Dog dog) {
        if (!this.method_5805()) {
            return false;
        }
        class_1799 stack = this.getDogFoodStack();
        if (stack.method_7960()) {
            return false;
        }
        Optional<IDogFoodHandler> handlerOptional = FoodHandler.getMatch(dog, stack, null);
        if (!handlerOptional.isPresent()) {
            return false;
        }
        IDogFoodHandler handler = handlerOptional.get();
        handler.consume(dog, stack, null);
        if (stack.method_7960()) {
            this.method_31472();
        }
        return true;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(FOOD_STACK, (Object)class_1799.field_8037);
    }

    public static class DogJumpAndEatAction
    extends TriggerableAction {
        private DogFoodProjectile target;
        private int tickTillJump;
        private int tickTillConsumeItem;
        private int stopTick;
        private boolean consumed = false;

        public DogJumpAndEatAction(Dog dog, DogFoodProjectile target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
            this.stopTick = this.dog.field_6012 + DogAnimation.BACKFLIP.getLengthTicks();
            this.dog.setAnim(DogAnimation.BACKFLIP);
            this.tickTillJump = 3;
            this.tickTillConsumeItem = 5;
        }

        @Override
        public void tick() {
            if (this.dog.getAnim() != DogAnimation.BACKFLIP) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.field_6012 >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (--this.tickTillJump == 0) {
                this.dog.method_5993().method_6233();
            }
            if (!this.consumed && --this.tickTillConsumeItem <= 0) {
                this.tryConsumeItem();
            }
        }

        public void tryConsumeItem() {
            if (!this.target.method_5805()) {
                return;
            }
            if (this.dog.method_5858((class_1297)this.target) > 4.0) {
                return;
            }
            this.target.feedDog(this.dog);
            this.consumed = true;
        }

        @Override
        public void onStop() {
            this.dog.method_5942().method_6340();
            if (this.dog.getAnim() == DogAnimation.BACKFLIP) {
                this.dog.setAnim(DogAnimation.NONE);
            }
        }
    }
}

