/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory;

import doggytalents.api.backward_imitate.CodecUtil_1_21_7;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.ItemUtil_1_21_3;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.api.backward_imitate.ListTag_1_21_5;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.DogArmorItemHandler;
import doggytalents.common.util.ItemUtil;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class DogArmorItemHandlerImpl
extends DogArmorItemHandler {
    public DogArmorItemHandlerImpl(AbstractDog dog) {
        super(dog);
    }

    @Override
    public class_2487 serializeNBT(class_7225.class_7874 prov) {
        class_2499 itemsList = new class_2499();
        for (int i = 0; i < this.stacks.size(); ++i) {
            class_1799 stack = (class_1799)this.stacks.get(i);
            if (stack.method_7960()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10567("Slot", (byte)i);
            itemsList.add((Object)CodecUtil_1_21_7.saveItemStack(stack, prov, itemTag));
        }
        class_2487 compound = new class_2487();
        compound.method_10566("dogArmors", (class_2520)itemsList);
        return compound;
    }

    @Override
    public void deserializeNBT(class_7225.class_7874 prov, class_2487 compound_1_21_5) {
        CompoundTag_1_21_5 compound = CompoundTag_1_21_5.wrap(compound_1_21_5);
        if (compound.contains("dogArmors", 9)) {
            ListTag_1_21_5 tagList = compound.getList("dogArmors", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag_1_21_5 itemTag = tagList.getCompound(i);
                int slot = itemTag.getInt("Slot");
                class_1799 stack = CodecUtil_1_21_7.parseItemStack(prov, itemTag.wrapped()).orElse(class_1799.field_8037);
                this.setArmorInSlot(stack);
            }
            this.onLoad();
        }
    }

    public void setArmorInSlot(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (!ItemUtil_1_21_5.isHumanoidArmor(stack)) {
            return;
        }
        class_1304 slot = ItemUtil_1_21_3.getEquipmentSlot(stack);
        this.setArmorInSlot(stack, slot);
    }

    public void setArmorInSlot(class_1799 stack, class_1304 slot) {
        DogArmorSlots dogSlot = DogArmorSlots.byEquipment(slot);
        if (dogSlot == null) {
            return;
        }
        this.stacks.set(dogSlot.slotId, (Object)stack);
    }

    public class_1799 getArmorFromSlot(class_1304 slot) {
        DogArmorSlots dogSlot = DogArmorSlots.byEquipment(slot);
        if (dogSlot == null) {
            return class_1799.field_8037;
        }
        return (class_1799)this.stacks.get(dogSlot.slotId);
    }

    public Iterable<class_1799> armors() {
        return this.stacks;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        boolean is_depth_strider;
        if (!this.dog.canDogWearArmor()) {
            return false;
        }
        DogArmorSlots dogSlot = DogArmorSlots.bySlotId(slot);
        if (dogSlot == null) {
            return false;
        }
        class_1304 equip = dogSlot.val;
        class_1792 item = stack.method_7909();
        if (!ItemUtil_1_21_5.isHumanoidArmor(stack)) {
            return false;
        }
        class_1304 wantSlot = ItemUtil_1_21_3.getEquipmentSlot(stack);
        if (wantSlot != equip) {
            return false;
        }
        boolean bl = is_depth_strider = wantSlot == class_1304.field_6166 && ItemUtil.getEnchantmentLevelForItem((class_5321<class_1887>)class_1893.field_9128, this.dog.method_73183().method_30349(), stack) > 0;
        return !is_depth_strider;
    }

    public void onPropsUpdated(DogAlterationProps props) {
        if (props.canWearArmor()) {
            return;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)class_1799.field_8037);
        }
    }

    public static enum DogArmorSlots {
        HEAD(0, class_1304.field_6169),
        CHEST(1, class_1304.field_6174),
        LEGS(2, class_1304.field_6172),
        FEET(3, class_1304.field_6166);

        public final int slotId;
        public final class_1304 val;

        private DogArmorSlots(int slotId, class_1304 val) {
            this.slotId = slotId;
            this.val = val;
        }

        public static DogArmorSlots bySlotId(int slotId) {
            DogArmorSlots[] values;
            for (DogArmorSlots val : values = DogArmorSlots.values()) {
                if (val.slotId != slotId) continue;
                return val;
            }
            return null;
        }

        public static DogArmorSlots byEquipment(class_1304 slot) {
            DogArmorSlots[] values;
            for (DogArmorSlots val : values = DogArmorSlots.values()) {
                if (val.val != slot) continue;
                return val;
            }
            return null;
        }
    }
}

