/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.HoverTextAppender_1_21_5;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.screen.AllStandSwitchModeScreen;
import doggytalents.client.screen.CarryMeScreen;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.client.screen.HeelByNameScreen;
import doggytalents.client.screen.WhistleScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGoBehindOwnerAction;
import doggytalents.common.entity.ai.triggerable.DogHowlAction;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.entity.misc.DoggyBeamEntity;
import doggytalents.common.talent.BedDogTalent;
import doggytalents.common.talent.MobRetrieverTalent;
import doggytalents.common.talent.RoaringGaleTalent;
import doggytalents.common.talent.doggy_tools.DogBridging;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.util.PlayerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5321;

public class WhistleItem
extends class_1792
implements IDogItem,
HoverTextAppender_1_21_5 {
    public WhistleItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dogIn, class_1937 worldIn, class_1657 player, class_1268 hand) {
        WhistleMode mode;
        class_1799 stack = player.method_5998(hand);
        byte id_mode = 0;
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag.containsAnyNumeric("mode")) {
            id_mode = tag.getByte("mode");
        }
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        return (mode = WhistleMode.VALUES[id_mode]) == WhistleMode.MOB_RETRIEVER || mode == WhistleMode.RIDE_WITH_ME || mode == WhistleMode.HOWL || mode == WhistleMode.BED_DOG_WHISTLE ? DogInteractionResult.FAIL : DogInteractionResult.PASS;
    }

    public class_1269 method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            if (world.field_9236) {
                WhistleScreen.open(stack);
            }
            return class_1269.field_5812;
        }
        byte id_mode = 0;
        boolean on_duty_only = false;
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag.containsAnyNumeric("mode")) {
            id_mode = tag.getByte("mode");
        }
        on_duty_only = tag.getBoolean("dog_on_duty_only");
        List dogsList = world.method_8390(Dog.class, player.method_5829().method_1009(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.method_6171((class_1309)player));
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        WhistleMode mode = WhistleMode.VALUES[id_mode];
        this.useMode(mode, on_duty_only, dogsList, world, player, hand, false);
        return class_1269.field_5812;
    }

    public void useMode(WhistleMode mode, boolean dogOnDutyOnly, List<Dog> dogsList, class_1937 world, class_1657 player, class_1268 hand, boolean isKeyBind) {
        if (mode == null) {
            return;
        }
        switch (mode.getSound().ordinal()) {
            case 0: {
                break;
            }
            case 2: {
                world.method_8396(null, player.method_24515(), DoggySounds.WHISTLE_LONG.get(), class_3419.field_15248, 0.6f + world.field_9229.method_43057() * 0.1f, 0.8f + world.field_9229.method_43057() * 0.2f);
                break;
            }
            case 1: {
                world.method_8396(null, player.method_24515(), DoggySounds.WHISTLE_SHORT.get(), class_3419.field_15248, 0.6f + world.field_9229.method_43057() * 0.1f, 0.8f + world.field_9229.method_43057() * 0.2f);
            }
        }
        boolean successful = false;
        switch (mode.ordinal()) {
            case 0: {
                if (world.field_9236) {
                    return;
                }
                for (Dog dog : dogsList) {
                    boolean wandering_ignore;
                    if (dogOnDutyOnly && !dog.dogOnDuty()) continue;
                    boolean bl = wandering_ignore = dog.getMode().canWander() && (Boolean)ConfigHandler.SERVER.WANDERING_DOG_WHISTLE.get() == false;
                    if (wandering_ignore) continue;
                    dog.method_24346(false);
                    dog.method_5942().method_6340();
                    dog.method_5980(null);
                    successful = true;
                }
                if (successful) {
                    PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43471((String)"dogcommand.come"));
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 1: {
                if (world.field_9236) {
                    return;
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 40);
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                List<Dog> heel_list = dogsList.stream().filter(filter_dog -> {
                    if (dogOnDutyOnly && !filter_dog.dogOnDuty()) {
                        return false;
                    }
                    if (filter_dog.method_24345()) {
                        return false;
                    }
                    if (!filter_dog.getMode().shouldFollowOwner()) {
                        return false;
                    }
                    return filter_dog.method_5858((class_1297)player) > 9.0;
                }).collect(Collectors.toList());
                if (max_heel_count > 0 && heel_list.size() > max_heel_count) {
                    Collections.sort(heel_list, new EntityUtil.Sorter((class_1297)player));
                    heel_list = heel_list.subList(0, max_heel_count);
                }
                if (heel_list.isEmpty()) {
                    return;
                }
                for (Dog dog : heel_list) {
                    dog.clearTriggerableAction();
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch(world, heel_list, (class_1309)player, 3);
                PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43471((String)"dogcommand.heel"));
                return;
            }
            case 2: {
                if (world.field_9236) {
                    return;
                }
                for (Dog dog : dogsList) {
                    boolean wandering_ignore;
                    if (dogOnDutyOnly && !dog.dogOnDuty()) continue;
                    boolean bl = wandering_ignore = dog.getMode().canWander() && (Boolean)ConfigHandler.SERVER.WANDERING_DOG_WHISTLE.get() == false;
                    if (wandering_ignore) continue;
                    dog.method_24346(true);
                    dog.method_5942().method_6340();
                    dog.method_5980(null);
                    successful = true;
                }
                if (successful) {
                    PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43471((String)"dogcommand.stay"));
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 3: {
                if (world.field_9236) {
                    return;
                }
                for (Dog dog : dogsList) {
                    successful = true;
                    dog.method_5980(null);
                }
                if (successful) {
                    PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43471((String)"dogcommand.stop_attacking"));
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 4: {
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 5: {
                if (world.field_9236) {
                    return;
                }
                DoggyBeamEntity doggyBeam = new DoggyBeamEntity(world, (class_1309)player);
                doggyBeam.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 2.0f, 1.0f);
                world.method_8649((class_1297)doggyBeam);
                PlayerUtil.addCooldown(player, this, 10);
                return;
            }
            case 6: {
                Optional<Integer> cooldown_optional = RoaringGaleTalent.roar(dogsList, world, player);
                cooldown_optional.ifPresent(x -> PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), x));
                return;
            }
            case 7: {
                if (world.field_9236) {
                    HeelByNameScreen.open(isKeyBind ? 200 : 0);
                }
                return;
            }
            case 8: {
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                if (dogsList.isEmpty()) {
                    return;
                }
                if (player.method_73183().field_9236) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    class_2338 bedPos;
                    noDogs = false;
                    if (!dog.readyForNonTrivialAction() || (bedPos = (class_2338)dog.getBedPos((class_5321<class_1937>)player.method_73183().method_27983()).orElse(null)) == null || dog.method_24515().equals((Object)bedPos) && dog.method_6172() || !(dog.method_5707(class_243.method_24955((class_2382)bedPos)) < 400.0)) continue;
                    dog.triggerActionDelayed(2, new DogMoveToBedAction(dog, bedPos, false));
                }
                return;
            }
            case 9: {
                if (player.method_73183().field_9236) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    class_1309 owner;
                    if (dogOnDutyOnly && !dog.dogOnDuty() || !dog.getMode().shouldFollowOwner() || dog.method_24345() || (owner = dog.method_35057()) == null || dog.method_5858((class_1297)owner) > 400.0) continue;
                    dog.method_5980(null);
                    dog.clearTriggerableAction();
                    dog.triggerAction(new DogGoBehindOwnerAction(dog, owner));
                    noDogs = false;
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 10: {
                if (world.field_9236) {
                    HeelByGroupScreen.open();
                }
                return;
            }
            case 11: {
                class_238 search_area;
                class_243 view_vec;
                class_243 max_reach_vec;
                class_243 max_pos;
                if (world.field_9236) {
                    return;
                }
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                Optional<Dog> retrieverOptional = MobRetrieverTalent.chooseNearestDog(player, world);
                if (retrieverOptional.isEmpty()) {
                    return;
                }
                Dog retriever = retrieverOptional.get();
                Optional<TalentInstance> talentOptional = retriever.getTalent(DoggyTalents.MOB_RETRIEVER.get());
                if (talentOptional.isEmpty()) {
                    return;
                }
                MobRetrieverTalent talentInst = (MobRetrieverTalent)talentOptional.get();
                int reach_range = MobRetrieverTalent.getSelectTargetRange();
                class_243 eye_pos = player.method_33571();
                class_3966 hitResult = class_1675.method_18075((class_1297)player, (class_243)eye_pos, (class_243)(max_pos = eye_pos.method_1019(max_reach_vec = (view_vec = player.method_5828(1.0f)).method_1021((double)reach_range))), (class_238)(search_area = player.method_5829().method_18804(max_reach_vec).method_1009(1.0, 1.0, 1.0)), e -> {
                    if (!(e instanceof class_1309)) {
                        return false;
                    }
                    class_1309 living = (class_1309)e;
                    return talentInst.isValidTarget(retriever, living);
                }, (double)(reach_range * reach_range));
                if (hitResult == null) {
                    return;
                }
                class_1297 entity = hitResult.method_17782();
                if (entity == null) {
                    return;
                }
                talentInst.setTarget(retriever, (class_1309)entity);
                return;
            }
            case 12: {
                this.heelByLook(world, player);
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 13: {
                this.rideWithMe(world, player);
                PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case 14: {
                this.howl(world, player);
                return;
            }
            case 15: {
                if (world.field_9236) {
                    AllStandSwitchModeScreen.open(player);
                }
                return;
            }
            case 16: {
                this.sssshhhh(world, player, dogsList);
                return;
            }
            case 17: {
                this.crossOriginTpForDogs(world, player, dogsList);
                return;
            }
            case 18: {
                BedDogTalent.useBedDog(world, player);
                return;
            }
            case 19: {
                this.allStandOnDuty(world, player, dogsList);
                return;
            }
            case 20: {
                if (world.field_9236) {
                    CarryMeScreen.open(player);
                }
                return;
            }
            case 21: {
                DogBridging.useBridgingWhistle(this, player, world);
                return;
            }
            case 22: {
                this.catchUp(world, player, dogsList, dogOnDutyOnly);
                return;
            }
        }
    }

    private void rideWithMe(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (dog.method_5765()) {
            dog.method_18375();
            return;
        }
        class_1297 vehicle = player.method_5854();
        if (vehicle == null) {
            return;
        }
        dog.authorizeRiding();
        boolean result = dog.method_5804(vehicle);
        if (result) {
            PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43469((String)"dogcommand.ride_with_me", (Object[])new Object[]{dog.method_5477().getString()}));
        }
    }

    private void heelByLook(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        DogUtil.dynamicSearchAndTeleportToOwnwer(dog, (class_1309)player, 2);
        PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43469((String)"dogcommand.heel_by_name", (Object[])new Object[]{dog.method_5477().getString()}));
        dog.method_24346(false);
    }

    private void howl(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30);
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (!dog.readyForNonTrivialAction()) {
            return;
        }
        dog.triggerAction(new DogHowlAction(dog));
        player.method_73183().method_8396(null, player.method_24515(), DoggySounds.WHISTLE_SHORT.get(), class_3419.field_15248, 0.6f + player.method_73183().field_9229.method_43057() * 0.1f, 0.8f + player.method_73183().field_9229.method_43057() * 0.2f);
    }

    private void sssshhhh(class_1937 level, class_1657 player, List<Dog> dogs) {
        if (level.field_9236) {
            return;
        }
        PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
        boolean shh_ed = false;
        for (Dog dog : dogs) {
            if (!this.canShh(player, dog)) continue;
            shh_ed = true;
            dog.setSilentTickLeft(400);
        }
        if (shh_ed) {
            PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43471((String)"dogcommand.ssshhh"));
            level.method_8396(null, player.method_24515(), DoggySounds.WHISTLE_LONG.get(), class_3419.field_15248, 0.1f, 0.8f + level.field_9229.method_43057() * 0.2f);
        }
    }

    private void crossOriginTpForDogs(class_1937 level, class_1657 player, List<Dog> dogs) {
        if (level.field_9236) {
            return;
        }
        PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
        dogs = dogs.stream().filter(x -> !x.method_6172()).collect(Collectors.toList());
        if (dogs.isEmpty()) {
            return;
        }
        boolean all_cross_origin = true;
        for (Dog dog : dogs) {
            if (dog.crossOriginTp()) continue;
            all_cross_origin = false;
            break;
        }
        boolean switch_to = !all_cross_origin;
        for (Dog dog : dogs) {
            dog.setCrossOriginTp(switch_to);
        }
        if (switch_to) {
            PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43471((String)"dogcommand.cross_origin.set"));
        } else {
            PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43471((String)"dogcommand.cross_origin.unset"));
        }
    }

    private void allStandOnDuty(class_1937 level, class_1657 player, List<Dog> dogs) {
        if (level.field_9236) {
            return;
        }
        PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 20);
        int on_duty_count = 0;
        int not_on_duty_count = 0;
        for (Dog dog : dogs) {
            boolean on_duty_0 = dog.dogOnDuty();
            dog.setDogOnDuty(!dog.method_24345());
            boolean on_duty = dog.dogOnDuty();
            if (on_duty == on_duty_0) continue;
            if (on_duty) {
                ++on_duty_count;
                continue;
            }
            ++not_on_duty_count;
        }
        if (on_duty_count > 0 || not_on_duty_count > 0) {
            PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43469((String)"dogcommand.on_duty", (Object[])new Object[]{on_duty_count, not_on_duty_count}));
        }
    }

    private boolean canShh(class_1657 player, Dog dog) {
        return !(dog.method_5858((class_1297)player) > 256.0);
    }

    private void catchUp(class_1937 level, class_1657 player, List<Dog> dogs, boolean dogOnDutyOnly) {
        if (level.field_9236) {
            return;
        }
        PlayerUtil.addCooldown(player, DoggyItems.WHISTLE.get(), 40);
        int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
        List heel_list = dogs.stream().filter(filter_dog -> {
            if (dogOnDutyOnly && !filter_dog.dogOnDuty()) {
                return false;
            }
            if (filter_dog.method_24345()) {
                return false;
            }
            if (!filter_dog.getMode().shouldFollowOwner()) {
                return false;
            }
            return filter_dog.method_5858((class_1297)player) > 4.0;
        }).collect(Collectors.toList());
        if (max_heel_count > 0 && heel_list.size() > max_heel_count) {
            Collections.sort(heel_list, new EntityUtil.Sorter((class_1297)player));
            heel_list = heel_list.subList(0, max_heel_count);
        }
        if (heel_list.isEmpty()) {
            return;
        }
        for (Dog dog : dogs) {
            if (dog.method_24345() || !dog.getMode().shouldFollowOwner()) continue;
            dog.dogAi.clearTriggerableAction();
            dog.dogAi.requestFollow();
        }
        PlayerUtil.sendSystemMessage((class_1309)player, (class_2561)class_2561.method_43471((String)"dogcommand.catchup"));
    }

    public static boolean isDogOnDutyOnly(class_1799 stack) {
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        return tag.getBoolean("dog_on_duty_only");
    }

    public static boolean isHoldingDutyWhistle(class_1309 entity) {
        class_1799 stack = entity.method_6047();
        if (!stack.method_31574((class_1792)DoggyItems.WHISTLE.get())) {
            return false;
        }
        int mode = 0;
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag.containsAnyNumeric("mode")) {
            mode = (byte)class_3532.method_15340((int)tag.getByte("mode"), (int)0, (int)(WhistleMode.VALUES.length - 1));
        }
        return WhistleMode.VALUES[mode] == WhistleMode.DUTY_WHISTLE;
    }

    public class_2561 method_7864(class_1799 stack) {
        byte mode = 0;
        CompoundTag_1_21_5 tag = ItemUtil.getTag(stack);
        if (tag.containsAnyNumeric("mode")) {
            mode = tag.getByte("mode");
        }
        return class_2561.method_43471((String)(this.method_7876() + "." + mode));
    }

    @Override
    public void appendHoverText(class_1799 stack, class_1792.class_9635 context, List<class_2561> components, class_1836 flags) {
        String desc_id = this.method_7876() + ".description";
        components.add((class_2561)class_2561.method_43471((String)desc_id).method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
    }

    public static enum WhistleMode {
        STAND(0, WhistleSound.LONG),
        HEEL(1, WhistleSound.LONG),
        STAY(2, WhistleSound.SHORT),
        STOP_ATTACKING(3, WhistleSound.SHORT),
        SHELPERD(4, WhistleSound.SHORT),
        TACTICAL(5, WhistleSound.NONE),
        ROAR(6, WhistleSound.NONE),
        HEEL_BY_NAME(7, WhistleSound.NONE),
        TO_BED(8, WhistleSound.LONG),
        GO_BEHIND(9, WhistleSound.SHORT),
        HEEL_BY_GROUP(10, WhistleSound.NONE),
        MOB_RETRIEVER(11, WhistleSound.SHORT),
        HEEL_BY_LOOK(12, WhistleSound.SHORT),
        RIDE_WITH_ME(13, WhistleSound.SHORT),
        HOWL(14, WhistleSound.NONE),
        ALL_STAND_SWITCH_MODE(15, WhistleSound.NONE),
        SSSSSHHHH(16, WhistleSound.NONE),
        CROSS_ORIGIN_TP(17, WhistleSound.SHORT),
        BED_DOG_WHISTLE(18, WhistleSound.NONE),
        DUTY_WHISTLE(19, WhistleSound.SHORT),
        CARRY_ME(20, WhistleSound.NONE),
        BRIDING(21, WhistleSound.NONE),
        CATCH_UP(22, WhistleSound.SHORT);

        public static final WhistleMode[] VALUES;
        private int id;
        private WhistleSound sound;

        private WhistleMode(int id, WhistleSound sound) {
            this.id = id;
            this.sound = sound;
        }

        public int getIndex() {
            return this.id;
        }

        public WhistleSound getSound() {
            return this.sound;
        }

        public String getUnlocalisedTitle() {
            return "item.doggytalents.whistle." + this.getIndex();
        }

        public String getHelpMsg() {
            return this.getUnlocalisedTitle() + ".help";
        }

        static {
            VALUES = (WhistleMode[])Arrays.stream(WhistleMode.values()).sorted(Comparator.comparingInt(WhistleMode::getIndex)).toArray(WhistleMode[]::new);
        }
    }

    public static enum WhistleSound {
        NONE,
        SHORT,
        LONG;

    }
}

