/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.TalentsOptions;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_2487;

public class CreeperSweeperTalent
extends TalentInstance {
    private int cooldown;
    private boolean onlyAttackCreeper = false;

    public CreeperSweeperTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        this.cooldown = dogIn.field_6012;
    }

    @Override
    public void tick(AbstractDog dog) {
        if (this.level() > 0) {
            List list;
            if (this.canAttackCreeper() && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_CREEPER_SWEEPER_DONT_GROWL)).booleanValue()) {
                return;
            }
            int timeLeft = this.cooldown - dog.field_6012;
            if (!(timeLeft > 0 || dog.method_6172() && !dog.method_5765() || (list = dog.method_73183().method_18467(class_1548.class, dog.method_5829().method_1009((double)this.getSearchRange(dog), (double)(this.level() * 2), (double)this.getSearchRange(dog)))).isEmpty())) {
                dog.method_5783(((Dog)dog).dogMood.getSeriousGrowl(), dog.method_6107(), (dog.method_59922().method_43057() - dog.method_59922().method_43057()) * 0.2f + 1.0f);
                this.cooldown = dog.field_6012 + 60 + dog.method_59922().method_43048(40);
            }
        }
    }

    private int getSearchRange(AbstractDog dog) {
        if (dog instanceof Dog) {
            Dog d = (Dog)dog;
            if (d.isMode(DogMode.GUARD, DogMode.GUARD_FLAT, DogMode.GUARD_MINOR)) {
                return Math.min(this.level() * 5, 8);
            }
        }
        return this.level() * 5;
    }

    @Override
    public DogInteractionResult canAttack(AbstractDog dog, class_1309 entity) {
        if (this.canAttackCreeper() && this.onlyAttackCreeper) {
            return entity instanceof class_1548 ? DogInteractionResult.SUCCESS : DogInteractionResult.FAIL;
        }
        return entity instanceof class_1548 && this.canAttackCreeper() ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
    }

    @Override
    public DogInteractionResult shouldAttackEntity(AbstractDog dog, class_1309 target, class_1309 owner) {
        if (this.canAttackCreeper() && this.onlyAttackCreeper) {
            return target instanceof class_1548 ? DogInteractionResult.SUCCESS : DogInteractionResult.FAIL;
        }
        return target instanceof class_1548 && this.canAttackCreeper() ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
    }

    public boolean canAttackCreeper() {
        return this.level() >= 5;
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, class_1297 target) {
        if (!this.canAttackCreeper()) {
            return;
        }
        if (!(target instanceof class_1548)) {
            return;
        }
        class_1548 creeper = (class_1548)target;
        creeper.method_6033(0.0f);
        creeper.method_6078(dogIn.method_48923().method_48812((class_1309)dogIn));
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        this.onlyAttackCreeper = compound.getBoolean("targetOnlyCreeper");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10556("targetOnlyCreeper", this.onlyAttackCreeper);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.CREEPER_SWEEPER_EXC.get()) {
            return this.onlyAttackCreeper;
        }
        return null;
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.CREEPER_SWEEPER_EXC.get());
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.CREEPER_SWEEPER_EXC.get()) {
            this.onlyAttackCreeper = (Boolean)data;
        }
    }

    public boolean onlyAttackCreeper() {
        return this.onlyAttackCreeper;
    }

    public void setOnlyAttackCreeper(boolean val) {
        this.onlyAttackCreeper = val;
    }
}

