/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.enu.WetSource;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.talent.HellHoundTalent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3861;
import net.minecraft.class_39;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;

public class FisherDogTalent
extends TalentInstance {
    private int cookCooldown = 10;
    private boolean renderHat = true;

    public FisherDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.method_73183().field_9236) {
            return;
        }
        if (this.cookCooldown > 0) {
            --this.cookCooldown;
        }
    }

    @Override
    public void onShakingDry(AbstractDog dogIn, WetSource source) {
        if (dogIn.method_73183().field_9236) {
            return;
        }
        if (!source.isWaterBlock()) {
            return;
        }
        int r_fish = dogIn.method_59922().method_43048(15);
        if (r_fish >= this.level() * 2) {
            return;
        }
        class_1799 fishItem = this.getRandomFishingLoot(dogIn);
        class_1799 fishStack = this.getFishedStack(dogIn, fishItem);
        dogIn.method_5775((class_3218)dogIn.method_73183(), fishStack);
    }

    private class_1799 getRandomFishingLoot(AbstractDog dog) {
        class_1937 class_19372 = dog.method_73183();
        if (!(class_19372 instanceof class_3218)) {
            return class_1799.field_8037;
        }
        class_3218 sLevel = (class_3218)class_19372;
        class_5321 loot_table = class_39.field_795;
        class_5819 r = dog.method_59922();
        if (this.level() >= 5 && (double)r.method_43057() < 0.0125) {
            loot_table = class_39.field_854;
        }
        class_8567 loot_param = new class_8567.class_8568(sLevel).method_51875(class_173.field_1175);
        ObjectArrayList loot_list = sLevel.method_8503().method_58576().method_58295(loot_table).method_51878(loot_param);
        if (loot_list.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 ret = (class_1799)loot_list.get(r.method_43048(loot_list.size()));
        return ret.method_7972();
    }

    private class_1799 getFishedStack(AbstractDog dog, class_1799 raw_stack) {
        raw_stack = this.mayCookFish(dog, raw_stack);
        return raw_stack;
    }

    private class_1799 mayCookFish(AbstractDog dog, class_1799 fish_raw) {
        float r;
        if (this.cookCooldown > 0) {
            return fish_raw;
        }
        Optional hellhound_optional = dog.getTalent(DoggyTalents.HELL_HOUND);
        if (!hellhound_optional.isPresent()) {
            return fish_raw;
        }
        Object t = hellhound_optional.get();
        if (!(t instanceof HellHoundTalent)) {
            return fish_raw;
        }
        HellHoundTalent hellhound = (HellHoundTalent)t;
        if (!hellhound.canGenerateHeat()) {
            return fish_raw;
        }
        if (hellhound.level() < hellhound.getTalent().getMaxLevel() && (r = dog.method_59922().method_43057()) > 0.75f) {
            return fish_raw;
        }
        this.cookCooldown = 10;
        return this.tryCookFish(dog, fish_raw);
    }

    private class_1799 tryCookFish(AbstractDog dog, class_1799 fish_raw) {
        class_1863 recipeMan = ((class_3218)dog.method_73183()).method_64577();
        Optional recipeOptional = recipeMan.method_8132(class_3956.field_17546, (class_9695)new class_9696(fish_raw.method_7972()), dog.method_73183());
        if (!recipeOptional.isPresent()) {
            return fish_raw;
        }
        class_8786 recipe = (class_8786)recipeOptional.get();
        class_1799 resultStack = ((class_3861)recipe.comp_1933()).method_59998(new class_9696(fish_raw.method_7972()), (class_7225.class_7874)dog.method_73183().method_30349());
        if (resultStack == null || resultStack.method_7960()) {
            return fish_raw;
        }
        return resultStack.method_7972();
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        this.renderHat = compound.getBoolean("renderHat");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10556("renderHat", this.renderHat);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.FISHER_DOG_RENDER.get()) {
            return this.renderHat;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.FISHER_DOG_RENDER.get()) {
            this.renderHat = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.FISHER_DOG_RENDER.get());
    }

    public boolean canRenderHat() {
        return this.level() >= this.getTalent().getMaxLevel();
    }

    public boolean renderHat() {
        return this.renderHat;
    }

    public void setRenderHat(boolean hat) {
        this.renderHat = hat;
    }
}

