/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyAttributes;
import doggytalents.DoggyTalents;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.InteractionResultHolder;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.Util;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class WolfMountTalent
extends TalentInstance {
    private static final class_2960 WOLF_MOUNT_JUMP = Util.getResource("wolf_mount_jump");
    private int lastClickTick;

    public WolfMountTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        dogIn.setAttributeModifier(DoggyAttributes.JUMP_POWER.holder(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        dogIn.setAttributeModifier(DoggyAttributes.JUMP_POWER.holder(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void remove(AbstractDog dog) {
        dog.removeAttributeModifier(DoggyAttributes.JUMP_POWER.holder(), WOLF_MOUNT_JUMP);
    }

    public class_1322 createSpeedModifier(AbstractDog dogIn, class_2960 uuidIn) {
        if (this.level() > 0) {
            double speed = 0.06 * (double)this.level();
            if (this.level() >= 5) {
                speed += 0.04;
            }
            return new class_1322(uuidIn, speed, class_1322.class_1323.field_6328);
        }
        return null;
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog dog, class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960()) {
            return DogInteractionResult.PASS;
        }
        if (this.level() <= 0) {
            return DogInteractionResult.PASS;
        }
        if (dog.method_5782() || dog.method_5765()) {
            return DogInteractionResult.PASS;
        }
        if (!dog.canInteract((class_1309)player)) {
            return DogInteractionResult.PASS;
        }
        if (player.method_5765()) {
            return DogInteractionResult.PASS;
        }
        int lastClickTick0 = this.lastClickTick;
        this.lastClickTick = player.field_6012;
        if (this.lastClickTick - lastClickTick0 > 5) {
            return DogInteractionResult.PASS;
        }
        if (!dog.method_73183().field_9236) {
            dog.method_24346(false);
            player.method_36456(dog.method_36454());
            player.method_36457(dog.method_36455());
            player.method_5804((class_1297)dog);
        }
        return DogInteractionResult.SUCCESS;
    }

    @Override
    public void livingTick(AbstractDog dog) {
        if (dog.method_5782() && dog.getDogHunger() < 1.0f) {
            class_1309 control = dog.method_5642();
            if (control != null) {
                PlayerUtil.sendSystemMessage(control, (class_2561)class_2561.method_43469((String)"talent.doggytalents.wolf_mount.exhausted", (Object[])new Object[]{dog.method_5477()}));
            }
            dog.method_5772();
        }
    }

    @Override
    public InteractionResultHolder<Float> hungerTick(AbstractDog dogIn, float hungerTick_add) {
        if (dogIn.method_5642() != null) {
            return InteractionResultHolder.success(Float.valueOf(hungerTick_add += this.level() < 5 ? 3.0f : 1.0f));
        }
        return InteractionResultHolder.pass(Float.valueOf(hungerTick_add));
    }

    @Override
    public InteractionResultHolder<Float> calculateFallDistance(AbstractDog dogIn, float distance) {
        if (this.level() >= 5) {
            return InteractionResultHolder.success(Float.valueOf(distance - 1.0f));
        }
        return InteractionResultHolder.pass(Float.valueOf(0.0f));
    }

    @Override
    public DogInteractionResult shouldSkipAttackFrom(AbstractDog dogIn, class_1297 entity) {
        return dogIn.method_5794(entity) ? DogInteractionResult.SUCCESS : DogInteractionResult.PASS;
    }

    public static boolean isValidCarryMeDog(Dog dog) {
        if (!dog.method_5805()) {
            return false;
        }
        if (dog.method_5782() || dog.method_5765()) {
            return false;
        }
        return dog.getDogLevel(DoggyTalents.WOLF_MOUNT) > 0;
    }

    public static boolean isValidCarryMeTarget(class_1309 target) {
        if (!(target instanceof class_1657)) {
            return false;
        }
        if (!target.method_5805() || target.method_7325()) {
            return false;
        }
        return !target.method_5782() && !target.method_5765();
    }
}

