/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.common.backward_imitate.EntityUtil_1_21_5;
import doggytalents.common.util.ItemUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7;

public class EntityUtil {
    public static double getFollowRange(class_1309 entityIn) {
        class_1324 rangeAttribute = entityIn.method_5996(class_5134.field_23717);
        return rangeAttribute == null ? 16.0 : rangeAttribute.method_6194();
    }

    public static boolean tryToTeleportNearEntity(class_1308 entityIn, class_1408 navigator, class_1309 target, int radius) {
        return EntityUtil.tryToTeleportNearEntity(entityIn, navigator, target.method_24515(), radius);
    }

    public static boolean tryToTeleportNearEntity(class_1308 entityIn, class_1408 navigator, class_2338 targetPos, int radius) {
        for (int i = 0; i < 10; ++i) {
            int j = EntityUtil.getRandomNumber((class_1309)entityIn, -radius, radius);
            int k = EntityUtil.getRandomNumber((class_1309)entityIn, -1, 1);
            int l = EntityUtil.getRandomNumber((class_1309)entityIn, -radius, radius);
            boolean flag = EntityUtil.tryToTeleportToLocation(entityIn, navigator, targetPos, targetPos.method_10263() + j, targetPos.method_10264() + k, targetPos.method_10260() + l);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean tryToTeleportToLocation(class_1308 entityIn, class_1408 navigator, class_2338 targetPos, int x, int y, int z) {
        if ((double)Math.abs(x - targetPos.method_10263()) < 2.0 && (double)Math.abs(z - targetPos.method_10260()) < 2.0) {
            return false;
        }
        if (!EntityUtil.isTeleportFriendlyBlock(entityIn, new class_2338(x, y, z), false)) {
            return false;
        }
        entityIn.method_5808((double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f), entityIn.method_36454(), entityIn.method_36455());
        navigator.method_6340();
        return true;
    }

    private static boolean isTeleportFriendlyBlock(class_1308 entityIn, class_2338 pos, boolean teleportToLeaves) {
        class_7 pathnodetype = class_14.method_57625((class_1308)entityIn, (class_2338)pos.method_25503());
        if (pathnodetype != class_7.field_12) {
            return false;
        }
        class_2680 blockstate = entityIn.method_73183().method_8320(pos.method_10074());
        if (!teleportToLeaves && blockstate.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockpos = pos.method_10059((class_2382)entityIn.method_24515());
        return entityIn.method_73183().method_8587((class_1297)entityIn, entityIn.method_5829().method_996(blockpos));
    }

    public static int getRandomNumber(class_1309 entityIn, int minIn, int maxIn) {
        return entityIn.method_59922().method_43048(maxIn - minIn + 1) + minIn;
    }

    public static boolean isHolding(@Nullable class_1309 entity, class_1792 item, Predicate<CompoundTag_1_21_5> nbtPredicate) {
        return EntityUtil.isHolding(entity, (class_1799 stack) -> stack.method_7909() == item && ItemUtil.hasTag(stack) && nbtPredicate.test(ItemUtil.getTag(stack)));
    }

    public static boolean isHolding(@Nullable class_1309 entity, class_1792 item) {
        return EntityUtil.isHolding(entity, (class_1799 stack) -> stack.method_7909() == item);
    }

    public static boolean isHolding(@Nullable class_1309 entity, Predicate<class_1799> matcher) {
        if (entity == null) {
            return false;
        }
        for (class_1799 stack : EntityUtil_1_21_5.getHandSlot(entity)) {
            if (!matcher.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static <T extends class_1297> T getClosestTo(class_1297 center, Iterable<T> entities) {
        return EntityUtil.getClosestTo(center.method_73189(), entities);
    }

    public static <T extends class_1297> T getClosestTo(class_243 posVec, Iterable<T> entities) {
        double smallestDist = Double.MAX_VALUE;
        class_1297 closest = null;
        for (class_1297 entity : entities) {
            double distance = posVec.method_1025(entity.method_73189());
            if (!(distance < smallestDist)) continue;
            closest = entity;
            smallestDist = distance;
        }
        return (T)closest;
    }

    public static void setSecondsOnFire(class_1297 e, int second) {
        e.method_20803(second * 20);
    }

    public static <T extends class_1297> Optional<T> getRandomEntityAround(class_1309 entity, Class<T> entity_class, int radius_xz, int radius_y, Predicate<T> entity_pred) {
        Predicate<class_1297> compound_pred;
        class_238 bb;
        class_1937 level = entity.method_73183();
        List list = level.method_8390(entity_class, bb = entity.method_5829().method_1009((double)radius_xz, (double)radius_y, (double)radius_xz), compound_pred = filter -> filter != entity && entity_pred.test(filter));
        if (list.isEmpty()) {
            return Optional.empty();
        }
        if (list.size() == 1) {
            return Optional.of((class_1297)list.get(0));
        }
        class_5819 random = entity.method_59922();
        int r = random.method_43048(list.size());
        return Optional.of((class_1297)list.get(r));
    }

    public static boolean allHandEmpty(class_1309 entity) {
        class_1799 mainhand = entity.method_6047();
        if (mainhand != null && !mainhand.method_7960()) {
            return false;
        }
        class_1799 offhand = entity.method_6079();
        return offhand == null || offhand.method_7960();
    }

    public static boolean isWaterBreathingEntity(class_1309 entity) {
        return entity.method_6094();
    }

    public static class Sorter
    implements Comparator<class_1297> {
        private final class_243 vec3d;

        public Sorter(class_1297 entityIn) {
            this.vec3d = entityIn.method_73189();
        }

        public Sorter(class_243 vec3d) {
            this.vec3d = vec3d;
        }

        @Override
        public int compare(class_1297 entity1, class_1297 entity2) {
            double d0 = this.vec3d.method_1025(entity1.method_73189());
            double d1 = this.vec3d.method_1025(entity2.method_73189());
            return Double.compare(d0, d1);
        }
    }
}

